
class Vect3d {

  constructor(x = 0, y = 0, z = 0) {
    if (x instanceof Vect3d) {
      this.x = x.x;
      this.y = x.y;
      this.z = x.z;
    }
    else {
      this.x = x;
      this.y = y;
      this.z = z;
    }
  }

  sumsq() {
    return this.x * this.x + this.y * this.y + this.z * this.z;
  }

  // used in orbital calculations

  acceleration() {
    return Math.pow(this.sumsq(), -1.5);
  }

  // hypotenuse of three-element vector

  mag() {
    return Math.sqrt(this.sumsq());
  }

  arg() {
    return Math.atan2(this.y, this.x);
  }

  // accumulate values

  add(v) {
    return new Vect3d(this.x + v.x, this.y + v.y, this.z + v.z);
  }

  // add to existing class instance

  addTo(v) {
    this.x += v.x;
    this.y += v.y;
    this.z += v.z;
  }

  // subtract a vector

  sub(v) {
    return new Vect3d(this.x - v.x, this.y - v.y, this.z - v.z);
  }

  // multiply by a scalar or vector

  mult(v) {
    if (v instanceof Vect3d) {
      return new Vect3d(this.x * v.x, this.y * v.y, this.z * v.z);
    }
    else {
      return new Vect3d(this.x * v, this.y * v, this.z * v);
    }
  }

  real() {
    return x;
  }

  imag() {
    return y;
  }

  show() {
    return ("Vect3d:" + this.x + "," + this.y + "," + this.z);
  }

  // 3D rotation matrices

  // see https://mathworld.wolfram.com/RotationMatrix.html

  // generic rotate function using provided rotation matrix

  // assigns result to instance variables

  rotate(rotmatrix) {
    let values = [this.x, this.y, this.z];
    let result = [0.0, 0.0, 0.0];
    for (let col of [0, 1, 2]) {
      for (let row of [0, 1, 2]) {
        result[col] += values[row] * rotmatrix[col][row];
      }
    }
    [this.x, this.y, this.z] = result;
  }

  rotx(a) {
    let rotmatrix = [
      // X
      [1.0, 0.0, 0.0],
      [0.0, Math.cos(a), Math.sin(a)],
      [0.0, -Math.sin(a), Math.cos(a)],
    ];
    this.rotate(rotmatrix);
  }

  roty(a) {
    let rotmatrix = [
      // Y
      [Math.cos(a), 0.0, -Math.sin(a)],
      [0.0, 1.0, 0.0],
      [Math.sin(a), 0.0, Math.cos(a)],
    ];
    this.rotate(rotmatrix);
  }

  rotz(a) {
    let rotmatrix = [
      // Z
      [Math.cos(a), Math.sin(a), 0.0],
      [-Math.sin(a), Math.cos(a), 0.0],
      [0.0, 0.0, 1.0],
    ];
    this.rotate(rotmatrix);
  }
}

module.exports = { Vect3d };
