"use strict"

let { Vect3d } = require(`./vect3d.js`);

class Main {

  // format scientific notation with p decimal places and f fieldsize
  sci(v, p, f = 0) {
    v = v.toExponential(p);
    return String(v).padStart(f, '0');
  }

  // format fixed-place notation with p decimal places and f fieldsize
  fix(v, p, f = 0) {
    v = v.toFixed(p);
    return String(v).padStart(f, '0');
  }

  torad(v) {
    return v * Math.PI / 180.0;
  }

  formatrow(vect) {
    let s = ``;
    for (let v of [vect.x, vect.y, vect.z]) {
      s += `${this.fix(v, 3)} `
    }
    return s;
  }

  main() {
    let ar = this.torad(10);
    for (let rot of [0, 1, 2]) {
      console.log(`ROT${['X','Y','Z'][rot]}\n`)
      console.log("  arg°  x     y     z");
      console.log("  -----------------------");
      let v = [new Vect3d(0, 0, 1),new Vect3d(1, 0, 0),new Vect3d(0, 1, 0)][rot];
      for (let a = 0; a <= 90; a += 10) {
        let s = `  ${this.fix(a, 2, 5)} ${this.formatrow(v)}`
        console.log(s);
        switch(rot) {
          case 0:
            v.rotx(ar);
            break;
          case 1:
            v.roty(ar);
            break;
          case 2:
            v.rotz(ar);
        }
      }
      console.log("\n");
    }

  }
}

let mainclass = new Main();
mainclass.main();