/***************************************************************************
 *   Copyright (C) 2021, Paul Lutus                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

"use strict";let spawn,orbit;_ba1‍.w("child_process",[["spawn",["spawn"],function(v){spawn=v}]]);_ba1‍.w("orbit.mjs",[["default",["orbit"],function(v){orbit=v}]]);

// video framerate

var framerate = 30

var w = 960
var h = 540

var frame = 0;

var frames = 100;

//var anaglyph = true;

// the copyright metadata isn't included when a pipe is used

var args = [
'-y','-r', ''+framerate , '-f','image2pipe',
'-i', '-',
'-c:v', 'png',
'-vf','colorkey=0x000000',
 '../renders/orbit_' + w + 'x' + h + '_' + frames + '.mp4',
'-metadata','copyright="(C) 2019, P. Lutus https://arachnoid.com"',
];



var ffmpeg = spawn('ffmpeg', args);

// only for debugging

//ffmpeg.stderr.pipe(process.stdout);



const { Orbit } = orbit;

var bp = new Orbit(w,h);

//bp.anaglyph = anaglyph;

process.stdout.write(`Creating animation ...\n`);

var n = 0;
var frameinterval = 300;

while(bp.running) {
  bp.process();
  if (n % frameinterval == 0) {
    process.stdout.write(`Animation frame ${frame} \r`);
    ffmpeg.stdin.write(bp.getbuffer());
    frame += 1;
  }
  n += 1;
}

ffmpeg.stdin.end();

process.stdout.write("\nDone.\n");
