public class Vect3d {

  private double x;
  private double y;
  private double z;

  public Vect3d(double x, double y, double z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }

  private double sumsq() {
    return this.x * this.x + this.y * this.y + this.z * this.z;
  }

  public double acceleration() {
    return Math.pow(this.sumsq(), -1.5);
  }

  public double mag() {
    return Math.sqrt(this.sumsq());
  }

  Vect3d add(Vect3d v) {
    return new Vect3d(this.x + v.x, this.y + v.y, this.z + v.z);
  }

  public void addTo(Vect3d v) {
    this.x += v.x;
    this.y += v.y;
    this.z += v.z;
  }

  public Vect3d mult(Vect3d v) {
    return new Vect3d(this.x * v.x, this.y * v.y, this.z * v.z);
  }

  public Vect3d mult(double v) {
    return new Vect3d(this.x * v, this.y * v, this.z * v);
  }

}
