#include <iostream>
#include <cstdio>
#include <string>
#include <cmath>
#define FMT_HEADER_ONLY
#include <fmt/format.h>

#include "vect3d.h"

Vect3d::Vect3d()
{
  this->x = 0;
  this->y = 0;
  this->z = 0;
}
Vect3d::~Vect3d()
{
}
Vect3d::Vect3d(double x, double y, double z)
{
  this->x = x;
  this->y = y;
  this->z = z;
}
Vect3d::Vect3d(const Vect3d &v)
{
  this->x = v.x;
  this->y = v.y;
  this->z = v.z;
}

double Vect3d::sumsq()
{
  return this->x * this->x + this->y * this->y + this->z * this->z;
}

double Vect3d::acceleration()
{
  return pow(sumsq(), -1.5);
}
double Vect3d::mag()
{
  return sqrt(sumsq());
}
Vect3d Vect3d::operator-(Vect3d v)
{
  return Vect3d(this->x - v.x, this->y - v.y, this->z - v.z);
}
Vect3d Vect3d::operator+(Vect3d v)
{
  return Vect3d(this->x + v.x, this->y + v.y, this->z + v.z);
}
Vect3d &Vect3d::operator*=(double v)
{
  this->x *= v;
  this->y *= v;
  this->z *= v;
  return *this;
}
Vect3d &Vect3d::operator*=(const Vect3d v)
{
  this->x *= v.x;
  this->y *= v.y;
  this->z *= v.z;
  return *this;
}
Vect3d &Vect3d::operator-=(const Vect3d v)
{
  this->x -= v.x;
  this->y -= v.y;
  this->z -= v.z;
  return *this;
}
Vect3d &Vect3d::operator+=(const Vect3d v)
{
  this->x += v.x;
  this->y += v.y;
  this->z += v.z;
  return *this;
}
Vect3d Vect3d::operator*(Vect3d v)
{
  return Vect3d(this->x * v.x, this->y * v.y, this->z * v.z);
}
Vect3d Vect3d::operator*(double v)
{
  return Vect3d(this->x * v, this->y * v, this->z * v);
}
string Vect3d::show()
{
  return fmt::format("{:+8.2e},{:+8.2e},{:+8.2e}", this->x, this->y, this->z);
}
