/***************************************************************************
 *   Copyright (C) 2016 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

import java.util.Calendar;
import java.util.GregorianCalendar;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author lutusp
 */
public class MagneticDeclination {

    GeoMagConstants constants;

    public MagneticDeclination() {
        constants = new GeoMagConstants();
    }

    double inrange(double x, double xa, double xb) {
        x = Math.max(x, xa);
        x = Math.min(x, xb);
        return x;
    }

    double ntrp(double x, double xa, double xb, double ya, double yb) {
        return (yb - ya) * (x - xa) / (xb - xa) + ya;
    }

    double ntrp2d(double[][] mat, double lat, double lng, int iv, int szx, int szy) {
        int ya = (int) (lat / iv);
        int yb = ya + 1;
        double yav = ya * iv;
        double ybv = yb * iv;
        // limit latitude index range
        ya = (int) inrange(ya, 0, szy - 1);
        yb = (int) inrange(yb, 0, szy - 1);
        int xa = (int) (lng / iv);
        int xb = xa + 1;
        double xav = xa * iv;
        double xbv = xb * iv;
        // allow longitude indices to wrap around
        xa = (xa + szx) % szx;
        xb = (xb + szx) % szx;
        // interpolate in 2D using 4 corner values
        double vaa = mat[ya][xa];
        double vab = mat[ya][xb];
        double vba = mat[yb][xa];
        double vbb = mat[yb][xb];
        // interpolate two longitudes
        double vxa = ntrp(lng, xav, xbv, vaa, vab);
        double vxb = ntrp(lng, xav, xbv, vba, vbb);
        // interpolate latitude
        return ntrp(lat, yav, ybv, vxa, vxb);
    }

    public double computePoint(double lat, double lng) {
        int iv = constants.gi;
        // latitude (row count)
        int szy = constants.mat_a.length;
        // longitude (column count)
        int szx = constants.mat_b[0].length;
        // convert latitude and longitude
        // to unsigned forms
        lat += 90 - iv;
        lng += 180;
        // interpolate declination in two dimensions
        // for two year matrices defined in constants
        double ya = ntrp2d(constants.mat_a, lat, lng, iv, szx, szy);
        double yb = ntrp2d(constants.mat_b, lat, lng, iv, szx, szy);
        // interpolate to time argument
        long timeA = new GregorianCalendar(constants.year_a, 1, 1, 0, 0, 0).getTime().getTime();
        long timeB = new GregorianCalendar(constants.year_b, 1, 1, 0, 0, 0).getTime().getTime();
        long now = Calendar.getInstance().getTime().getTime();
        double v = ntrp(now, timeA,timeB, ya, yb);
        return v;
    }

    /**
     * @param args the command line arguments
     */
    //public static void main(String[] args) {
    //    if (args.length < 3) {
    //        System.out.println("usage: lat long year");
    //    } else {
    //        MagneticDeclination magdecl = new MagneticDeclination();
    //        double lat = Double.parseDouble(args[0]);
    //        double lng = Double.parseDouble(args[1]);
    //        double year = Double.parseDouble(args[2]);
    //        double v = magdecl.computePoint(lat, lng, year);
    //        System.out.println(String.format("Result: %.3f", v));
    //    }
    //}

}
