/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.GregorianCalendar;

public class MagneticDeclination {
    GeoMagConstants constants = new GeoMagConstants();

    double inrange(double x, double xa, double xb) {
        x = Math.max(x, xa);
        x = Math.min(x, xb);
        return x;
    }

    double ntrp(double x, double xa, double xb, double ya, double yb) {
        return (yb - ya) * (x - xa) / (xb - xa) + ya;
    }

    double ntrp2d(double[][] mat, double lat, double lng, int iv, int szx, int szy) {
        int ya = (int)(lat / (double)iv);
        int yb = ya + 1;
        double yav = ya * iv;
        double ybv = yb * iv;
        ya = (int)this.inrange(ya, 0.0, szy - 1);
        yb = (int)this.inrange(yb, 0.0, szy - 1);
        int xa = (int)(lng / (double)iv);
        int xb = xa + 1;
        double xav = xa * iv;
        double xbv = xb * iv;
        xa = (xa + szx) % szx;
        xb = (xb + szx) % szx;
        double vaa = mat[ya][xa];
        double vab = mat[ya][xb];
        double vba = mat[yb][xa];
        double vbb = mat[yb][xb];
        double vxa = this.ntrp(lng, xav, xbv, vaa, vab);
        double vxb = this.ntrp(lng, xav, xbv, vba, vbb);
        return this.ntrp(lat, yav, ybv, vxa, vxb);
    }

    public double computePoint(double lat, double lng) {
        int iv = this.constants.gi;
        int szy = this.constants.mat_a.length;
        int szx = this.constants.mat_b[0].length;
        double ya = this.ntrp2d(this.constants.mat_a, lat += (double)(90 - iv), lng += 180.0, iv, szx, szy);
        double yb = this.ntrp2d(this.constants.mat_b, lat, lng, iv, szx, szy);
        long timeA = new GregorianCalendar(this.constants.year_a, 1, 1, 0, 0, 0).getTime().getTime();
        long timeB = new GregorianCalendar(this.constants.year_b, 1, 1, 0, 0, 0).getTime().getTime();
        long now = Calendar.getInstance().getTime().getTime();
        double v = this.ntrp(now, timeA, timeB, ya, yb);
        return v;
    }
}

