/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.TreeMap;

public final class LocationHandler {
    SatFinder parent;
    String zipPath = "ZipDivisions";
    String statePath = "States";
    String keyFileName = "keys.txt";
    TreeMap states = null;
    TreeMap zipDivs = null;

    public LocationHandler(SatFinder p) {
        this.parent = p;
        this.states = new TreeMap();
        this.zipDivs = new TreeMap();
    }

    public void buildDataFiles() {
        this.parent.showProgressBar(true);
        final File f = new File(this.parent.zipPath);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                LocationHandler.this.readZipCodesThread(f);
            }
        };
        t1.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readZipCodesThread(File path) {
        TreeMap t_states = new TreeMap();
        TreeMap t_zipDivs = new TreeMap();
        HashMap t_cities = new HashMap();
        BufferedReader br = null;
        try {
            String line;
            URL url = this.parent.getClass().getResource("zip_database.txt");
            InputStream is = url.openStream();
            br = new BufferedReader(new InputStreamReader(is));
            int max = is.available();
            int len = 0;
            while ((line = br.readLine()) != null) {
                this.parent.updateProgressBar("Reading ZIP data file", 0, max, len += line.length() + 1);
                String[] array = line.split("\\|");
                if (array.length == 6) {
                    this.parseZipRecord(line, array, t_states, t_zipDivs, t_cities);
                    continue;
                }
                throw new Exception("Malformed record in ZIP data file \"" + url + "\": \"" + line + "\"");
            }
            this.createDataFiles(path, t_states, t_zipDivs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.parent.updateProgressBar("", 0, 0, 0);
        this.parent.showProgressBar(false);
        this.parent.setup();
    }

    private void parseZipRecord(String line, String[] array, TreeMap t_states, TreeMap t_zipDivs, HashMap t_cities) {
        String cskey;
        ZipRecord zr = new ZipRecord(array);
        if (!t_states.containsKey(zr.state)) {
            t_states.put(zr.state, new TreeMap());
        }
        if (!t_cities.containsKey(cskey = zr.state + "." + zr.city)) {
            TreeMap state = (TreeMap)t_states.get(zr.state);
            state.put(zr.zip, line);
            t_cities.put(cskey, true);
        }
        int z = Integer.parseInt(zr.zip);
        String zipKey = "" + z / 1000;
        if (!t_zipDivs.containsKey(zipKey)) {
            t_zipDivs.put(zipKey, new TreeMap());
        }
        TreeMap zd = (TreeMap)t_zipDivs.get(zipKey);
        zd.put(zr.zip, zr.toString());
    }

    private void createDataFiles(File path, TreeMap t_states, TreeMap t_zipDivs) {
        File sp = new File(path, this.statePath);
        sp.mkdirs();
        String[] keys = t_states.keySet().toArray(new String[0]);
        this.writeKeyFile(sp, keys);
        for (int i = 0; i < keys.length; ++i) {
            this.parent.updateProgressBar("Writing ZIP data files", 0, keys.length, i);
            this.writeZipFile(sp, keys[i], t_states);
        }
        File zp = new File(path, this.zipPath);
        zp.mkdirs();
        keys = t_zipDivs.keySet().toArray(new String[0]);
        this.writeKeyFile(zp, keys);
        for (int i = 0; i < keys.length; ++i) {
            this.parent.updateProgressBar("Writing state data files", 0, keys.length, i);
            this.writeZipFile(zp, keys[i], t_zipDivs);
        }
    }

    private void writeZipFile(File path, String key, TreeMap map) {
        try {
            TreeMap tm = (TreeMap)map.get(key);
            File f = new File(path, key + ".txt");
            FileWriter fw = new FileWriter(f);
            String[] keys = tm.keySet().toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                String line = (String)tm.get(keys[i]);
                fw.write(line + this.parent.lineSep);
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeKeyFile(File path, String[] array) {
        try {
            String keyString = this.join(array, "|");
            File f = new File(path, this.keyFileName);
            FileWriter fw = new FileWriter(f);
            fw.write(keyString + this.parent.lineSep);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String join(String[] fields, String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(fields[i]);
        }
        return sb.toString();
    }

    public String[] getStateKeys() {
        String[] array = null;
        try {
            File f = new File(this.parent.zipPath + "/" + this.statePath + "/" + this.keyFileName);
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            br.close();
            array = line.split("\\|");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return array;
    }

    public String[] getCityNames(String key) {
        return this.getKeys(this.states, key);
    }

    private void loadDataSection(TreeMap map, String key) {
        try {
            String line;
            TreeMap<String, ZipRecord> section = new TreeMap<String, ZipRecord>();
            map.put(key, section);
            String sec = map == this.states ? this.statePath : this.zipPath;
            File f = new File(this.parent.zipPath + "/" + sec + "/" + key + ".txt");
            if (!f.exists()) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((line = br.readLine()) != null) {
                String[] array = line.split("\\|");
                if (array.length == 6) {
                    ZipRecord zr = new ZipRecord(array);
                    if (map == this.states) {
                        section.put(zr.city, zr);
                        continue;
                    }
                    section.put(zr.zip, zr);
                    continue;
                }
                throw new Exception("Malformed record in data file \"" + f.getPath() + "\": \"" + line + "\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getKeys(TreeMap map, String key) {
        if (!map.containsKey(key)) {
            this.loadDataSection(map, key);
        }
        String[] array = null;
        TreeMap sub = (TreeMap)map.get(key);
        if (sub != null) {
            array = sub.keySet().toArray(new String[0]);
        }
        return array;
    }

    private ZipRecord getZipRecord(TreeMap map, String section, String key) {
        if (!map.containsKey(section)) {
            this.loadDataSection(map, section);
        }
        TreeMap tm = (TreeMap)map.get(section);
        ZipRecord zr = (ZipRecord)tm.get(key);
        return zr;
    }

    public ZipRecord getZipRecordFromCity(String state, String key) {
        return this.getZipRecord(this.states, state, key);
    }

    public ZipRecord getZipRecordFromZip(String key) {
        int n = Integer.parseInt(key.trim());
        String section = "" + n / 1000;
        return this.getZipRecord(this.zipDivs, section, key);
    }
}

