/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;

public final class DataFileManager {
    static final String lineSep = System.getProperty("line.separator");
    private static final String delim = "\t";

    public static void writeObjectToFile(String path, Object ob, String fieldPrefix) {
        try {
            FileWriter fw = new FileWriter(path);
            if (!DataFileManager.testFileAccess(new File(path))) {
                return;
            }
            Field[] publicFields = ob.getClass().getFields();
            String[] fieldNames = DataFileManager.getFieldNames(publicFields, fieldPrefix);
            String[] headerNames = DataFileManager.getHeaderNames(fieldNames, fieldPrefix);
            for (int i = 0; i < fieldNames.length; ++i) {
                Field f = ob.getClass().getDeclaredField(fieldNames[i]);
                String row = headerNames[i] + "=" + DataFileManager.getFieldValueAsString(f, ob);
                fw.write(row);
                fw.write(lineSep);
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean testFileAccess(File f) {
        boolean ok = false;
        if (!f.exists()) {
            f = new File(f.getParent());
        }
        boolean read = f.canRead();
        boolean write = f.canWrite();
        boolean bl = ok = read && write;
        if (!ok) {
            String error = "";
            error = !read && !write ? "read or write" : (!read ? "read" : "write");
            String message = "This program cannot " + error + " one or more of its essential configuration files.\n\nPlease correct this file permission problem and try again.";
            JOptionPane.showMessageDialog(null, message, "File/Directory Access error.", 2);
        }
        return ok;
    }

    public static Vector readObjectFromFile(String path, Object ob, String fieldPrefix) {
        Vector data = new Vector();
        try {
            File f = new File(path);
            if (!DataFileManager.testFileAccess(f)) {
                return data;
            }
            if (f.exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(path));
                while ((line = br.readLine()) != null) {
                    int p = line.indexOf("=");
                    if (p == -1) continue;
                    String name = fieldPrefix + line.substring(0, p);
                    String value = line.substring(p + 1);
                    DataFileManager.parseSingleValue(ob, name, value);
                }
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static void writeDataTable(String path, Vector data, Object obj, String fieldPrefix) {
        try {
            if (!DataFileManager.testFileAccess(new File(path))) {
                return;
            }
            FileWriter fw = new FileWriter(path);
            Field[] publicFields = obj.getClass().getFields();
            String[] fieldNames = DataFileManager.getFieldNames(publicFields, fieldPrefix);
            String[] headerNames = DataFileManager.getHeaderNames(fieldNames, fieldPrefix);
            fw.write(DataFileManager.join(headerNames, delim));
            fw.write(lineSep);
            for (int i = 0; i < data.size(); ++i) {
                Object ob = data.get(i);
                String[] record = DataFileManager.createRecord(ob, fieldNames);
                fw.write(DataFileManager.join(record, delim));
                fw.write(lineSep);
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeDataTable(String path, TreeMap data, Object obj, String fieldPrefix) {
        try {
            String[] keys = data.keySet().toArray(new String[0]);
            if (!DataFileManager.testFileAccess(new File(path))) {
                return;
            }
            FileWriter fw = new FileWriter(path);
            Field[] publicFields = obj.getClass().getFields();
            String[] fieldNames = DataFileManager.getFieldNames(publicFields, fieldPrefix);
            String[] headerNames = DataFileManager.getHeaderNames(fieldNames, fieldPrefix);
            fw.write(DataFileManager.join(headerNames, delim));
            fw.write(lineSep);
            for (int i = 0; i < keys.length; ++i) {
                Object ob = data.get(keys[i]);
                String[] record = DataFileManager.createRecord(ob, fieldNames);
                fw.write(DataFileManager.join(record, delim));
                fw.write(lineSep);
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String[] createRecord(Object ob, String[] fieldNames) {
        String[] result = new String[fieldNames.length];
        try {
            for (int i = 0; i < fieldNames.length; ++i) {
                Field f = ob.getClass().getDeclaredField(fieldNames[i]);
                result[i] = DataFileManager.getFieldValueAsString(f, ob);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getFieldValueAsString(Field f, Object ob) {
        String result = "";
        try {
            result = f.getType().isAssignableFrom(Boolean.TYPE) ? ((Boolean)f.get(ob) != false ? "1" : "0") : (f.getType().isAssignableFrom(Boolean.class) ? ((Boolean)f.get(ob) != false ? "1" : "0") : String.valueOf(f.get(ob)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean readDataTable(String path, Vector data, Object o, String fieldPrefix) {
        boolean wasRead = false;
        try {
            File f = new File(path);
            if (!DataFileManager.testFileAccess(f)) {
                return false;
            }
            if (f.exists()) {
                wasRead = true;
                BufferedReader br = new BufferedReader(new FileReader(path));
                String line = br.readLine();
                String[] headerNames = DataFileManager.split(line, delim);
                String[] fieldNames = DataFileManager.makeFieldNames(headerNames, fieldPrefix);
                while ((line = br.readLine()) != null) {
                    String[] values = DataFileManager.split(line, delim);
                    Object ob = o.getClass().newInstance();
                    DataFileManager.parseRecordValues(ob, fieldNames, values);
                    data.add(ob);
                }
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wasRead;
    }

    public static void readDataTable(String path, TreeMap data, Object obj, String fieldPrefix) {
        try {
            File f = new File(path);
            if (!DataFileManager.testFileAccess(f)) {
                return;
            }
            if (f.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(path));
                String line = br.readLine();
                String[] headerNames = DataFileManager.split(line, delim);
                String[] fieldNames = DataFileManager.makeFieldNames(headerNames, fieldPrefix);
                while ((line = br.readLine()) != null) {
                    String[] values = DataFileManager.split(line, delim);
                    Object ob = obj.getClass().newInstance();
                    DataFileManager.parseRecordValues(ob, fieldNames, values);
                    data.put(values[0], ob);
                }
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String[] makeFieldNames(String[] headerNames, String fieldPrefix) {
        if (headerNames == null) {
            return null;
        }
        String[] result = new String[headerNames.length];
        for (int i = 0; i < headerNames.length; ++i) {
            result[i] = fieldPrefix + headerNames[i];
        }
        return result;
    }

    private static void parseRecordValues(Object ob, String[] fieldNames, String[] values) {
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            String value = values[i];
            DataFileManager.parseSingleValue(ob, name, value);
        }
    }

    static void parseSingleValue(Object ob, String name, String value) {
        try {
            Field f = ob.getClass().getDeclaredField(name);
            Class<Object> fieldClass = f.getType();
            if (fieldClass.isAssignableFrom(String.class)) {
                f.set(ob, value);
            } else if (fieldClass.isAssignableFrom(Boolean.class)) {
                f.set(ob, new Boolean(value.equals("1")));
            } else if (fieldClass.isAssignableFrom(Boolean.TYPE)) {
                f.set(ob, new Boolean(value.equals("1")));
            } else if (fieldClass.isAssignableFrom(Integer.class)) {
                f.set(ob, new Integer(value));
            } else if (fieldClass.isAssignableFrom(Integer.TYPE)) {
                f.set(ob, new Integer(value));
            } else if (fieldClass.isAssignableFrom(Long.class)) {
                f.set(ob, new Long(value));
            } else if (fieldClass.isAssignableFrom(Long.TYPE)) {
                f.set(ob, new Long(value));
            } else if (fieldClass.isAssignableFrom(Double.class)) {
                f.set(ob, new Double(value));
            } else if (fieldClass.isAssignableFrom(Double.TYPE)) {
                f.set(ob, new Double(value));
            } else if (fieldClass.isAssignableFrom(Color.class)) {
                String s = value.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2\t$3");
                String[] val = s.split(delim);
                f.set(ob, new Color(Integer.parseInt(val[0]), Integer.parseInt(val[1]), Integer.parseInt(val[2])));
            } else if (fieldClass.isAssignableFrom(Dimension.class)) {
                String s = value.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2");
                String[] val = s.split(delim);
                f.set(ob, new Dimension(Integer.parseInt(val[0]), Integer.parseInt(val[1])));
            } else if (fieldClass.isAssignableFrom(Point.class)) {
                String s = value.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2");
                String[] val = s.split(delim);
                f.set(ob, new Point(Integer.parseInt(val[0]), Integer.parseInt(val[1])));
            } else if (fieldClass.isAssignableFrom(Rectangle.class)) {
                String s = value.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2\t$3\t$4");
                String[] val = s.split(delim);
                f.set(ob, new Rectangle(Integer.parseInt(val[0]), Integer.parseInt(val[1]), Integer.parseInt(val[2]), Integer.parseInt(val[3])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] getFieldNames(Field[] fields, String fieldPrefix) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (name.indexOf(fieldPrefix) != 0) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getHeaderNames(String[] fieldNames, String fieldPrefix) {
        String[] result = new String[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = fieldNames[i].substring(fieldPrefix.length());
        }
        return result;
    }

    public static String join(String[] data, String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append(data[i]);
            if (i >= data.length - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String[] split(String data, String token) {
        int b;
        if (data == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int a = 0;
        int tlen = token.length();
        while ((b = data.indexOf(token, a)) != -1) {
            v.add(data.substring(a, b));
            a = b + tlen;
        }
        v.add(data.substring(a));
        return v.toArray(new String[v.size()]);
    }
}

