=begin
/***************************************************************************
 *   Copyright (C) 2006, Paul Lutus                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
=end

class SearchReplaceGlobalHelp

   def initialize(app)
      @app = app
      @help_widget = @app.helpTextEdit
      help_text = HelpText
      help_text.gsub!(/\[version\]/i,PROGRAM_VERSION)
      help_text.gsub!(/\[ini_file\]/i,@app.ini_file)
      @help_widget.setText(help_text)
   end

   def search()
      ss = @app.helpSearchLineEdit.text
      result = @help_widget.find(ss,false,false)
      if(!result)
         @help_widget.setSelection(0,0,0,0)
         @app.beep
      end
   end
   HelpText = "\t\t\t\t*** SearchReplaceGlobal Help ***\n\nWelcome to SearchReplaceGlobal, a global search/replace utility written in Ruby.\n\nSearchReplaceGlobal [version] is Copyright 2006, P. Lutus.\n\nSearchReplaceGlobal [version] is released under the GPL:\n\nhttp://www.fsf.org/licensing/licenses/gpl.txt\n\nTo search this document, type search characters into the text entry control at the bottom of this window. Press Enter to move to the next match for a given search string.\n\nThis file contains general information for using SearchReplaceGlobal. Be sure to visit the SearchReplaceGlobal Home Page at:\n\nhttp://www.arachnoid.com/ruby/searchreplaceglobal \n\n* What is SearchReplaceGlobal?\n\nSearchReplaceGlobal is my solution for a problem I have noticed over years of maintaining large sets of data files –- I needed a way to search for particular files, then search for particular patterns within those files, and finally to replace one pattern with another, using regular expressions.\n\nSearchReplaceGlobal is primarily intended for use with Linux, but I don't see any particular reason it wouldn't work under Windows just as well –- but I want to emphasize that I haven't tried using it there.\n\nThere are a number of command-line utilities in Linux to meet some of the needs met by SearchReplaceGlobal, but they are rather cumbersome to use. \"grep\" is good at searching files, but won't replace file contents and isn't particularly good at scanning an entire directory tree. \"find\" will scan a directory tree, but it is not particularly suited for scanning file contents.\n\n\"grep\" allows you to specify the file contents to search for, but not the files to be sought if a tree search is undertaken. \"find\" allows you to specify a file filter, but then has a rather baroque syntax for examining the contents of files.\n\nNeither \"grep\" nor \"find\" allow you to replace file contents. SearchReplaceGlobal will search a specified directory tree for a specified filename pattern, then it will search the matched files for a particular regular expression, then it will replace one expression with another if you tell it to.\n\nIf SearchReplaceGlobal edits a file, it automatically creates a backup file in the same directory by appending a tilde \"~\" to the file name. It does this for each matching file:\n\n1. Read \"filename\".\n2. Apply user-entered regular expression.\n3. Iff (see footnote 1) the file is changed, it is written out, but only after a backup of the original is created, named \"filename~\".\n\n* System Requirements\n\nSearchReplaceGlobal is written in Ruby and Qt, so both Ruby and the Qt libraries must be present on your system (they are both free). Here are links for both:\n\nRuby:\n\tLinux: ftp://ftp.ruby-lang.org/pub/ruby/ruby-1.8.5.tar.gz\n\tWindows: http://rubyinstaller.rubyforge.org/wiki/wiki.pl\nQt:\n\tLinux: http://www.trolltech.com/developer/downloads/qt/x11\n\tWindows: http://www.trolltech.com/developer/downloads/qt/windows\n\nThe deep thinkers among my readers will wonder what is the point of my listing these essential prerequisites in the help file for a program that must be running for the help file to be read ... well, the plain-text help file is available in the download package, readable before installation.\n\n* More Detail\n\nSearchReplaceGlobal maintains its state between uses, and when it is exited, it places its state in this file on your system:\n\n[ini_file]\n\nIf something happens to disable SearchReplaceGlobal, or simply if its present state annoys you, simply exit the program, delete this program data file and start again.\n\nThe primary display of SearchReplaceGlobal includes a set of combo boxes, one each for:\n\n1. Current search path.\n2. File filter, a regular expression filter used to select files.\n3. A search regular expression to examine the file contents.\n4. A replacement pattern.\n\nPlus a number of option checkboxes and command buttons.\n\nThe buttons are ordered left to right in increasing order of ... well, frankly ... danger:\n\n* If you press the \"Scan\" button, the entered \"File Filter\" string will be applied to files in the selected directory tree and a list of matching files will be created (readable by pressing the \"found\" tab at the bottom of the display).\n\n* If you press the \"Search\" button, each of the files will be read and scanned for matches for the entered \"Search for\" string, and a list of matches (along with the number of occurrences per file) will be placed in the \"Found\" window.\n\n* If you press the \"Replace ...\" button, which you should seriously think about before doing, all the files that met the \"File Filter\" criterion, and that contain the \"Search For\" string, will have the \"Replace With\" string applied to matching patterns (all of them, if \"Global\" is selected). In this case, as explained above, a backup file will be created for each changed file (and the program won't save unchanged files).\n\nFor the \"Replace ...\" command, since this will actually change file contents, a warning dialog appears for confirmation.\n\nThe next button, marked \"Undo ...\", will try to replace each changed file with its backup. This will obviously only work for the action immediately conducted, so if you expect to undo an action, you must do so immediately, before conducting another search. Another way of putting this is there is only one level of undo, and that level is volatile.\n\nThe next button, marked \"Erase ...\", can be used to remove the clutter of backup files once you are satisfied that you have done more good than harm.\n\n* More and Better\n\nSearchReplaceGlobal has some additional features. Once you have created a list of matching file in the \"Found\" window, you can click a file name in that window and an editor will be launched to allow manual editing. This is for those cases where a regular expression can find the target files but can't make the needed changes. If the clicked file is a graphic, a graphic viewer will be launched instead of an editor.\n\nBecause I am thinking of SearchReplaceGlobal as a cross-platform program, I should add that the editor and graphic viewer names appear at the top of the primary source file \"searchreplaceglobal.rb\", so the user can change them to suit what is available as well as personal taste.\n\n* Regular Expression Notes\n\nFirst, the \"File Filter\" entry is a regular expression. This is not the norm for file scanning programs, which ordinarily use a simplified globbing expression syntax for this particular task. If you type \"*\" to accept all files, this will produce an error instead of a list.\n\nSecond, in the regular expression entries, entered sequences of \"\\t\", \"\\r\" and \"\\n\" will be translated into tab, return and newline respectively (see below in \"Escape Handling\" for more detail on this).\n\nHere is a pattern one can use to find all typical Web pages in a directory tree (for these examples, make sure the \"case\" checkbox is not selected):\n\n.*\\.html?$\n\nMeaning \"any number of characters, followed by a \".\", followed by \"htm\", followed by a single, optional \"l\".\n\nTo find all HTML and PHP files that use common suffixes:\n\n.*\\.(html?|php)$\n\nThe \"Search For\" entry is a regular expression as well. In \"Replace With\", the syntax follows the Ruby convention that \"\\1\" matches the first capture group, \"\\2\" matches the second, and so forth.\n\nNext example:\n\n\"Search For\": (\\w+)\\s+(\\w+)\n\n\"Replace With\": \\2 \\1\n\nIf the \"global\" option were selected, this example would switch the order of all the words in all the files.\n\nHere is an example that will strip all HTML tags from the target files:\n\n\"Search For\": <.*?>\n\n\"Replace With\": (nothing)\n\nThis simple approach will fail is there are nested \"<\" or \">\" symbols, or if these symbols are used as ordinary characters (shouldn't be true in good HTML, but it does happen).\n\n* \"Reverse\" Checkbox\n\nI am sure this feature will cause some confusion. The \"Reverse\" checkbox selects and lists those files that don't match the search string. It doesn't work during search & replace, only to reverse the sense of search-only (it's only used to select files, not while changing their contents). Also, it doesn't reverse the sense of the file filter search, only the content search.\n\n* \"Multiline\" Checkbox\n\nThis selector causes \".\" to match any character (ordinarily \".\" won't match linefeeds). One common way of saying this is \"dot = all\". This allows matches to extend across linefeeds.\n\n* \"Global\" Checkbox\n\nThis selector causes all matches to be replaced, not just the first.\n\n* \"Case\" Checkbox\n\nMakes the content search case sensitive. It has no effect on the file filter search.\n\n* Escape Handling\n\nBefore commencing operations, SearchReplaceGlobal will unescape any entered escape sequences present in the entry panes. It will convert such common escapes as \"\\n\", \"\\r\", \"\\t\" and a number of others, but it will also process the sequence \"\\cx\", replacing it with the control character corresponding to letter \"x\".\n\n* Caveats\n\nMany of my readers will be seasoned computer professionals, but just in case this isn't true, I add this advice. Before using SearchReplaceGlobal to scramble your files, make a full backup in a separate location. Because SearchReplaceGlobal does exactly what its name implies, it is entirely possible for a single ill-considered regular expression to empty all your files of their content.\n\nIt would be a mistake to rely solely on the backup files that SearchReplaceGlobal creates. They might be deleted, be the wrong files, or go out of date as you proceed with operations on the file tree. Backing up is the only reliable way to avoid data loss.\n\n* Further\n\nFor more information about SearchReplaceGlobal, including a check for the latest version, visit:\n\nhttp://www.arachnoid.com/ruby/searchreplaceglobal\n\n-----------------------------------------------------------------------\n\nFootnote 1. Iff = \"if and only if\"\n\n"
end
