/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "planet.h"

Planet::Planet(string name, double radius, Cart3 pos, Cart3 vel, double mass)
{
  this->name = name;
  this->radius = radius;
  this->pos = pos;
  this->vel = vel;
  this->mass = mass;
}


Planet::~Planet()
{}

bool Planet::operator!=(Planet v)
{
  return this->name != v.name;
}

string Planet::show()
{
  char buf[512];
  sprintf(buf,"%s,%e,%s,%s,%e",name.c_str(),radius,pos.show().c_str(),vel.show().c_str(),mass);
  string s = buf;
  return s;
}
