/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "cart3.h"

Cart3::Cart3(double x, double y,double z)
{
  this->x = x;
  this->y = y;
  this->z = z;
}

Cart3::Cart3(Cart3 *p)
{
  x = p->x;
  y = p->y;
  z = p->z;
}

Cart3::Cart3()
{
  x = 0;
  y = 0;
  z = 0;
}


Cart3::~Cart3()
{}

void Cart3::debug_print()
{
  printf("x = %lf,y = %lf,z = %lf\n",x,y,z);
  fflush(stdout);
}

Cart3 Cart3::operator=(Cart3 v)
{
  x = v.x;
  y = v.y;
  z = v.z;
}

Cart3 Cart3::operator+=(double v)
{
  x += v;
  y += v;
  z += v;
  return this;
}

Cart3 Cart3::operator+=(Cart3 v)
{
  x += v.x;
  y += v.y;
  z += v.z;
  return this;
}

Cart3 Cart3::operator-=(double v)
{
  x -= v;
  y -= v;
  z -= v;
  return this;
}

Cart3 Cart3::operator-=(Cart3 v)
{
  x -= v.x;
  y -= v.y;
  z -= v.z;
  return this;
}

Cart3 Cart3::operator*=(double v)
{
  x *= v;
  y *= v;
  z *= v;
  return this;
}

Cart3 Cart3::operator*=(Cart3 v)
{
  x *= v.x;
  y *= v.y;
  z *= v.z;
  return this;
}

Cart3 Cart3::operator/=(double v)
{
  x /= v;
  y /= v;
  z /= v;
  return this;
}

Cart3 Cart3::operator/=(Cart3 v)
{
  x /= v.x;
  y /= v.y;
  z /= v.z;
  return this;
}


Cart3 Cart3::operator+(double v)
{
  Cart3 n(this);
  n.x += v;
  n.y += v;
  n.z += v;
  return n;
}

Cart3 Cart3::operator+(Cart3 v)
{
  Cart3 n(this);
  n.x += v.x;
  n.y += v.y;
  n.z += v.z;
  return n;
}

Cart3 Cart3::operator-(double v)
{
  Cart3 n(this);
  n.x -= v;
  n.y -= v;
  n.z -= v;
  return n;
}

Cart3 Cart3::operator-(Cart3 v)
{
  Cart3 n(this);
  n.x -= v.x;
  n.y -= v.y;
  n.z -= v.z;
  return n;
}

Cart3 Cart3::operator*(double v)
{
  Cart3 n(this);
  n.x *= v;
  n.y *= v;
  n.z *= v;
  return n;
}

Cart3 Cart3::operator*(Cart3 v)
{
  Cart3 n(this);
  n.x *= v.x;
  n.y *= v.y;
  n.z *= v.z;
  return n;
}

Cart3 Cart3::operator/(double v)
{
  Cart3 n(this);
  n.x /= v;
  n.y /= v;
  n.z /= v;
  return n;
}

Cart3 Cart3::operator/(Cart3 v)
{
  Cart3 n(this);
  n.x /= v.x;
  n.y /= v.y;
  n.z /= v.z;
  return n;
}

double Cart3::sumsq()
{
  return x*x+y*y+z*z;
}

string Cart3::show()
{
  char buf[512];
  sprintf(buf,"[%e,%e,%e]",x,y,z);
  string s = buf;
  return s;
}
