#!/bin/bash

# this script only works on systemd-enabled systems
# like recent debian/raspbian/raspberry pi

[[ $UID == 0 ]] || {
  echo "You must be root to run this script."
  echo "Run this script like this: \"sudo $0\"."
  exit
}

which systemctl > /dev/null || {
  echo "This script only works on systems using \"systemd\", quitting."
  exit
}

which x11vnc &> /dev/null || apt-get -y install x11vnc

passpath='/etc/x11vnc.pass'

[[ -e $passpath ]] || {
  if [[ -n $1 ]]
  then
    pass=$1
  else
    read -sp "Enter VNC logon password:" pass
  fi
  x11vnc -storepasswd $pass $passpath
  chmod 600 $passpath
}

(
cat << END
[Unit]
Description="x11vnc"
Requires=display-manager.service
After=display-manager.service

[Service]
Type=forking
ExecStart=/usr/bin/x11vnc -xkb -noxrecord -noxfixes -noxdamage -nocursorshape -shared -auth guess -display :0 -rfbauth /etc/x11vnc.pass -rfbport 5900 -bg -geometry 1920x1080 -reopen -forever -o /var/log/x11vnc.log
Restart=on-failure
RestartSec=10

# ExecStop=/usr/bin/killall x11vnc

[Install]
WantedBy=multi-user.target

END
) > /lib/systemd/system/x11vnc.service

# killall -9 x11vnc

systemctl daemon-reload
systemctl start x11vnc
systemctl enable x11vnc

echo "Done installing VNC server."
