/***************************************************************************
*   Copyright (C) 2006, Paul Lutus                                        *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

addEvent(window,"load",init_disp);
addEvent(document,"click",show_init);
// function to add an event listener
function addEvent(o,e,f) {
  if (o.addEventListener) {
    o.addEventListener(e,f,false);
    return true;
  }
  else if (o.attachEvent) {
    return o.attachEvent("on"+e,f);
  }
  else {
    return false;
  }
}
// integer "random()"
function rand (n)
{
  return (Math.floor( Math.random ()*n));
}
// BEGIN customization settings
var char_pause = 60; // pause on each character, milliseconds
var quote_pause = 8000; // pause to show complete quote, milliseconds
// END customization settings
var quoteindex;
var quote,attribution;
var pos;
var box;
var array_len;
var quote_len,attrib_len;
var interval = null;
var busy;
var cursor_span = "<span class=\"quotefont quotecursor\">";
var hide_span = "<span class=\"quotefont hidecolor\">"
var attr_div = "<p></p><div class=\"quotefont attrib\">";

function init_disp() {
  array_len = quotes.length;
  box = document.getElementById("quotebox");
  quoteindex = rand(array_len);
  show_init();
}
function show_init() {
  busy = false;
  clearInterval(interval);
  quote_array = quotes[quoteindex].split("\t");
  quote = quote_array[0];
  attribution = quote_array[1];
  quote_len = quote.length;
  attrib_len = attribution.length;
  quoteindex = (quoteindex+1) % array_len;
  pos = 0;
  interval = setInterval('show_quote()',char_pause);
}
function show_quote() {
  pos++;
  if(!busy) {
    busy = true;
    if(pos <= quote_len) {
      box.innerHTML = quote.substring(0,pos) +
      cursor_span +
      quote.substring(pos,pos+1) +
      "</span>" +
      hide_span +
      quote.substring(pos+1) +
      "</span>";
    }
    busy = false;
  }
  if(pos > quote_len) {
    pos = 0;
    clearInterval(interval);
    interval = setInterval('show_attr()',char_pause);
  }
}
function show_attr() {
  pos++;
  if(!busy) {
    busy = true;
    if(pos <= attrib_len) {
      var attr = attribution.substring(0,pos);
      box.innerHTML = quote + attr_div + attr + "</div>";
    }
    busy = false;
  }
  if(pos > attrib_len) {
    clearInterval(interval);
    interval = setInterval('show_init()',quote_pause);
  }
}
