/*
 * Decompiled with CFR 0.152.
 */
package polysolve;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.javascript.JSObject;
import polysolve.ClipboardFunctions;
import polysolve.FrameListener;
import polysolve.GJ;
import polysolve.GraphPanel;
import polysolve.MatrixFunctions;
import polysolve.Pair;

public final class PolySolve
extends JApplet {
    private boolean applet = true;
    String nameVersion = "PolySolve 3.7";
    private String copyright = "Copyright \u00a9 2012, P. Lutus -- http://www.arachnoid.com";
    public Color gridColor = new Color(192, 240, 192);
    public Color zeroColor = new Color(192, 192, 192);
    public Color lineColor = new Color(0, 0, 255);
    public Color dataColor = new Color(255, 0, 0);
    public double dotScale = 4.0;
    public String pageData;
    public String errorMsg = "";
    public boolean data_valid = false;
    public int poly_order = 2;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double dataXmin;
    public double dataXmax;
    public double dataYmin;
    public double dataYmax;
    public double eps;
    public int listingForm = 0;
    public boolean error;
    public boolean reverseMode = false;
    private String defaultData = "-1 -1\n0 3\n1 2.5\n2 5\n3 4\n5 2\n7 5\n9 4\n";
    ArrayList<Pair> userDataList;
    ArrayList<Double> terms;
    double result_cc;
    double result_se;
    private JPanel Tables;
    private JPanel bottomPanel;
    private JScrollPane bottom_panel_scroll_pane;
    private JButton cfuncButton;
    private JPanel computePane;
    private JButton copyButton;
    public JTextArea dataTextArea;
    private JTextField decimalPlacesTextField;
    private JLabel degreeLabel;
    private JTextField degreeTextField;
    private JLabel entryLabel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;
    private JButton leftButton;
    private JPanel mainPanel;
    private JPanel middlePanel;
    private JButton pasteButton;
    private JLabel posLabel;
    private JLabel resultLabel;
    private JTextArea resultText;
    private JPanel resultsPane;
    private JCheckBox reverseCheckBox;
    private JButton rightButton;
    private JButton solveButton;
    private JTabbedPane tabbed_pane;
    private JButton tableCopyButton;
    private JTextField tableEndTextField;
    private JButton tableGenButton;
    private JPanel tableMidPanel;
    private JTextArea tableResultTextArea;
    private JTextField tableStartTextField;
    private JTextField tableStepSizeTextField;
    private JPanel tableTopPanel;
    private JPanel topPanel;
    private JTextField xEntryTextfield;
    private JTextField xResultTextfield;
    private JLabel xlabel;
    private JLabel xlabel1;
    private JTextField yEntryTextfield;
    private JTextField yResultTextfield;
    private JLabel ylabel;
    private JLabel ylabel1;

    public static void main(String[] args) throws Exception {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        PolySolve theApplet = new PolySolve();
        theApplet.applet = false;
        JFrame theFrame = new JFrame(theApplet.nameVersion);
        theFrame.addWindowListener(new FrameListener());
        theFrame.setSize(700, 800);
        theFrame.add("Center", theApplet);
        theApplet.init();
        theApplet.start();
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        theFrame.setVisible(true);
    }

    @Override
    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PolySolve.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.applet) {
            this.copyButton.setEnabled(false);
            this.tabbed_pane.remove(this.resultsPane);
            this.mainPanel.remove(this.topPanel);
            this.tableCopyButton.setEnabled(false);
            GridBagLayout layout = (GridBagLayout)this.mainPanel.getLayout();
            GridBagConstraints con = layout.getConstraints(this.bottomPanel);
            con.weighty = 0.0;
            layout.setConstraints(this.bottomPanel, con);
            con = layout.getConstraints(this.middlePanel);
            con.weighty = 3.0;
            layout.setConstraints(this.middlePanel, con);
            this.tableResultTextArea.setText("\n\n    See \"Results Area\" below.");
        }
        this.dataTextArea.getDocument().addDocumentListener(new MyDocumentListener());
        this.dataTextArea.setText(this.defaultData);
        this.process(true);
    }

    void readData() {
        String s;
        this.userDataList = new ArrayList();
        double x = 0.0;
        double y = 0.0;
        double q = 0.0;
        if (this.applet) {
            JSObject window = JSObject.getWindow(this);
            JSObject doc = (JSObject)window.getMember("document");
            JSObject form = (JSObject)doc.getMember("form");
            JSObject field = (JSObject)form.getMember("entries");
            s = (String)field.getMember("value");
        } else {
            s = this.dataTextArea.getText();
        }
        try {
            s = s.replaceAll("[^\\.0-9eE+-]+", " ").trim();
            String[] num_array = s.split(" ");
            boolean paired = true;
            for (String qs : num_array) {
                if (qs.equalsIgnoreCase("e")) continue;
                try {
                    q = Double.valueOf(qs);
                }
                catch (Exception e) {
                    String es = "";
                    es = qs.length() == 0 ? "No data." : "Cannot parse \"" + qs + "\" in input.";
                    throw new Exception(es);
                }
                if (paired) {
                    x = q;
                } else {
                    y = q;
                    if (this.reverseMode) {
                        double t = x;
                        x = y;
                        y = t;
                    }
                    this.userDataList.add(new Pair(x, y));
                    this.ymin = Math.min(y, this.ymin);
                    this.ymax = Math.max(y, this.ymax);
                    this.xmin = Math.min(x, this.xmin);
                    this.xmax = Math.max(x, this.xmax);
                }
                paired = !paired;
            }
            if (!paired) {
                throw new Exception("Data not in x,y pairs (odd number of entries) ... edit data.");
            }
        }
        catch (Exception e) {
            this.data_valid = false;
            this.errorMsg = e.getMessage();
            this.userDataList.clear();
        }
    }

    void getData(boolean update) {
        this.eps = 1.0E-12;
        this.ymin = this.xmin = 1.0E30;
        this.ymax = this.xmax = 1.0E-30;
        this.readData();
        int n = this.userDataList.size();
        if (n > 0) {
            if (Math.abs(this.xmin - this.xmax) < 0.001) {
                this.xmin -= 0.001;
                this.xmax += 0.001;
            }
            if (Math.abs(this.ymin - this.ymax) < 0.001) {
                this.ymin -= 0.001;
                this.ymax += 0.001;
            }
            this.dataXmax = this.xmax;
            this.dataXmin = this.xmin;
            this.dataYmax = this.ymax;
            this.dataYmin = this.ymin;
            if (update) {
                this.tableStartTextField.setText(String.format("%.2f", this.dataXmin));
                this.tableEndTextField.setText(String.format("%.2f", this.dataXmax));
                double step = (this.dataXmax - this.dataXmin) / 20.0;
                this.tableStepSizeTextField.setText(String.format("%.2f", step));
            }
            double q = (this.ymax - this.ymin) / 6.0;
            this.ymin -= q;
            this.ymax += q;
            q = (this.xmax - this.xmin) / 6.0;
            this.xmin -= q;
            this.xmax += q;
        }
    }

    void p(String s) {
        System.out.println(s);
    }

    public void process(boolean update) {
        this.data_valid = false;
        this.poly_order = this.poly_order < 0 ? 0 : this.poly_order;
        this.poly_order = this.poly_order > 512 ? 512 : this.poly_order;
        this.degreeTextField.setText("" + this.poly_order);
        this.errorMsg = "";
        this.getData(update);
        int size = this.userDataList.size();
        if (size > 1) {
            this.terms = GJ.compute_coefficients(this.userDataList, this.poly_order);
            this.result_cc = MatrixFunctions.corr_coeff(this.userDataList, this.terms);
            this.result_se = MatrixFunctions.std_error(this.userDataList, this.terms);
            String r = this.showResult();
            this.writeResult(r, this.resultText);
            this.data_valid = true;
        } else {
            this.data_valid = false;
            if (this.errorMsg.length() == 0) {
                this.errorMsg = "Insufficient Data (minimum of 2 data pairs needed).";
            }
            this.writeResult("", this.resultText);
        }
        GraphPanel gp = (GraphPanel)this.middlePanel;
        gp.repaint();
    }

    private void writeAppletResult(String s) {
        JSObject window = JSObject.getWindow(this);
        JSObject doc = (JSObject)window.getMember("document");
        JSObject form = (JSObject)doc.getMember("form");
        JSObject field = (JSObject)form.getMember("results");
        field.setMember("value", s);
    }

    private void writeResult(String s, JTextArea jta) {
        if (this.applet) {
            this.writeAppletResult(s);
        } else {
            jta.setText(s);
        }
    }

    void newDegree(int v) {
        this.poly_order += v;
        this.poly_order = this.poly_order < 0 ? 0 : this.poly_order;
        this.process(false);
    }

    void setDegree(int v) {
        this.poly_order = v;
        this.newDegree(0);
    }

    void changeListingStyle() {
        ++this.listingForm;
        this.listingForm %= 4;
        this.process(false);
    }

    String formatNum(double n, boolean wide) {
        String w = wide ? "21" : "";
        return String.format("%" + w + ".12e", n);
    }

    String showResult() {
        String[] styleTag = new String[]{"", "", "pow", "Math.pow"};
        String[] styleTitle = new String[]{"simple list", "mathematical function", "C/C++ function", "Java function"};
        int n = this.userDataList.size();
        String r = "Mode: " + (this.reverseMode ? "reverse (x,y = y,x)" : "normal") + "\n";
        r = r + "Polynomial degree " + this.poly_order + ", " + n + " x,y data pairs\n";
        r = r + "Correlation coefficient (r^2) = " + this.formatNum(this.result_cc, false) + "\n";
        r = r + "Standard error = " + this.formatNum(this.result_se, false) + "\n";
        r = r + "Output form: " + styleTitle[this.listingForm] + ":\n\n";
        r = r + (this.listingForm > 1 ? "double f(double x) {\n    return" : (this.listingForm > 0 ? "f(x) =" : ""));
        for (int i = 0; i <= this.poly_order; ++i) {
            double a = this.terms.get(i);
            if (i > 0) {
                if (this.listingForm > 1) {
                    r = r + "    ";
                }
                if (this.listingForm > 0) {
                    r = r + "     +";
                }
            }
            r = r + this.formatNum(a, true);
            if (i == 1 && this.listingForm > 0) {
                r = r + " * x";
            }
            if (i > 1) {
                if (this.listingForm > 1) {
                    r = r + " * " + styleTag[this.listingForm] + "(x," + i + ")";
                } else if (this.listingForm == 1) {
                    r = r + " * x^" + i;
                }
            }
            if (i >= this.poly_order) continue;
            r = r + "\n";
        }
        if (this.listingForm > 1) {
            r = r + ";\n}";
        }
        if (this.poly_order > n - 1) {
            r = r + "\n\nWarning: Polynomial degree exceeds data size - 1.";
        }
        r = r + "\n\n" + this.copyright + ". All Rights Reserved.";
        return r;
    }

    void show_mat(double[][] data) {
        double[][] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] y;
            for (double x : y = dArray[i]) {
                System.out.printf("%25.16g,", x);
            }
            System.out.println("");
        }
        System.out.println("***************");
    }

    double findRoot2(double y, double x, ArrayList<Double> terms, double scale) {
        int max = 256;
        boolean positive = true;
        double epsilon = 1.0E-8;
        double dy = 0.0;
        double ody = Double.NaN;
        while (true) {
            double d;
            dy = MatrixFunctions.regress(x, terms) - y;
            if (!(Math.abs(d) > epsilon) || max-- <= 0 || Double.isInfinite(x)) break;
            if (!Double.isNaN(ody) && Math.abs(dy) > ody) {
                positive = !positive;
            }
            ody = Math.abs(dy);
            x += positive ? dy : -(dy *= scale);
        }
        if (max <= 0 || Double.isInfinite(x)) {
            x = Double.NaN;
        }
        return x;
    }

    double findRoot(double y, double x, ArrayList<Double> terms) {
        double rx;
        double scale = Math.pow(2.0, -32.0);
        int max = 64;
        while (Double.isNaN(rx = this.findRoot2(y, x, terms, scale)) && max-- > 0) {
            scale *= 2.0;
        }
        return rx;
    }

    double plotFunct(double x) {
        return MatrixFunctions.regress(x, this.terms);
    }

    void clipCopyText(String s) {
        ClipboardFunctions.clipCopy(s);
    }

    void clipCopyResult() {
        this.clipCopyText(this.resultText.getText());
    }

    void clipCopyTable() {
        this.clipCopyText(this.tableResultTextArea.getText());
    }

    void clipPaste() {
        String data = ClipboardFunctions.clipPaste(this);
        data = this.dataTextArea.getText() + data;
        this.dataTextArea.setText(data);
    }

    void xForY(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            String ys = this.yEntryTextfield.getText();
            String xs = this.yResultTextfield.getText();
            double y = Double.parseDouble(ys);
            double x = Double.parseDouble(xs);
            if (Double.isNaN(x) || Double.isInfinite(x)) {
                x = 0.0;
            }
            double rx = this.findRoot(y, x, this.terms);
            xs = this.formatNum(rx, false);
            this.yResultTextfield.setText(xs);
        }
    }

    void yForX(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            String xs = this.xEntryTextfield.getText();
            double x = Double.parseDouble(xs);
            double y = MatrixFunctions.regress(x, this.terms);
            String ys = this.formatNum(y, false);
            this.xResultTextfield.setText(ys);
        }
    }

    void trackMouse(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        Pair mp = ((GraphPanel)this.middlePanel).mousePos(x, y);
        String sx = String.format("%.4g", mp.x);
        String sy = String.format("%.4g", mp.y);
        this.posLabel.setText("x = " + sx + ", y = " + sy);
    }

    double ntrp(double xa, double xb, double ya, double yb, double x) {
        return (x - xa) * (yb - ya) / (xb - xa) + ya;
    }

    String generateRow(double a, double p, double b, int places) {
        double pct = this.ntrp(a, b, 0.0, 100.0, p);
        double y = MatrixFunctions.regress(p, this.terms);
        String format = String.format("%%.%df,%%.%df,%%.%df\n", places, places, places);
        String row = String.format(format, p, y, pct);
        return row;
    }

    public void generateTable() {
        try {
            String newRow;
            double a = Double.parseDouble(this.tableStartTextField.getText());
            double b = Double.parseDouble(this.tableEndTextField.getText());
            double stepSize = Double.parseDouble(this.tableStepSizeTextField.getText());
            int places = Integer.parseInt(this.decimalPlacesTextField.getText());
            if (stepSize <= 0.0) {
                throw new Exception("Step size must be > 0");
            }
            double lp = 0.0;
            StringBuilder sb = new StringBuilder();
            String oldRow = "";
            sb.append("x,y,%\n");
            for (double p = a; p <= b; p += stepSize) {
                lp = p;
                oldRow = this.generateRow(a, p, b, places);
                sb.append(oldRow);
            }
            if (lp < b && !oldRow.equals(newRow = this.generateRow(a, b, b, places))) {
                sb.append(newRow);
            }
            this.writeResult(sb.toString(), this.tableResultTextArea);
        }
        catch (Exception e) {
            this.writeResult(e.toString(), this.tableResultTextArea);
        }
    }

    void setReverseMode() {
        this.reverseMode = this.reverseCheckBox.isSelected();
        this.process(true);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.copyButton = new JButton();
        this.cfuncButton = new JButton();
        this.solveButton = new JButton();
        this.rightButton = new JButton();
        this.degreeTextField = new JTextField();
        this.leftButton = new JButton();
        this.degreeLabel = new JLabel();
        this.reverseCheckBox = new JCheckBox();
        this.posLabel = new JLabel();
        this.tabbed_pane = new JTabbedPane();
        this.resultsPane = new JPanel();
        this.bottom_panel_scroll_pane = new JScrollPane();
        this.resultText = new JTextArea();
        this.Tables = new JPanel();
        this.tableTopPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.tableStartTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.tableEndTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.tableStepSizeTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.decimalPlacesTextField = new JTextField();
        this.tableGenButton = new JButton();
        this.tableCopyButton = new JButton();
        this.tableMidPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tableResultTextArea = new JTextArea();
        this.computePane = new JPanel();
        this.xlabel = new JLabel();
        this.xEntryTextfield = new JTextField();
        this.xResultTextfield = new JTextField();
        this.ylabel = new JLabel();
        this.entryLabel = new JLabel();
        this.resultLabel = new JLabel();
        this.xlabel1 = new JLabel();
        this.yEntryTextfield = new JTextField();
        this.ylabel1 = new JLabel();
        this.yResultTextfield = new JTextField();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.middlePanel = new GraphPanel(this);
        this.topPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.dataTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.pasteButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.bottomPanel.setLayout(new GridBagLayout());
        this.copyButton.setText("Copy Result");
        this.copyButton.setToolTipText("Copy the result summary to the system clipboard");
        this.copyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.copyButtonMouseClicked(evt);
            }
        });
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PolySolve.this.copyButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.copyButton, gridBagConstraints);
        this.cfuncButton.setText("Form");
        this.cfuncButton.setToolTipText("Cycle through simple result, mathematical, C/C++ and Java function result forms");
        this.cfuncButton.setActionCommand("Listing Style");
        this.cfuncButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.cfuncButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.cfuncButton, gridBagConstraints);
        this.solveButton.setText("Solve");
        this.solveButton.setToolTipText("Force recalculation");
        this.solveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.solveButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.solveButton, gridBagConstraints);
        this.rightButton.setText("->");
        this.rightButton.setToolTipText("Increase polynomial degree");
        this.rightButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.rightButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.rightButton, gridBagConstraints);
        this.degreeTextField.setEditable(false);
        this.degreeTextField.setHorizontalAlignment(4);
        this.degreeTextField.setText("1");
        this.degreeTextField.setToolTipText("Current polynomial fit degree");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.degreeTextField, gridBagConstraints);
        this.leftButton.setText("<-");
        this.leftButton.setToolTipText("Decrease polynomial degree");
        this.leftButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.leftButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.leftButton, gridBagConstraints);
        this.degreeLabel.setHorizontalAlignment(11);
        this.degreeLabel.setText("Degree:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.bottomPanel.add((Component)this.degreeLabel, gridBagConstraints);
        this.reverseCheckBox.setText("Reverse");
        this.reverseCheckBox.setToolTipText("Switch data order (x,y = y,x)");
        this.reverseCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.reverseCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.reverseCheckBox, gridBagConstraints);
        this.posLabel.setText("x = 0.0, y = 0.0");
        this.posLabel.setMinimumSize(new Dimension(120, 15));
        this.posLabel.setPreferredSize(new Dimension(120, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.posLabel, gridBagConstraints);
        this.tabbed_pane.setTabPlacement(3);
        this.resultsPane.setLayout(new GridBagLayout());
        this.resultText.setColumns(20);
        this.resultText.setFont(new Font("Courier New", 0, 12));
        this.resultText.setRows(5);
        this.resultText.setToolTipText("View or copy computation results here \n");
        this.resultText.setMargin(new Insets(4, 4, 4, 4));
        this.bottom_panel_scroll_pane.setViewportView(this.resultText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.resultsPane.add((Component)this.bottom_panel_scroll_pane, gridBagConstraints);
        this.tabbed_pane.addTab("Results", this.resultsPane);
        this.Tables.setLayout(new BorderLayout());
        this.tableTopPanel.setLayout(new GridBagLayout());
        this.jLabel3.setText("Start:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.tableTopPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.tableStartTextField.setHorizontalAlignment(11);
        this.tableStartTextField.setText("0.00");
        this.tableStartTextField.setToolTipText("Table x-coordinate start value");
        this.tableStartTextField.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tableTopPanel.add((Component)this.tableStartTextField, gridBagConstraints);
        this.jLabel4.setText("End:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.tableTopPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.tableEndTextField.setHorizontalAlignment(11);
        this.tableEndTextField.setText("0.00");
        this.tableEndTextField.setToolTipText("Table x-coordinate end value");
        this.tableEndTextField.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tableTopPanel.add((Component)this.tableEndTextField, gridBagConstraints);
        this.jLabel5.setText("Step:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.tableTopPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.tableStepSizeTextField.setHorizontalAlignment(11);
        this.tableStepSizeTextField.setText("10");
        this.tableStepSizeTextField.setToolTipText("Size of x-coordinate table step (distance between rows)");
        this.tableStepSizeTextField.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tableTopPanel.add((Component)this.tableStepSizeTextField, gridBagConstraints);
        this.jLabel6.setText("Decimals:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.tableTopPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.decimalPlacesTextField.setHorizontalAlignment(11);
        this.decimalPlacesTextField.setText("2");
        this.decimalPlacesTextField.setToolTipText("Decimal precision in result data (integer)");
        this.decimalPlacesTextField.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tableTopPanel.add((Component)this.decimalPlacesTextField, gridBagConstraints);
        this.tableGenButton.setText("Generate Table");
        this.tableGenButton.setToolTipText("Create a table using entered values");
        this.tableGenButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.tableGenButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.tableTopPanel.add((Component)this.tableGenButton, gridBagConstraints);
        this.tableCopyButton.setText("Copy Table");
        this.tableCopyButton.setToolTipText("Copy a generated table to the system clipboard");
        this.tableCopyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.tableCopyButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.tableTopPanel.add((Component)this.tableCopyButton, gridBagConstraints);
        this.Tables.add((Component)this.tableTopPanel, "North");
        this.tableMidPanel.setLayout(new BorderLayout());
        this.tableResultTextArea.setColumns(20);
        this.tableResultTextArea.setRows(5);
        this.tableResultTextArea.setToolTipText("View or copy generated table here");
        this.jScrollPane2.setViewportView(this.tableResultTextArea);
        this.tableMidPanel.add((Component)this.jScrollPane2, "Center");
        this.Tables.add((Component)this.tableMidPanel, "Center");
        this.tabbed_pane.addTab("Table Generator", this.Tables);
        this.computePane.setLayout(new GridBagLayout());
        this.xlabel.setText("y = f(x): x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 5, 4);
        this.computePane.add((Component)this.xlabel, gridBagConstraints);
        this.xEntryTextfield.setHorizontalAlignment(4);
        this.xEntryTextfield.setText("0.0");
        this.xEntryTextfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PolySolve.this.xEntryTextfieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.computePane.add((Component)this.xEntryTextfield, gridBagConstraints);
        this.xResultTextfield.setHorizontalAlignment(4);
        this.xResultTextfield.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.computePane.add((Component)this.xResultTextfield, gridBagConstraints);
        this.ylabel.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 5, 4);
        this.computePane.add((Component)this.ylabel, gridBagConstraints);
        this.entryLabel.setHorizontalAlignment(0);
        this.entryLabel.setText("Argument");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.computePane.add((Component)this.entryLabel, gridBagConstraints);
        this.resultLabel.setHorizontalAlignment(0);
        this.resultLabel.setText("Result");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.computePane.add((Component)this.resultLabel, gridBagConstraints);
        this.xlabel1.setText("x = f(y): y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 7, 4);
        this.computePane.add((Component)this.xlabel1, gridBagConstraints);
        this.yEntryTextfield.setHorizontalAlignment(4);
        this.yEntryTextfield.setText("0.0");
        this.yEntryTextfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PolySolve.this.yEntryTextfieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.computePane.add((Component)this.yEntryTextfield, gridBagConstraints);
        this.ylabel1.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 7, 4);
        this.computePane.add((Component)this.ylabel1, gridBagConstraints);
        this.yResultTextfield.setHorizontalAlignment(4);
        this.yResultTextfield.setText("0.0");
        this.yResultTextfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PolySolve.this.yResultTextfieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.computePane.add((Component)this.yResultTextfield, gridBagConstraints);
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(new Font("Courier New", 0, 12));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("First row: type an X argument and press Enter for a Y result (y = f(x)).\nSecond row: type a Y argument and press Enter for an X result (x = f(y)).\nBecause x= f(y) may have multiple solutions, it may be necessary to enter an X estimate in the \"Result\" window.\nBeyond degree 2, it's not easy to obtain results for the x = f(y) case, regardless of the method used.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane3.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.computePane.add((Component)this.jScrollPane3, gridBagConstraints);
        this.tabbed_pane.addTab("Compute", this.computePane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bottomPanel.add((Component)this.tabbed_pane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)this.bottomPanel, gridBagConstraints);
        this.middlePanel.setBackground(new Color(255, 255, 255));
        this.middlePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.middlePanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PolySolve.this.middlePanelMouseMoved(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)this.middlePanel, gridBagConstraints);
        this.topPanel.setLayout(new GridBagLayout());
        this.dataTextArea.setColumns(20);
        this.dataTextArea.setFont(new Font("Courier New", 0, 12));
        this.dataTextArea.setRows(5);
        this.dataTextArea.setToolTipText("Enter or paste (Ctrl+V) x,y data pairs here");
        this.dataTextArea.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane1.setViewportView(this.dataTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.topPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText("Data x,y Pairs (any format)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.pasteButton.setText("Paste");
        this.pasteButton.setToolTipText("Paste from clipboard to input");
        this.pasteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PolySolve.this.pasteButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.pasteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)this.topPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.mainPanel, gridBagConstraints);
    }

    private void solveButtonMouseClicked(MouseEvent evt) {
        this.process(false);
    }

    private void rightButtonMouseClicked(MouseEvent evt) {
        this.newDegree(1);
    }

    private void leftButtonMouseClicked(MouseEvent evt) {
        this.newDegree(-1);
    }

    private void cfuncButtonMouseClicked(MouseEvent evt) {
        this.changeListingStyle();
    }

    private void pasteButtonMouseClicked(MouseEvent evt) {
        this.clipPaste();
    }

    private void copyButtonMouseClicked(MouseEvent evt) {
        this.clipCopyResult();
    }

    private void xEntryTextfieldKeyReleased(KeyEvent evt) {
        this.yForX(evt);
    }

    private void yEntryTextfieldKeyReleased(KeyEvent evt) {
        this.xForY(evt);
    }

    private void yResultTextfieldKeyReleased(KeyEvent evt) {
        this.xForY(evt);
    }

    private void middlePanelMouseMoved(MouseEvent evt) {
        this.trackMouse(evt);
    }

    private void tableGenButtonMouseClicked(MouseEvent evt) {
        this.generateTable();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
    }

    private void tableCopyButtonMouseClicked(MouseEvent evt) {
        this.clipCopyTable();
    }

    private void reverseCheckBoxMouseClicked(MouseEvent evt) {
        this.setReverseMode();
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PolySolve.this.process(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PolySolve.this.process(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PolySolve.this.process(true);
        }
    }
}

