/*
 * Decompiled with CFR 0.152.
 */
package morse_sender;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public final class MorseSender {
    double envelopeConstant = 0.005;
    double dotConstant = 1.2;
    double dot_time_between_dots_dashes = 1.0;
    double dot_time_between_characters = 2.0;
    double dot_time_between_words = 4.0;
    double sampleRate = 44100.0;
    double freqHz = 750.0;
    double morseWPM = 13.0;
    double dotDuration;
    double level = 0.5;
    boolean streamInput = false;
    String filePath = null;
    AudioFormat af;
    SourceDataLine sdl;
    HashMap<String, String> charHash;
    HashMap<String, String> transHash;
    final String[] transTable = new String[]{"\u201c", "\"", "\u201d", "\"", "\u2019", "'", "\u2018", "'", "`", "'", "\u2014", "-"};
    final String[] morseTable = new String[]{"!", "-.-.--", "\"", ".-..-.", "$", "...-..-", "'", ".----.", "/", "-..-.", "(", "-.--.", ")", "-.--.-", "[", "-.--.", "]", "-.--.-", "+", ".-.-.", ",", "--..--", "-", "-....-", ".", ".-.-.-", "_", "..--.-", "/", "-..-.", "0", "-----", "1", ".----", "2", "..---", "3", "...--", "4", "....-", "5", ".....", "6", "-....", "7", "--...", "8", "---..", "9", "----.", ":", "---...", ";", "-.-.-.", "=", "-...-", "@", ".--.-.", "?", "..--..", "a", ".-", "b", "-...", "c", "-.-.", "d", "-..", "e", ".", "f", "..-.", "g", "--.", "h", "....", "i", "..", "j", ".---", "k", "-.-", "l", ".-..", "m", "--", "n", "-.", "o", "---", "p", ".--.", "q", "--.-", "r", ".-.", "s", "...", "t", "-", "u", "..-", "v", "...-", "w", ".--", "x", "-..-", "y", "-.--", "z", "--.."};

    public MorseSender(double freqHz, double morseWPM, double level) {
        this.freqHz = freqHz;
        this.morseWPM = morseWPM;
        this.level = level;
        this.init();
    }

    public MorseSender(String[] args) {
        this.process(args);
    }

    private void init() {
        int i;
        this.dotDuration = this.dotConstant / this.morseWPM;
        this.charHash = new HashMap();
        for (i = 0; i < this.morseTable.length; i += 2) {
            this.charHash.put(this.morseTable[i], this.morseTable[i + 1]);
        }
        this.transHash = new HashMap();
        for (i = 0; i < this.transTable.length; i += 2) {
            this.transHash.put(this.transTable[i], this.transTable[i + 1]);
        }
    }

    private void p(String s) {
        System.out.println(s);
    }

    private double envelope(double a, double b, double t, double tc) {
        return (b - t) * (-a + t) / ((b - t + tc) * (-a + t + tc));
    }

    private void sendElement(double durationSec, boolean sound) {
        try {
            int bsize = (int)(this.sampleRate * durationSec) * 2;
            byte[] buf = new byte[bsize];
            double step = Math.PI * 2 * this.freqHz / this.sampleRate;
            double ec = this.envelopeConstant * this.sampleRate;
            double angle = 0.0;
            int i = 0;
            while (i < bsize) {
                int n = 0;
                if (sound) {
                    n = (int)(Math.sin(angle) * this.level * 32767.0 * this.envelope(0.0, bsize, i, ec));
                }
                buf[i++] = (byte)(n % 256);
                buf[i++] = (byte)(n / 256);
                angle += step;
            }
            this.sdl.write(buf, 0, buf.length);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void sendString(String s) {
        for (char sc : s.toCharArray()) {
            System.out.print(sc);
            String slc = Character.toString(sc).toLowerCase();
            if (slc.equals(" ")) {
                this.sendElement(this.dotDuration * this.dot_time_between_words, false);
                continue;
            }
            if (this.transHash.containsKey(slc)) {
                slc = this.transHash.get(slc);
            }
            if (!this.charHash.containsKey(slc)) continue;
            String ms = this.charHash.get(slc);
            for (char c : ms.toCharArray()) {
                double dur = this.dotDuration * (double)(c == '.' ? 1 : 3);
                this.sendElement(dur, true);
                this.sendElement(this.dotDuration * this.dot_time_between_dots_dashes, false);
            }
            this.sendElement(this.dotDuration * this.dot_time_between_characters, false);
        }
    }

    private void openAudio() {
        try {
            this.af = new AudioFormat((float)this.sampleRate, 16, 1, true, false);
            this.sdl = AudioSystem.getSourceDataLine(this.af);
            this.sdl.open(this.af);
            this.sdl.start();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void closeAudio() {
        try {
            this.sdl.drain();
            this.sdl.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void process(String[] args) {
        if (args.length == 0) {
            System.out.println(String.format("Usage: [-s code speed wpm default %.0f]", this.morseWPM));
            System.out.println(String.format("       [-f freq default %.0f]", this.freqHz));
            System.out.println("       [-i (text file name) for input instead of command line]");
            System.out.println(String.format("       [-r sample rate default %.0f]", this.sampleRate));
            System.out.println(String.format("       [-v volume level (0 <= v <= 1), default %.1f]", this.level));
            System.out.println("       [-p read data from stdin]");
            System.out.println(String.format("       [-c delay between characters, default %.0f]", this.dot_time_between_characters));
            System.out.println(String.format("       [-w delay between words, default %.0f]", this.dot_time_between_words));
            System.out.println("       string to translate into Morse code.");
        } else {
            ArrayList<String> chars = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                String s = args[i];
                if (s.charAt(0) == '-') {
                    switch (s) {
                        case "-s": {
                            this.morseWPM = Double.parseDouble(args[i + 1]);
                            ++i;
                            break;
                        }
                        case "-f": {
                            this.freqHz = Double.parseDouble(args[i + 1]);
                            ++i;
                            break;
                        }
                        case "-v": {
                            this.level = Double.parseDouble(args[i + 1]);
                            ++i;
                            break;
                        }
                        case "-r": {
                            this.sampleRate = Integer.parseInt(args[i + 1]);
                            ++i;
                            break;
                        }
                        case "-p": {
                            this.streamInput = true;
                            break;
                        }
                        case "-i": {
                            this.filePath = args[i + 1];
                            ++i;
                            break;
                        }
                        case "-w": {
                            this.dot_time_between_words = Double.parseDouble(args[i + 1]);
                            ++i;
                            break;
                        }
                        case "-c": {
                            this.dot_time_between_characters = Double.parseDouble(args[i + 1]);
                            ++i;
                            break;
                        }
                        default: {
                            System.err.println("Error: don't know option \"" + s + "\".");
                            break;
                        }
                    }
                    continue;
                }
                chars.add(s);
            }
            this.init();
            try {
                this.openAudio();
                if (this.streamInput) {
                    String s;
                    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                    while ((s = in.readLine()) != null) {
                        if (s.length() <= 0) continue;
                        this.sendString(s);
                    }
                } else if (this.filePath != null) {
                    String data = new String(Files.readAllBytes(Paths.get(this.filePath, new String[0])));
                    data = data.trim();
                    this.sendString(data);
                } else {
                    String sa = String.join((CharSequence)" ", chars);
                    this.sendString(sa);
                }
                this.closeAudio();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        MorseSender ms = new MorseSender(args);
    }
}

