// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * TipJFrame.java
 *
 * Created on March 11, 2002, 2:48 PM
 */
package TipOfTheDay;

import Arachnophilia.*;
import java.io.*;
import javax.swing.*;
import java.awt.*;

/**
 *
 * @author  Administrator
 */
public class TipJFrame extends javax.swing.JFrame {

    /** Creates new form TipJFrame */
    Arachnophilia main;
    String[] tips;
    int top;

    public TipJFrame(Arachnophilia m) {
        main = m;
        initComponents();
        prevButton.setIcon(new ImageIcon(getClass().getResource("/" + main.iconDirName + "/Left.gif")));
        nextButton.setIcon(new ImageIcon(getClass().getResource("/" + main.iconDirName + "/Right.gif")));
        tipTextArea.setBackground(Color.white);
        setIconImage(m.getIconImage());
        setTitle(ArachConstants.APPNAME);
        showTipCheckBox.setSelected(main.configValues.showTipOfTheDay);
        String path = main.basePath + "/ArachConf/TipsOfTheDay.txt";
        String data = ArachComp.readProgramFile(path, false);
        if (data != null) {
            data = main.comSwitchboard.exec(data, 0);
            tips = ArachComp.parseDelimLine(data, "*", true).toArray(new String[]{});
            top = tips.length;
            if (top > 0) {
                showTip(0);
                pack();
                setSize(500, 350);
                Rectangle ss = main.getBounds();
                int w = ss.width / 8;
                int h = ss.height / 8;
                setLocation(ss.x + w, ss.y + h);
                setVisible(true);
            } else {
                quit();
            }
        }
    }

    private void showTip(int v) {
        main.configValues.currentTip += v;
        int i = main.configValues.currentTip;
        if (i < 0) {
            i += (top * 1000);
        }
        i %= top;
        String tip = tips[i];
        tipTextArea.setText(tip);
        tipTextArea.setCaretPosition(0);
    }

    private void setShowTip() {
        main.configValues.showTipOfTheDay = showTipCheckBox.getSelectedObjects() != null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        topPanel = new javax.swing.JPanel();
        iconButton = new javax.swing.JButton();
        jLabel1 = new MyJLabel(main);
        middlePanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        tipTextArea = new MyJTextArea(main);
        bottomPanel = new javax.swing.JPanel();
        showTipCheckBox = new javax.swing.JCheckBox();
        prevButton = new MyJButton();
        nextButton = new MyJButton();
        closeButton = new MyJButton();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
            public void windowDeactivated(java.awt.event.WindowEvent evt) {
                formWindowDeactivated(evt);
            }
        });

        topPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        iconButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Arachnophilia/Arach.png"))); // NOI18N
        iconButton.setText(" ");
        iconButton.setToolTipText("Arachie says \"Hi\"");
        iconButton.setBorder(null);
        topPanel.add(iconButton);

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 18)); // NOI18N
        jLabel1.setText("Arachnophilia Tip of the Day");
        topPanel.add(jLabel1);

        getContentPane().add(topPanel, java.awt.BorderLayout.NORTH);

        middlePanel.setLayout(new java.awt.BorderLayout());

        jScrollPane1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        tipTextArea.setEditable(false);
        tipTextArea.setFont(new java.awt.Font("Monospaced", 0, 12)); // NOI18N
        tipTextArea.setLineWrap(true);
        tipTextArea.setWrapStyleWord(true);
        tipTextArea.setMargin(new java.awt.Insets(4, 4, 4, 4));
        jScrollPane1.setViewportView(tipTextArea);

        middlePanel.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        getContentPane().add(middlePanel, java.awt.BorderLayout.CENTER);

        showTipCheckBox.setText("Show tips at startup");
        showTipCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showTipCheckBoxActionPerformed(evt);
            }
        });
        bottomPanel.add(showTipCheckBox);

        prevButton.setToolTipText("Previous tip");
        prevButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                prevButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(prevButton);

        nextButton.setToolTipText("Next tip");
        nextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nextButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(nextButton);

        closeButton.setText("Close");
        closeButton.setToolTipText("Close this dialog");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(closeButton);

        getContentPane().add(bottomPanel, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowDeactivated(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowDeactivated
        // Add your handling code here:
        quit();
    }//GEN-LAST:event_formWindowDeactivated

    private void showTipCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showTipCheckBoxActionPerformed
        // Add your handling code here:
        setShowTip();
    }//GEN-LAST:event_showTipCheckBoxActionPerformed

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        quit();
    }//GEN-LAST:event_closeButtonActionPerformed

    private void nextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nextButtonActionPerformed
        // Add your handling code here:
        showTip(1);
    }//GEN-LAST:event_nextButtonActionPerformed

    private void prevButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_prevButtonActionPerformed
        // Add your handling code here:
        showTip(-1);
    }//GEN-LAST:event_prevButtonActionPerformed

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        quit();
    }//GEN-LAST:event_exitForm

    private void quit() {
        main.configValues.currentTip++;
        setVisible(false);
        dispose();
    }
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
    new TipJFrame().show();
    }*/

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JButton closeButton;
    private javax.swing.JButton iconButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel middlePanel;
    private javax.swing.JButton nextButton;
    private javax.swing.JButton prevButton;
    private javax.swing.JCheckBox showTipCheckBox;
    private javax.swing.JTextArea tipTextArea;
    private javax.swing.JPanel topPanel;
    // End of variables declaration//GEN-END:variables
}
