// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package SourceBeautifiers;

/*
 * CodeBeautifier.java
 *
 * Created on February 16, 2002, 8:22 AM
 */
import Arachnophilia.ArachComp;
import Arachnophilia.ArachConstants;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class MultiCodeBeautifier {

    Arachnophilia main;
    // these keywords allow a single-line indent
    // without enclosing braces
    final static String[] indentKeywords = {
        "for",
        "while",
        "do",
        "if",
        "else",
        "case",
        "default",
        "try",
        "catch",
        "finally"
    };
    HashSet<String> keywordHash;
    String tabChar;

    /** Creates new CodeBeautifier */
    public MultiCodeBeautifier(Arachnophilia m) {
        main = m;
        keywordHash = new HashSet<String>();
        tabChar = ArachComp.getTabString();
        keywordHash.addAll(Arrays.asList(indentKeywords));
    }

    private boolean beautifyActiveFlag(boolean JavaScriptMode, boolean JavaScriptFlag, boolean CPPMode, boolean PerlMode) {
        return (((JavaScriptMode) && (JavaScriptFlag)) || (CPPMode) || (PerlMode));
    }

    public String beautifyCodeString(ArachDocument doc, String sourceData, String fileName) {

        int type = doc.fileType;

        if (type == main.fileTypes.getFileTypeForName("Ruby")) {
            return new RubyBeautifier(main).beautify(fileName, sourceData);
        } else {

            if (type == main.fileTypes.getFileTypeForName("Shell Script")) {
                return new BashBeautifier(main).beautify(fileName, sourceData);
            } else {
                // stop if source had no braces!
                if (!beauFind(sourceData, "{")) {
                    return sourceData;
                }
                long start, end;
                //System.out.println("a");

                //System.out.println("b");
                boolean PHPMode = (type == main.fileTypes.getFileTypeForName("PHP"));
                boolean JavaScriptFlag = (type == main.fileTypes.getFileTypeForName("JavaScript"));
                boolean JavaScriptMode =
                        (type == main.fileTypes.getFileTypeForName("HTML") || JavaScriptFlag || PHPMode);
                //System.out.println("javascriptmode=" + JavaScriptMode);

                boolean CPPMode = (type == main.fileTypes.getFileTypeForName("C++"))
                        || (type == main.fileTypes.getFileTypeForName("C"))
                        || (type == main.fileTypes.getFileTypeForName("CSS"))
                        || (type == main.fileTypes.getFileTypeForName("Java"));
                boolean PerlMode = (type == main.fileTypes.getFileTypeForName("Perl"))
                        || (type == main.fileTypes.getFileTypeForName("CGI"));
                // String sourceData = allocateCString(cp.GetTextLength());
                String sourceLine = "";
                String sourceOutLine;
                StringBuilder heapOutStr = new StringBuilder();
                String sourceTest;
                String keyWord;
                int sourceIndex = 0;
                int sourceLength = sourceData.length();
                int i, ti;
                int tabtotal = 0;
                int delta;
                long origlen = sourceData.length();
                long pos;
                long passnum = 0;
                int parenCount = 0;
                int braceCount = 0;
                int bracketCount = 0;
                boolean valid;
                boolean ContinueLine = false;
                boolean CComment = false;
                boolean CCommentStart = false;
                boolean lineEndsInLineFeed = true;
                boolean indentNextLine = false;
                boolean singleIndentThisLine;
                do {
                    //System.out.println("a:");
                    singleIndentThisLine = indentNextLine;
                    indentNextLine = false;
                    sourceOutLine = "";
                    valid = false;
                    i = sourceData.indexOf("\n", sourceIndex);
                    if (i == -1) {
                        if ((sourceLength > sourceIndex)) {
                            sourceLine = sourceData.substring(sourceIndex);
                            sourceIndex = sourceLength;
                            lineEndsInLineFeed = false;
                            valid = true;
                        }
                    } else { // normal find
                        sourceLine = sourceData.substring(sourceIndex, i);
                        sourceIndex = i + 1;
                        lineEndsInLineFeed = true;
                        valid = true;
                    }
                    //System.out.println("d");
                    if (valid) {
                        //keyWord;
                        if (beautifyActiveFlag(JavaScriptMode, JavaScriptFlag, CPPMode, PerlMode)) { // only if in code segment of HTML
                            sourceLine = sourceLine.trim();
                            keyWord = getKeyWord(sourceLine);
                            indentNextLine = isIndentKeyword(keyWord);
                            // don't indent next line
                            // if this line ends with ';'
                            if (indentNextLine) {
                                int len = sourceLine.length();
                                if (len > 0 && sourceLine.charAt(len - 1) == ';') {
                                    indentNextLine = false;
                                }
                            }
                            // don't single-indent this line
                            // if it also calls for next-line indent
                            if (indentNextLine) {
                                singleIndentThisLine = false;
                            }

                        }
                        sourceTest = sourceLine;
                        //System.out.println("processing(1): " + sourceTest);
                        if (beautifyActiveFlag(JavaScriptMode, JavaScriptFlag, CPPMode, PerlMode)) { // only if in code segment of HTML
                            if (PerlMode) {
                                sourceTest = beauDelete(sourceTest, "\\#");
                            }
                            //System.out.println("e:" + sourceTest);
                            sourceTest = beauDelete(sourceTest, "\\\\\\{");
                            sourceTest = beauDelete(sourceTest, "\\\\\\}");
                            sourceTest = beauDelete(sourceTest, "\\\\\\(");
                            sourceTest = beauDelete(sourceTest, "\\\\\\)");
                            sourceTest = beauDelete(sourceTest, "\\\\\"");
                            sourceTest = beauDelete(sourceTest, "\\\\'");
                            //System.out.println(sourceTest);
                            //System.out.println("e1:" + sourceTest);
                            sourceTest = beauDeleteBetween(sourceTest, "\\\"", "\\\"");
                            //System.out.println("e2" + sourceTest);
                            //System.out.println(sourceTest);
                            sourceTest = beauDeleteBetween(sourceTest, "'", "'");

                            //System.out.println("e3" + sourceTest);
                            if (CPPMode || JavaScriptMode) { // detect C and C++ style comments
                                sourceTest = beauKeepLeftOf(sourceTest, "//");
                                sourceTest = beauDeleteBetween(sourceTest, "/\\*", "\\*/"); // this one only works for single-line C comments
                                sourceTest = sourceTest.trim();
                                if (beauFind(sourceTest, "/*")) // single token of continuing comment
                                {
                                    sourceTest = beauKeepLeftOf(sourceTest, "/*");
                                    CCommentStart = true;
                                }
                                if ((CComment) && (beauFind(sourceTest, "*/"))) // single token of ending comment
                                {
                                    sourceTest = beauKeepRightOf(sourceTest, "*/");
                                    CComment = false;
                                    // preserve Java-style comment indenting
                                    if (sourceOutLine.length() == 0) {
                                        sourceOutLine += ' ';
                                    }
                                }
                            } else if (PerlMode) {// perl/CGI mode
                                sourceTest = beauKeepLeftOf(sourceTest, "#");
                            }
                            //System.out.println("f");
                            sourceTest = sourceTest.trim();
                            //System.out.println("e4" + sourceTest);

                            if (beauFind(sourceTest, "</script")
                                    || beauFind(sourceTest, "?>")
                                    || beauFind(sourceTest, "</style")
                                    || (beauFind(sourceTest, "%>")
                                    && (!beauFind(sourceTest, "<%")))) {
                                //System.out.println("javascriptflag=false");
                                JavaScriptFlag = false;
                            }
                        }

                        if ((!CComment) && (beautifyActiveFlag(JavaScriptMode, JavaScriptFlag, CPPMode, PerlMode))) {
                            // deal with the case of an independent regexp
                            sourceTest = beauDeleteBetween(sourceTest, "[\\s|=|~|\\w]/", "/\\s*;");
                            //System.out.println("processing(2): " + sourceTest);
                            int len = sourceTest.length(); // look for errors only, no effect on beautify
                            for (int j = 0; j < len; j++) {
                                int c = sourceTest.charAt(j);
                                switch (c) {
                                    case ('('):
                                        parenCount++;
                                        break;
                                    case (')'):
                                        parenCount--;
                                        break;
                                    case ('{'):
                                        braceCount++;
                                        break;
                                    case ('}'):
                                        braceCount--;
                                        break;
                                    case ('['):
                                        bracketCount++;
                                        break;
                                    case (']'):
                                        bracketCount--;
                                        break;
                                }
                            }
                            //System.out.println("g");
                            delta = beauCount(sourceTest, "{("); // count all occurrences of all chars
                            delta -= beauCount(sourceTest, "})");
                            if (delta > 0) {
                                indentNextLine = false;
                                singleIndentThisLine = false;
                            }

                            tabtotal += (delta < 0) ? delta : 0; // immediate
                            ti = (tabtotal > 0) ? tabtotal : 0; // pass to index
                            tabtotal += (delta > 0) ? delta : 0; // deferred
                        } else {
                            if (beautifyActiveFlag(JavaScriptMode, JavaScriptFlag, CPPMode, PerlMode)) {
                                ti = (tabtotal > 0) ? tabtotal : 0; // pass to index
                            } else {
                                ti = 0;
                            }
                        }
                        //System.out.println("h");
                        if (!PerlMode && sourceLine.length() > 0 && sourceLine.charAt(0) == '#') {
                            sourceOutLine = sourceLine; // no indent
                        } else {
                            if ((ContinueLine) && (beautifyActiveFlag(JavaScriptMode, JavaScriptFlag, CPPMode, PerlMode))) {
                                if ((beauFindLeft(sourceTest, "{"))
                                        || (beauFindLeft(sourceTest, "("))
                                        || (beauFindLeft(sourceTest, ")"))
                                        || (beauFindLeft(sourceTest, "}"))
                                        || (sourceTest.length() == 0)) {
                                    ContinueLine = false;
                                } else {
                                    if ((tabtotal > 0) && (beautifyActiveFlag(JavaScriptMode, JavaScriptFlag, CPPMode, PerlMode))) {
                                        sourceOutLine += tabChar;
                                    }
                                    if (beauFindRight(sourceTest, ";")) // end of continuation
                                    {
                                        ContinueLine = false;
                                    }
                                }
                            }
                            // CString z;
                            // z.Format("%d",ContinueLine);
                            if (singleIndentThisLine) {
                                sourceOutLine += tabChar;
                            }
                            while (ti-- > 0) {
                                sourceOutLine += tabChar;
                            }
                            // preserve Java-style comment indenting
                            if (CComment && sourceLine.length() > 0 && sourceLine.charAt(0) == '*') {
                                sourceOutLine += ' ';
                            }

                            sourceOutLine += sourceLine; // normal indent
                        }
                        //System.out.println("i");
                        heapOutStr.append(sourceOutLine);
                        if (lineEndsInLineFeed) {
                            heapOutStr.append("\n");
                        }
                        if ((!CComment)
                                && (beautifyActiveFlag(JavaScriptMode, JavaScriptFlag, CPPMode, PerlMode))
                                && (sourceTest.length() > 0)
                                && (!beauFindRight(sourceTest, "{"))
                                && (!beauFindRight(sourceTest, "("))
                                && (!beauFindLeft(sourceTest, "}"))
                                && ((PerlMode) && (!beauFindLeft(sourceTest, "#")))
                                && (!beauFindRight(sourceTest, ","))
                                && (!beauFindRight(sourceTest, ";"))) // if a continuation command
                        {
                            ContinueLine = true;
                        }
                        if (CCommentStart) {
                            CComment = true;
                            CCommentStart = false;
                        }
                        if ((beauFind(sourceTest, "<script") && !beauFind(sourceTest, "</script"))
                                || (beauFind(sourceTest, "<style") && !beauFind(sourceTest, "</style"))
                                || (beauFind(sourceTest, "<?php") && !beauFind(sourceTest, "?>"))
                                || (beauFind(sourceTest, "<%") && !beauFind(sourceTest, "%>"))) {
                            //System.out.println("javascriptflag=true");
                            JavaScriptFlag = true;
                        }
                    } // if valid

                } while (valid && sourceIndex < sourceLength);

                String r = processDelimErrors(parenCount, braceCount, bracketCount);
                if (r.length() > 0) {
                    JOptionPane.showMessageDialog(main, r, ArachConstants.APPNAME + " Code Beautifier", JOptionPane.INFORMATION_MESSAGE);
                }

                return heapOutStr.toString();
            }
        }
    }

    String getKeyWord(String s) {
        int i = 0;
        int len = s.length();
        while (i < len && Character.isLetter(s.charAt(i))) {
            i++;
        }
        return s.substring(0, i);
    }

    boolean isIndentKeyword(String s) {
        return keywordHash.contains(s);
    }

    String beauKeepLeftOf(String q, String v) {
        int i = q.indexOf(v);
        if (i != -1) {
            return q.substring(0, i);
        } else {
            return q;
        }
    }

    String beauKeepRightOf(String q, String v) {
        int i = q.indexOf(v);
        if (i != -1) {
            return q.substring(i + v.length());
        } else {
            return q;
        }
    }

    String beauDelete(String q, String v) {
        return q.replaceAll(v, "");
    }

    String beauDeleteBetween(String q, String a, String b) {
        return q.replaceAll(a + ".+?" + b, "");
    }

    // count instances of any of a set of characters in string
    int beauCount(String q, String set) {
        int count = 0;
        int len = q.length();
        for (int i = 0; i < len; i++) {
            int j = set.indexOf(q.charAt(i));
            if (j != -1) {
                count++;
            }
        }
        return count;
    }

    boolean beauFind(String q, String v) {
        int i;
        int count = 0;
        i = q.toLowerCase().indexOf(v);

        return (i != -1);
    }

    boolean beauFindLeft(String q, String v) {
        int i = q.toLowerCase().indexOf(v);
        return (i == 0);
    }

    boolean beauFindRight(String q, String v) {
        int i = q.toLowerCase().indexOf(v);
        if (i == -1) {
            return false;
        }
        return (i == (q.length() - v.length()));
    }

    private void makeDelimErrorString(StringBuilder r, String pre, String tab, int v, String leftDelim, String rightDelim) {
        if (v != 0) {
            r.append((r.length() == 0) ? pre : tab).append(Math.abs(v)).append(" too many \"").append((v < 0) ? rightDelim : leftDelim).append("\"\n");
        }
    }

    private String processDelimErrors(int parenCount, int braceCount, int bracketCount) {
        String prologue = "Code Beautifier Error(s): ";
        int len = prologue.length();
        String tabBlock = ArachComp.doPreTab(len, ' ');
        StringBuilder r = new StringBuilder();
        if ((parenCount != 0) || (braceCount != 0) || (bracketCount != 0)) {
            makeDelimErrorString(r, prologue, tabBlock, parenCount, "(", ")");
            makeDelimErrorString(r, prologue, tabBlock, braceCount, "{", "}");
            makeDelimErrorString(r, prologue, tabBlock, bracketCount, "[", "]");
        }
        return r.toString();
    }
}
