/// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

/*
 * MenuManager.java
 *
 * Created on February 18, 2002, 8:26 AM
 */
package MacroManager;

import Arachnophilia.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class MenuManager {

    Arachnophilia main;
    ArrayList<String> comList;
    int comIndex;
    TreeMap<String,DefaultMutableTreeNode> macroMap;
    DefaultMutableTreeNode node;

    /** Creates new MenuManager */
    public MenuManager(Arachnophilia m) {
        main = m;
    }

    public TreeMap<String,DefaultMutableTreeNode> buildMenus(DefaultMutableTreeNode node) {
        // delete existing menus from everywhere

        main.getMenu("").removeAll();
        main.getMenu("_DocPopup").removeAll();
        main.getMenu("_RootPopup").removeAll();
        comList = new ArrayList<String>();
        comIndex = 0;
        macroMap = new TreeMap<String,DefaultMutableTreeNode>();
        buildMenusRecursive(null, node, comIndex, macroMap);
        main.getMenu("").updateUI();
        main.getMenu("_DocPopup").updateUI();
        main.getMenu("_RootPopup").updateUI();
        return macroMap;
    }

    private int buildMenusRecursive(JComponent parentMenu, DefaultMutableTreeNode parent, int index, TreeMap<String,DefaultMutableTreeNode> macroMap) {
        node = null;
        int len = parent.getChildCount();
        for (int i = 0; i < len; i++) {
            node = (DefaultMutableTreeNode) parent.getChildAt(i);
            MacroTreeNodeData data = (MacroTreeNodeData) node.getUserObject();
            if (!data.isHidden) {
                boolean hasChildren = node.getChildCount() > 0;
                String name = data.title;
                if (hasChildren) {
                    JComponent newMenu = null;
                    if (parentMenu != null) { // if this is a submenu
                        newMenu = new MyJMenu(node);
                        setupItem(newMenu, data);
                        parentMenu.add(newMenu);
                        //addMouseHook(newMenu);
                        index = buildMenusRecursive(newMenu, node, index, macroMap);
                    } else { // no existing menu
                        if (data.isMenu) {
                            newMenu = new MyJMenu(node);
                            setupItem(newMenu, data);
                            JComponent comp = main.getMenu(name);
                            //System.out.println(comp);
                            if (comp instanceof JPopupMenu) {
                                newMenu = (JPopupMenu) comp;
                            } else {
                                comp.add((Component) newMenu);
                            }
                            //addMouseHook(newMenu);
                        }
                        index = buildMenusRecursive(newMenu, node, index, macroMap);
                    } //no existing menu
                } // has children
                else { // no children
                    // add this leaf to macro list
                    if (!data.isHidden && !data.isMenu && !data.isToolBar && !data.isSeparator) {
                        String key = ArachComp.getStringForNode(node);
                        macroMap.put(key, node);
                    }
                    if (parentMenu != null) { // is a leaf
                        if (data.isSeparator) {
                            if (parentMenu instanceof JPopupMenu) {
                                ((JPopupMenu) parentMenu).addSeparator();
                            } else {
                                ((JMenu) parentMenu).addSeparator();
                            }
                        } // is this a call for a New/Open menu tree?
                        else { // not a separator

                            String com = data.content.toLowerCase();
                            //System.out.println(com);
                            if (com.indexOf("[buildnewopenmenus]") != -1 || com.indexOf("[locatefilelist]") != -1) {
                                main.comSwitchboard.exec(data.content, 0, parentMenu);
                            } else { // not a menu builing command, must be a leaf
                                MyJMenuItem item = new MyJMenuItem(node);
                                setupItem(item, data);
                                index = addHook(index, item, data.content);
                                parentMenu.add(item);
                                //addMouseHook(item);
                            }
                        }
                    }
                } // is a leaf
            } // not hidden
        }
        return index;
    }

    /*
    private void addMouseHook(JComponent menu) {
    menu.addMouseListener(new java.awt.event.MouseAdapter() {
    
    public void mousePressed(java.awt.event.MouseEvent evt) {
    mouseHandler(evt, 1);
    }
    
    public void mouseReleased(java.awt.event.MouseEvent evt) {
    mouseHandler(evt, 2);
    }
    });
    }*/
    private void setupItem(JComponent item, MacroTreeNodeData data) {
        if (item != null && !(item instanceof JPopupMenu)) {
            AbstractButton ai = (AbstractButton) item;
            String t = data.title;
            try {
                if (data.keyboardHook != null && data.keyboardHook.isValid()) {
                    if (item instanceof MyJMenuItem) {
                        ((MyJMenuItem) ai).setAccelerator(KeyStroke.getKeyStroke(data.keyboardHook.getKeyCode(), data.keyboardHook.getModifiers()));
                    } else if (item instanceof MyJMenu) {
                        ai.setMnemonic(data.keyboardHook.getKeyCode());
                    }
                }
            } catch (Exception e) {
                e.printStackTrace(System.out);
            }
            ai.setText(t);
            if (data.toolTip.length() > 0) {
                ai.setToolTipText(data.toolTip);
            }
            if (data.imageIcon != null) {
                ai.setIcon(data.imageIcon);
            }
        }
    }

    private int addHook(int i, AbstractButton item, String com) {
        final int v = i;
        item.addActionListener(new java.awt.event.ActionListener() {

            @Override
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                execCom(v);
            }
        });
        comList.add(com);
        return i + 1;
    }

    private void execCom(int i) {
        if (i >= 0 && i < comList.size()) {
            main.macroHandler.executeCommand( comList.get(i));
        }
    }

    private void mousePopupHandler(JComponent comp, DefaultMutableTreeNode node, java.awt.event.MouseEvent evt, int type) {
        //System.out.println("Popuptrigger in MenuManager 1: " + node);
        //evt.consume();
        JPopupMenu pop = main.getMacroPanel().getButtonMenu(node);
        if (pop.isPopupTrigger(evt)) {
            //System.out.println("Popuptrigger in MenuManager 2: " + node);
            //evt.consume();
            int x = evt.getXOnScreen() - main.getX();
            int y = evt.getYOnScreen() - main.getY();
            //System.out.println("Popuptrigger 3: " + x + "," + y);
            pop.show(main, x,y);
        }
    }

    class MyJMenu extends JMenu {

        DefaultMutableTreeNode node = null;

        public MyJMenu(DefaultMutableTreeNode node) {
            super();
            this.node = node;
        }

        public MyJMenu(String s) {
            super(s);
        }

        // trap right-click
        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.getModifiers() == MouseEvent.BUTTON3_MASK) {
                mousePopupHandler(this, node, e, 3);
            } else {
                super.processMouseEvent(e);
            }
        }
    }

    class MyJMenuItem extends JMenuItem {

        DefaultMutableTreeNode node = null;

        public MyJMenuItem(DefaultMutableTreeNode node) {
            super();
            this.node = node;
        }

        public MyJMenuItem(String s) {
            super(s);
        }

        // trap right-click
        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.getModifiers() == MouseEvent.BUTTON3_MASK) {
                mousePopupHandler(this, node, e, 3);
            } else {
                super.processMouseEvent(e);
            }
        }
    }
}
