// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * KeyDescription.java
 *
 * Created on April 5, 2002, 3:46 PM
 */

package MacroManager;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 *
 * @author  Administrator
 * @version
 */
public class KeyDescription {
    
    //private char keyChar = 0;
    private int keyCode = 0;
    private int keyMods = 0;
    private boolean valid = false;
    private String description = null;
    /** Creates new KeyDescription */
    public KeyDescription() {
    }
    
    public KeyDescription(int code,int mods) {
        this(KeyStroke.getKeyStroke(code,mods));
    }
    
    public KeyDescription(KeyEvent evt) {
        this(KeyStroke.getKeyStrokeForEvent(evt));
    }
    
    public KeyDescription(KeyStroke k) {
        if(k != null) {
            keyCode = k.getKeyCode();
            keyMods = k.getModifiers();
            if(keyCode > 0 || keyMods > 0) {
                valid = true;
            }
        }
    }
    
    public KeyDescription(String desc) {
        String[] sa = desc.split(",");
        if(sa.length == 2) {
            try {
                keyCode  = Integer.parseInt(sa[0]);
                keyMods  = Integer.parseInt(sa[1]);
                if(keyCode > 0 || keyMods > 0) {
                    valid = true;
                }
            }
            catch (NumberFormatException e) {
            }
        }
    }
    
    public Object clone() {
        return new KeyDescription(keyCode,keyMods);
    }
    
    public boolean isValid() {
        return valid;
    }
    
    public int getKeyCode() {
        return keyCode;
    }
    public int getModifiers() {
        return keyMods;
    }
    public String toString() {
        return keyCode + "," + keyMods;
    }
    
    public String getDescription() {
        
        if(!valid) {
            return "";
        }
        if(description != null) {
            return description;
        }
        description = getTextForm();
        return (description == null)?"":description;
    }
    
    private boolean isCtrlAltModified(int mods) {
        return ((mods & KeyEvent.ALT_MASK) != 0
        || (mods & KeyEvent.CTRL_MASK) != 0 );
    }
    
    public String getTextForm() {
        String keyMod = KeyEvent.getKeyModifiersText(keyMods);
        String keyDesc = KeyEvent.getKeyText(keyCode);
        //System.out.println(keyMod + "-" + keyDesc + "," + keyCode);
        //System.out.println(KeyEvent.SHIFT_MASK + "," + KeyEvent.ALT_MASK + "," + KeyEvent.CTRL_MASK);
        // test: is this an unmodified letter or enter key
        if(keyCode != KeyEvent.VK_TAB && keyCode < ' ' && !isCtrlAltModified(keyMods)) {
            return null;
        }
        //if((keyDesc.length() < 2 || keyCode == KeyEvent.VK_SPACE) && (((keyMods & KeyEvent.SHIFT_MASK) != 0) || keyMod.equals(""))) {
        //    return null;
        //}
        String macroCode = "";
        if(keyMod.length() > 0) {
            macroCode = keyMod + "-";
        }
        macroCode += keyDesc;
        description = macroCode;
        return macroCode;
    }
}
