// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * LookAndFeelPanel.java
 *
 * Created on March 10, 2002, 8:44 AM
 */

package LookAndFeel;

import Arachnophilia.*;
import javax.swing.JList;

/**
 *
 * @author  Administrator
 */
public class LookAndFeelPanel extends javax.swing.JPanel {

    Arachnophilia main;
    LookAndFeelDialog dialog;
    String[][] lookAndFeelNames;
    /** Creates new form LookAndFeelPanel */
    public LookAndFeelPanel(Arachnophilia m,LookAndFeelDialog d,String arg) {
        main = m;
        dialog = d;
        initComponents();
        String prompt = "This dialog allows you to choose a look & feel for " + ArachConstants.APPNAME + ". A look & feel is a set of appearances and behaviors that you can use to change how Arachnophilia behaves.\n\n"
        + "Choose a look & feel from the list below. Then click \"Apply\" to apply it to Arachnophilia.\n\n"
        + "Some of the changes may not fully \"take\" until you have exited and re-entered Arachnophilia.";
        
        messageArea.setText(prompt);
        messageArea.setBackground(getBackground());
        lookAndFeelNames = ArachComp.getLookAndFeelNames();
        lfList.setListData(lookAndFeelNames[1]);
    }
    
    public void apply()
    {
        int i = lfList.getSelectedIndex();
        if(i >= 0) {
            ArachComp.setupLookAndFeel(lookAndFeelNames[0][i]);
            main.configValues.lookAndFeelName = lookAndFeelNames[0][i];
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        topPane = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        messageArea = new javax.swing.JTextArea();
        centerPane = new javax.swing.JPanel();
        lfList = new JList<String>();
        bottomPane = new javax.swing.JPanel();
        applyButton = new MyJButton();
        quitButton = new MyJButton();

        setLayout(new java.awt.BorderLayout());

        topPane.setLayout(new java.awt.BorderLayout());

        jScrollPane1.setPreferredSize(new java.awt.Dimension(350, 200));

        messageArea.setBackground(new java.awt.Color(204, 204, 204));
        messageArea.setEditable(false);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setMargin(new java.awt.Insets(8, 8, 8, 8));
        jScrollPane1.setViewportView(messageArea);

        topPane.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(topPane, java.awt.BorderLayout.NORTH);

        centerPane.setLayout(new java.awt.BorderLayout());

        lfList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        lfList.setToolTipText("Choose a look & feel, then press \"Apply\"");
        centerPane.add(lfList, java.awt.BorderLayout.CENTER);

        add(centerPane, java.awt.BorderLayout.CENTER);

        applyButton.setText("Apply");
        applyButton.setToolTipText("Apply the chosen Look & Feel to the main application");
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyButtonActionPerformed(evt);
            }
        });
        bottomPane.add(applyButton);

        quitButton.setText("Quit");
        quitButton.setToolTipText("Quit this dialog");
        quitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                quitButtonActionPerformed(evt);
            }
        });
        bottomPane.add(quitButton);

        add(bottomPane, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_applyButtonActionPerformed
        // Add your handling code here:
        apply();
    }//GEN-LAST:event_applyButtonActionPerformed

    private void quitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_quitButtonActionPerformed
        // Add your handling code here:
        dialog.quit();
    }//GEN-LAST:event_quitButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton applyButton;
    private javax.swing.JPanel bottomPane;
    private javax.swing.JPanel centerPane;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList<String> lfList;
    private javax.swing.JTextArea messageArea;
    private javax.swing.JButton quitButton;
    private javax.swing.JPanel topPane;
    // End of variables declaration//GEN-END:variables

}
