// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * TableWizardFrame.java
 *
 * Created on February 24, 2002, 10:12 AM
 */

package ListTableWizards;

//import ArachConstants;
import Arachnophilia.*;
import java.awt.*;

/**
 *
 * @author  Administrator
 */
final public class TableWizardFrame extends javax.swing.JFrame {
    
    TableWizardPanel panel;
    Arachnophilia main;
    /** Creates new form TableWizardFrame */
    public TableWizardFrame(Arachnophilia m) {
        //super(m,true);
        main = m;
        initComponents();
        panel = new TableWizardPanel(m,this);
        getContentPane().add(panel);
        setIconImage(m.getIconImage());
        setTitle(ArachConstants.APPNAME + " Table Wizard");
        pack();
        Point r = m.getLocation();
        Dimension d = m.getSize();
        
        setLocation(r.x+d.width/32,r.y+d.height/32);
       
    }
    
    public void launch()
    {
        main.haveFocus = false;
        setVisible(true);
        panel.launch();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        pack();
    }//GEN-END:initComponents
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        //System.exit(0);
        quit();
    }//GEN-LAST:event_exitForm
    
    public void quit() {
        panel.quit();
        setVisible(false);
        main.haveFocus = true;
        main.requestFocusInWindow();
    }
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
        new TableWizardFrame().show();
    }*/
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
