// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * TableWizData.java
 *
 * Created on February 24, 2002, 11:46 AM
 */

package ListTableWizards;

/**
 *
 * @author  Administrator
 * @version
 */
final public class TableWizData {
    
    public int backgroundColor = 0xc4ffff;
    public int borderColor = 0xa00000;
    public int titleRowColor = 0xd9fed3;
    public int defaultRows = 4;
    public int defaultColumns = 4;
    public int tableWidth = 95;
    public int borderWidth = 1;
    public int cellPadding = 4;
    public int cellSpacing = 0;
    public int dataDelimiter = ',';
    public boolean commentMarkers = true;
    public boolean centerData = false;
    public boolean placeholderData = true;
    public boolean boldFirstRow = true;
    public boolean titlecolorFirstRow = false;
    public boolean boldFirstColumn = true;
    public boolean titlecolorFirstColumn = false;
    public boolean colorBackground = false;
    public boolean colorBorder = false;
    
    /** Creates new TableWizData */
    public TableWizData() {
    }
    
    public TableWizData(
    int a,int b,int c,int d,int e,int f,int g,int h,int i,int j,
    boolean k,boolean l,boolean m,boolean n,boolean o,boolean p,boolean q,boolean r,boolean s) {
        backgroundColor = a;
        borderColor = b;
        titleRowColor = c;
        defaultRows = d;
        defaultColumns = e;
        tableWidth = f;
        borderWidth = g;
        cellPadding = h;
        cellSpacing = i;
        dataDelimiter = j;
        commentMarkers = k;
        centerData = l;
        placeholderData = m;
        boldFirstRow = n;
        titlecolorFirstRow = o;
        boldFirstColumn = p;
        titlecolorFirstColumn = q;
        colorBackground = p;
        colorBorder = r;
    }
    
    static public TableWizData clone(TableWizData d) {
        return new TableWizData(
        d.backgroundColor,
        d.borderColor,
        d.titleRowColor,
        d.defaultRows,
        d.defaultColumns,
        d.tableWidth,
        d.borderWidth,
        d.cellPadding,
        d.cellSpacing,
        d.dataDelimiter,
        d.commentMarkers,
        d.centerData,
        d.placeholderData,
        d.boldFirstRow,
        d.titlecolorFirstRow,
        d.boldFirstColumn,
        d.titlecolorFirstColumn,
        d.colorBackground,
        d.colorBorder
        );
    }
    
    public String toString() {
        return "["
        + "backgroundColor=" + backgroundColor
        + ",borderColor=" + borderColor
        + ",titleRowColor=" + titleRowColor
        + ",defaultRows=" + defaultRows
        + ",defaultColumns=" + defaultColumns
        + ",tableWidth=" + tableWidth
        + ",borderWidth=" + borderWidth
        + ",cellPadding=" + cellPadding
        + ",cellSpacing=" + cellSpacing
        + ",dataDelimiter=" + dataDelimiter
        + ",commentMarkers=" + commentMarkers
        + ",centerData=" + centerData
        + ",placeholderData=" + placeholderData
        + ",boldFirstRow=" + boldFirstRow
        + ",titlecolorFirstRow=" + titlecolorFirstRow
        + ",boldFirstColumn=" + boldFirstColumn
        + ",titlecolorFirstColumn=" + titlecolorFirstColumn
        + ",colorBackground=" + colorBackground
        + ",colorBorder=" + colorBorder
        + "]";
    }
    
}
