// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * HTMLValidatorDialog.java
 *
 * Created on November 4, 2006, 12:15 PM
 */

package HTMLValidator;
import Arachnophilia.*;
import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  Administrator
 */
public class HTMLValidatorDialog extends javax.swing.JFrame {
    
    /** Creates new form HTMLValidatorDialog */
    Arachnophilia main;
    HTMLValidator htmlv;
    public HTMLValidatorDialog(Arachnophilia m,HTMLValidator hv) {
        main = m;
        htmlv = hv;
        initComponents();
        setIconImage(main.getIconImage());
        setTitle(ArachConstants.APPNAME + " HTML Validator Interactive Dialog");
        Rectangle ss = main.getBounds();
        int w = ss.width/2;
        int h = ss.height/2;
        setBounds(ss.x+ss.width-w,ss.y,w,h);
        setVisible(true);
        textResults.requestFocusInWindow();
    }
    
    public void setText(String s) {
        textResults.setText(s);
        textResults.setSelectionStart(0);
        textResults.setSelectionEnd(0);
    }
    
    public void processMouseClick(MouseEvent evt) {
        processMouseAction(evt,true);
    }
    
    public void processMouseMove(MouseEvent evt) {
        processMouseAction(evt,false);
    }
    
    public void processMouseAction(MouseEvent evt,boolean click) {
        try {
            int offset = textResults.viewToModel(evt.getPoint());
            int line = textResults.getLineOfOffset(offset);
            int start = textResults.getLineStartOffset(line);
            int end = textResults.getLineEndOffset(line);
            
            String lt = textResults.getText(start,end-start);
            if (lt != null && htmlv.isValidLine(lt)) {
                //System.out.println("line = " + lt);
                textResults.setSelectionStart(start);
                textResults.setSelectionEnd(end);
                if(click) {
                    htmlv.gotoLine(lt);
                }
            }
            else {
                textResults.setSelectionStart(start);
                textResults.setSelectionEnd(start);
            }
        }
        catch(Exception e) {
            System.out.println(e.toString());
        }
    }
    
    public void quit() {
        setVisible(false);
        dispose();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        textResults = new MyJTextArea(main);
        jPanel1 = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        textResults.setEditable(false);
        textResults.setFont(new java.awt.Font("Monospaced", 0, 12)); // NOI18N
        textResults.setMargin(new java.awt.Insets(4, 4, 4, 4));
        textResults.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                textResultsMouseClicked(evt);
            }
        });
        textResults.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                textResultsMouseMoved(evt);
            }
        });
        jScrollPane1.setViewportView(textResults);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        jPanel1.add(closeButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents
    
    private void textResultsMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_textResultsMouseMoved
        // TODO add your handling code here:
        processMouseMove(evt);
    }//GEN-LAST:event_textResultsMouseMoved
    
    private void textResultsMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_textResultsMouseClicked
        processMouseClick(evt);
    }//GEN-LAST:event_textResultsMouseClicked
    
    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        quit();
    }//GEN-LAST:event_closeButtonActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        //System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    // public static void main(String args[]) {
    //     new HTMLValidatorDialog().show();
    // }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JButton closeButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea textResults;
    // End of variables declaration//GEN-END:variables
    
}
