// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * MyClassLoader.java
 *
 * Created on February 28, 2002, 3:16 PM
 */

package CustomClassFunctions;

/**
 *
 * @author  Administrator
 * @version
 */
import java. io.*;

// classes loaded with this classloader
// only exist as long as the loader does.
// If the instance of the loader is discarded,
// then the loaded class goes away. This
// means the class is always loaded fresh
// on each invocation.

final public class MyClassLoader extends ClassLoader {
    
    Exception error = null;
    public Exception getError()
    {
        return error;
    }
    public synchronized Class loadClass(String path,String packageName,String name) {
        Class c = null;
        try {
            String fullPath = path + "/" + name + ".class";
            //System.out.println("loading: " + fullPath);
            RandomAccessFile file = new RandomAccessFile(fullPath, "r");
            byte data[] = new byte[(int) file. length()];
            file.readFully(data);
            file.close();
            c = defineClass(packageName + "." + name, data, 0, data.length);
        }
        catch( Exception e) {
            error = e;
            //System.out.println("MyClassLoader Error: " + e);
        }
        //if (resolve)
        //    resolveClass(c);
        return c;
    }
}
