// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * ConsoleWindow.java
 *
 * Created on February 13, 2002, 2:35 PM
 */

package ConsoleWindow;

//import MyJButton;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.Timer;
import Arachnophilia.*;
//import ArachConstants;

/**
 *
 * @author  Administrator
 */
public class ConsoleWindow extends javax.swing.JFrame {
    
    Arachnophilia main;
    //Process p;
    InputStream is;
    InputStream es;
    OutputStream os;
    Timer timer;
    int displayPos = 0;
    
    /** Creates new form ConsoleWindow */
    public ConsoleWindow(Arachnophilia m,Process p) {
        main = m;
        initComponents();
        setTitle(ArachConstants.APPNAME + " System Console Window");
        setIconImage(m.getIconImage());
        Rectangle r = main.getBounds();
        int w = r.width/8;
        int h = r.height/8;
        setBounds(r.x+w,r.y+h,r.width-w*2,r.height-h*2);
        setVisible(true);
        //try {
        //p = Runtime.getRuntime().exec(comString);
        is = p.getInputStream();
        es = p.getErrorStream();
        os = p.getOutputStream();
        
        timer = new Timer(20,
        new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                readStream(is);
                readStream(es);
            }
        }
        );
        timer.start();
        display.requestFocusInWindow();
    }
    
    private void readStream(InputStream is) {
        try {
            int len = is.available();
            if(len > 0) {
                byte[] b = new byte[len];
                is.read(b);
                String s = new String(b);
                display.append(s);
                displayPos = display.getDocument().getLength();
                display.setCaretPosition(displayPos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        popupMenu = new javax.swing.JPopupMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jScrollPane1 = new javax.swing.JScrollPane();
        display = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new MyJButton();

        jMenuItem1.setText("Toggle line wrap");
        jMenuItem1.setToolTipText("Choose between wrapped and unwrapped text");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });

        popupMenu.add(jMenuItem1);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        display.setFont(new java.awt.Font("Monospaced", 0, 12));
        display.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                displayKeyTyped(evt);
            }
            public void keyPressed(java.awt.event.KeyEvent evt) {
                displayKeyPressed(evt);
            }
            public void keyReleased(java.awt.event.KeyEvent evt) {
                displayKeyReleased(evt);
            }
        });

        display.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                displayMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                displayMouseReleased(evt);
            }
        });

        jScrollPane1.setViewportView(display);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jButton1.setText("Close");
        jButton1.setToolTipText("Close this window");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton1);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        // Add your handling code here:
        toggleLineWrap();
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    private void displayMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_displayMouseReleased
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_displayMouseReleased

    private void displayMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_displayMousePressed
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_displayMousePressed
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // Add your handling code here:
        doClose();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    private void displayKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_displayKeyReleased
        // Add your handling code here:
        handleKey(evt);
    }//GEN-LAST:event_displayKeyReleased
    
    private void displayKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_displayKeyPressed
        // Add your handling code here:
        handleKey(evt);
    }//GEN-LAST:event_displayKeyPressed
    
    private void displayKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_displayKeyTyped
        // Add your handling code here:
        handleKey(evt);
    }//GEN-LAST:event_displayKeyTyped
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        //System.exit(0);
        doClose();
    }//GEN-LAST:event_exitForm
    
    private void toggleLineWrap()
    {
        display.setLineWrap(!display.getLineWrap());
        display.setWrapStyleWord(true);
    }
    private void handleMouse(java.awt.event.MouseEvent evt) {
        if(popupMenu.isPopupTrigger(evt)) {
            popupMenu.show(display,evt.getX(),evt.getY());
        }
    }
    
    private void doClose() {
        timer.stop();
        setVisible(false);
        dispose();
    }
    
    private void handleKey(java.awt.event.KeyEvent evt) {
        if(evt.getID() == KeyEvent.KEY_PRESSED) {
            char c = evt.getKeyChar();
            
            if(c != KeyEvent.CHAR_UNDEFINED) {
                //if(c == 127) c = 8;
                //System.out.println(c + "," + (int)c);
                try {
                    // this batch method gets around
                    // a very difficult backspace interpretation problem
                    if(c == KeyEvent.VK_ENTER) {
                        int end = display.getCaretPosition();
                        String s = display.getDocument().getText(displayPos,end-displayPos);
                        s += c;
                        os.write(s.getBytes());
                        os.flush();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        //evt.consume();
    }
    /**
     * @param args the command line arguments
     */
    /*
    public static void main(String args[]) {
        new ConsoleWindow().show();
    }*/
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton jButton1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPopupMenu popupMenu;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JTextArea display;
    // End of variables declaration//GEN-END:variables
    
}
