// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * BrowserData.java
 *
 * Created on February 23, 2002, 10:30 AM
 */

package BrowserStuff;

import java.io.*;
import java.util.*;

/**
 *
 * @author  Administrator
 * @version
 */
public final class BrowserData {
    
    public String name = "--";
    public String appPath = "";
    public String htmlLaunchArgument = "file:$1";
    public String phpLaunchArgument = "http://server-name/server-path/$1";
    boolean closeBeforeOpening = true;
    boolean alwaysJumpToDocPos = true;
    /** Creates new BrowserData */
    public BrowserData() {
    }
    
    public BrowserData(String s) {
        int p = 0;
        String[] sa = parseFields(s);
        if(sa.length == 6) {
            name = sa[0];
            appPath = sa[1];
            htmlLaunchArgument = sa[2];
            phpLaunchArgument = sa[3];
            closeBeforeOpening = sa[4].equals("true");
            alwaysJumpToDocPos  = sa[5].equals("true");
        }
    }
    
    private String[] parseFields(String s)
    {
        int a = 0,b;
        ArrayList<String> v= new ArrayList<String>();
        while((b = s.indexOf(",",a)) != -1) {
            v.add(s.substring(a,b));
            a = b+1;
        }
        if(a < s.length()) {
            v.add(s.substring(a));
        }
        return v.toArray(new String[]{});
    }
    
    public boolean exists()
    {
        return new File(appPath).exists();
    }

    public BrowserData(String n,String ap,String hla,String pla,boolean cbo,boolean ajdp) {
        name = n;
        appPath = ap;
        htmlLaunchArgument = hla;
        phpLaunchArgument = pla;
        closeBeforeOpening = cbo;
        alwaysJumpToDocPos = ajdp;
    }
    
    static public BrowserData clone(BrowserData v) {
        return new BrowserData(v.name,v.appPath,v.htmlLaunchArgument,v.phpLaunchArgument,v.closeBeforeOpening,v.alwaysJumpToDocPos);
    }
    
    @Override
    public String toString() {
        return name
        + "," + appPath
        + "," + htmlLaunchArgument
        + "," + phpLaunchArgument
        + "," + closeBeforeOpening
        + "," + alwaysJumpToDocPos;
    }
    
    public String formatActivationString(String as,String token,String replace) {
        StringBuilder sb = new StringBuilder();
        int a = 0,b;
        while((b = as.indexOf(token,a)) != -1) {
            sb.append(as.substring(a,b)).append(replace);
            a = b + replace.length();
        }
        if(a < as.length()) {
            sb.append(as.substring(a));
        }
        return sb.toString();
    }
    
}
