// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * UndoRedoHandler.java
 *
 * Created on February 7, 2002, 4:34 PM
 */

import javax.swing.text.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class UndoRedoHandler {
    Arachnophilia main;
    int stackSize = 0;
    int undoLevel = 0;
    int undoPtr = 0;
    int redoLevel = 0;
    int redoPtr = 0;
    StringStack undoStack;
    StringStack redoStack;
    public UndoRedoHandler(Arachnophilia m,int ss) {
        main = m;
        stackSize = ss;
        undoStack = new StringStack(ss);
        redoStack = new StringStack(ss);
    }
    
    public void undoPush(MySyntaxTextArea ti) {
        undoStack.push(ti);
    }
    
    public void undoPop(MySyntaxTextArea ti) {
        if(undoStack.level > 0) {
            redoStack.push(ti);
            undoStack.pop(ti);
        }
        else {
           main.beep();
        }
    }
    
    public void redoPop(MySyntaxTextArea ti) {
        if(redoStack.level > 0) {
            undoStack.push(ti);
            redoStack.pop(ti);
        }
        else {
            main.beep();
        }
    }
    
    class StringStack {
        int size;
        int pointer = 0;
        int level = 0;
        UndoData[] data;
        StringStack(int s) {
            size = s;
            data = new UndoData[s];
        }
        
        public void push(MySyntaxTextArea ti) {
            if(size > 0) {
                UndoData item = new UndoData(ti);
                push(item);
            }
        }
        
        public void push(UndoData item) {
            if (size > 0) {
                data[pointer % size] = item;
                pointer++;
                if(level < size) {
                    level++;
                }
            }
        }
        
        public void pop(MySyntaxTextArea ti) {
            UndoData item = pop();
            if(item != null) {
                ti.setText(item.str);
                ti.setSelectionStart(item.selStart);
                ti.setSelectionEnd(item.selEnd);
                ti.setFirstLine(item.firstLine);
                Caret car = ti.getCaret();
                if(car != null) {
                    ti.setCaretPosition(item.selEnd);
                    ti.moveCaretPosition(item.selEnd);
                    car.setSelectionVisible(true);
                }
            }
        }
        
        public UndoData pop() {
            UndoData item = null;
            if(size > 0) {
                if(level > 0) {
                    pointer--;
                    item = data[pointer % size];
                    data[pointer % size] = null;
                    level--;
                }
                else {
                    main.beep();
                }
            }
            return item;
        }
    }
    
    class UndoData {
        String str;
        int selStart;
        int selEnd;
        int firstLine;
        UndoData(String s,int a,int b,int c) {
            str = s;
            selStart = a;
            selEnd = b;
            firstLine = c;
        }
        
        UndoData(MySyntaxTextArea ti) {
            str = ti.getText();
            selStart = ti.getSelectionStart();
            selEnd = ti.getSelectionEnd();
            firstLine = ti.getFirstLine();
        }
    }
}
