// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;



/*
 * TextInterface.java
 *
 * Created on December 15, 2001, 4:21 PM
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import org.fife.ui.rsyntaxtextarea.*;

/**
 *
 * @author  Administrator
 * @version
 * this interface builds a bridge between two very different
 * text components -- one for syntax-colored text component 
 * but no line wrap, the other a plain text component
 * with line wrap.
 */
public interface TextInterface {
    //public void addFocusListener(FocusAdapter fa);
    public void setSelectionColor(Color c);
    public void setSelectedTextColor(Color c);
    public void centerCaretInView(int p);
    public void centerCaretInView();
    public void readNewColorValues();
    public int getVisibleLines();
    public int getFirstLine();
    public void setFirstLine(int v);
    public int getCaretLine();
    public int getLineCount();
    public Caret getCaret();
    public int getCaretPosition();
    public void setCaretPosition(int x);
    public void moveCaretPosition(int x);
    public String getLineText(int pos);
    public int getLineStartOffset(int pos);
    public int getLineEndOffset(int pos) throws javax.swing.text.BadLocationException;
    public int getLength();
    public int getLineLength(int caretLine);
    public Document getDocument();
    public String getText();
    public String getText(int offset, int length);
    public void setText(String s);
    public int getSelectionStart();
    public int getSelectionEnd();
    public String getSelectedText();
    public void setSelectionStart(int a);
    public void setSelectionEnd(int b);
    public void select(int a, int b);
    public void replaceSelection(String s);
    public void setFont(Font f);
    public Font getFont();
    public boolean getLineWrap();
    public void setLineWrap(boolean b);
    public void setWrapStyleWord(boolean b);
    public void addMouseListener(MouseAdapter m);
    public void requestFocus();
    public void rfiw();
    public void setRightClickPopup(JPopupMenu m);
    public void setTokenMaker(TokenMaker tokenMaker);
    public void centerEditPos();
    public void grabFocus();
    public void selectAll();
    public void cut();
    public void copy();
    public void paste();
    public void invalidate();
    public void repaint();
    public int viewToModel(Point p);
    
}

