// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * SplashWindow.java
 *
 * Created on February 27, 2002, 9:47 AM
 */

import java.awt.*;

/**
 *
 * @author  Administrator
 */
final public class SplashWindow extends javax.swing.JWindow {

    Arachnophilia main = null;
    /** Creates new form SplashWindow */
    public SplashWindow()
    {
        init();
    }
    public SplashWindow(Arachnophilia m) {
        main = m;
        init();
    }
    
    private void init()
    {
        initComponents();
        appName.setText("<html><b><h1>" + ArachConstants.APPNAME + "</h1></b></html>");
        prompt.setFont(new Font("Courier",Font.PLAIN,12));
        String path = (main != null)?main.basePath:"(path)";
        String content = "<html><b>Please stand by as Arachnophilia installs its user files.<p>"
        + "Now installing directories and files at:<br>" + path + "</b></html>";
        explain.setText(content);
        
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = screenSize.width/5;
        int h = screenSize.height/5;
        setBounds(w,h,screenSize.width-w*2,screenSize.height-h*2);
        setVisible(true);
    }
    
    public void append(String s)
    {
        prompt.append(s + "\n");
        prompt.setCaretPosition(prompt.getDocument().getLength()-1);
        //repaint();
        requestFocusInWindow();
        //pause();
    }
    
    private void pause()
    {
        try {
        Thread.sleep(1000);
        }
        catch(Exception e) {
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        thePane = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        prompt = new javax.swing.JTextArea();
        appName = new javax.swing.JLabel();
        explain = new javax.swing.JLabel();
        closeButton = new MyJButton();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        thePane.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0), 2));
        thePane.setLayout(new java.awt.GridBagLayout());

        prompt.setLineWrap(true);
        prompt.setWrapStyleWord(true);
        prompt.setMargin(new java.awt.Insets(4, 4, 4, 4));
        jScrollPane1.setViewportView(prompt);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 8, 8);
        thePane.add(jScrollPane1, gridBagConstraints);

        appName.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Arachnophilia/Arach.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 4, 4);
        thePane.add(appName, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 12);
        thePane.add(explain, gridBagConstraints);

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        thePane.add(closeButton, gridBagConstraints);

        getContentPane().add(thePane, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        quit();
    }//GEN-LAST:event_closeButtonActionPerformed

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        //System.exit(0);
        quit();
    }//GEN-LAST:event_exitForm

    
    private void quit()
    {
        setVisible(false);
        dispose();
    }
    
    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new SplashWindow().setVisible(true);
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel appName;
    private javax.swing.JButton closeButton;
    private javax.swing.JLabel explain;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea prompt;
    private javax.swing.JPanel thePane;
    // End of variables declaration//GEN-END:variables

}
