// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * FindReplacePanel.java
 *
 * Created on February 11, 2002, 11:23 AM
 */
import MacroManager.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.regex.*;
import javax.swing.*;

/**
 *
 * @author Administrator
 */
final public class SearchReplacePanel extends javax.swing.JPanel {

    Arachnophilia main;
    private SearchReplaceStuff searcher;
    private RegExpWrapperClass regExpWrapper;
    boolean expandedPanel = false;
    boolean lockAccess = false;
    String search;
    String replace;
    String unescSearch;
    String unescReplace;

    /**
     * Creates new form FindReplacePanel
     */
    public SearchReplacePanel(Arachnophilia m) {
        main = m;
        initComponents();
        //MyComboBoxEditor mce = new MyComboBoxEditor();
        //findList.setEditor(mce);
        findList.getEditor().getEditorComponent().addKeyListener(new java.awt.event.KeyAdapter() {

            @Override
            public void keyReleased(java.awt.event.KeyEvent evt) {
                processFindListKey(evt);
            }
        });
        replaceList.getEditor().getEditorComponent().addMouseListener(new java.awt.event.MouseAdapter() {

            @Override
            public void mousePressed(java.awt.event.MouseEvent evt) {
                handleReplaceRightClick(evt, replaceList);
            }

            @Override
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                handleReplaceRightClick(evt, replaceList);
            }
        });

        findList.getEditor().getEditorComponent().addMouseListener(new java.awt.event.MouseAdapter() {

            @Override
            public void mousePressed(java.awt.event.MouseEvent evt) {
                handleReplaceRightClick(evt, findList);
            }

            @Override
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                handleReplaceRightClick(evt, findList);
            }
        });
        searcher = new SearchReplaceStuff(main);
        regExpWrapper = new RegExpWrapperClass(main);
        setupCheckBoxes();
        setupStrings(main.configValues.findStrings, findList, main.configValues.findRepStringsLength);
        setupStrings(main.configValues.replaceStrings, replaceList, main.configValues.findRepStringsLength);
        showBottomPanel(main.configValues.expandedSearch);
    }

    private void setupCheckBoxes() {
        caseSensCheckBox.setSelected(main.configValues.caseSensitiveTextSearch);
        regExpCheckBox.setSelected(main.configValues.regExpTextSearch);
        instantModeCheckBox.setSelected(main.configValues.instantSearch);
        multiLineCheckBox.setSelected(main.configValues.multiLineSearch);
        dotMatchCheckBox.setSelected(main.configValues.dotMatchesNewline);
    }

    private void setupStrings(String[] sa, JComboBox<String> jc, int len) {
        ListCellRenderer<? super String> lcr = new MyCellRenderer();
        jc.setRenderer(lcr);
        for (int i = 0; i < len; i++) {
            String s = sa[i];
            if (s.length() > 0) {
                jc.addItem(s);
            }
        }
    }

    // this renderer fixes a bug in which the string "<html>"
    // causes a switch to HTML mode
    // which makes the tag disappear
    class MyCellRenderer extends JLabel implements ListCellRenderer<String> {

        public MyCellRenderer() {
            setOpaque(true);
        }

        @Override
        public java.awt.Component getListCellRendererComponent(javax.swing.JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            // push text out one space
            // to prevent interpretation as <HTML>
            setText(' ' + value.toString());
            if (isSelected) {
                setBackground(list.getSelectionBackground());
                setForeground(list.getSelectionForeground());
            } else {
                setBackground(list.getBackground());
                setForeground(list.getForeground());
            }
            return this;
        }
        /*
         public java.awt.Component getListCellRendererComponent(javax.swing.JList jList, java.lang.Object obj, int param, boolean param3, boolean param4) {
         } */

    }

    public void setFindFocus(String s) {
        ComboBoxEditor cbe = findList.getEditor();
        if (s != null) {
            cbe.setItem(s);
        }
        cbe.selectAll();
        // temporarily prevent document focus
        main.tweakDocFocus(false);
        findList.requestFocusInWindow();
    }

    public JComboBox getFindList() {
        return findList;
    }

    public JComboBox getReplaceList() {
        return replaceList;
    }

    public void saveStrings() {
        String localSearch = getFindString();
        addStringToList(localSearch, findList);
        String localReplace = getReplaceString();
        addStringToList(localReplace, replaceList);
        saveFindRepStrings(
                main.configValues.findStrings,
                findList,
                main.configValues.findRepStringsLength);
        saveFindRepStrings(
                main.configValues.replaceStrings,
                replaceList,
                main.configValues.findRepStringsLength);
    }

    private void saveFindRepStrings(String[] sa, JComboBox jc, int len) {
        int i;
        for (i = 0;
                i < len && i < jc.getItemCount(); i++) {
            String s = (String) jc.getItemAt(i);
            sa[i] = s;
        }
        for (; i < len; i++) {
            sa[i] = "";
        }
    }

    public void addStringToList(String s, JComboBox<String> jc) {
        // prevent infinite loop on list change
        if (!lockAccess) {
            lockAccess = true;
            if (s.length() > 0) {
                int loc = -1;
                int top = jc.getItemCount();
                for (int i = 0; i < top; i++) {
                    if (s.equals(jc.getItemAt(i).toString())) {
                        loc = i;
                        break;
                    }
                }
                if (loc >= 0) {
                    // move existing string to top of list
                    jc.removeItemAt(loc);
                }
                top = jc.getItemCount();
                if (top > 0) {
                    jc.insertItemAt(s, 0);
                } else {
                    jc.addItem(s);
                }
                // limit list size
                while (main.configValues.findRepStringsLength > 0 && jc.getItemCount() >= main.configValues.findRepStringsLength) {
                    jc.removeItemAt(jc.getItemCount() - 1);
                }
                // don't screw up original list selection
                jc.setSelectedItem(s);
            }
            lockAccess = false;
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        frTopPanel = new javax.swing.JPanel();
        findList = new javax.swing.JComboBox<String>();
        findFirstButton = new MyJButton();
        findNextButton = new MyJButton();
        replaceList = new javax.swing.JComboBox<String>();
        replaceButton = new MyJButton();
        moreButton = new MyJButton();
        frBottomPanel = new javax.swing.JPanel();
        search_controls_panel_panel = new javax.swing.JPanel();
        countButton = new MyJButton();
        replaceAllButton = new MyJButton();
        replaceGlobalButton = new MyJButton();
        instantModeCheckBox = new javax.swing.JCheckBox();
        caseSensCheckBox = new javax.swing.JCheckBox();
        clearButton = new MyJButton();
        cancelButton = new MyJButton();
        regex_panel = new javax.swing.JPanel();
        regExpCheckBox = new javax.swing.JCheckBox();
        multiLineCheckBox = new javax.swing.JCheckBox();
        dotMatchCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.BorderLayout());

        frTopPanel.setBackground(new java.awt.Color(153, 204, 255));
        frTopPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        frTopPanel.setLayout(new java.awt.GridBagLayout());

        findList.setEditable(true);
        findList.setToolTipText("Search text");
        findList.setRequestFocusEnabled(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        frTopPanel.add(findList, gridBagConstraints);

        findFirstButton.setText("First");
        findFirstButton.setToolTipText("<html>Find first match in selection<br/>(or document if no selection)</html>");
        findFirstButton.setRequestFocusEnabled(false);
        findFirstButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                findFirstButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        frTopPanel.add(findFirstButton, gridBagConstraints);

        findNextButton.setText("Next");
        findNextButton.setToolTipText("<html>Find next match in selection (F3)<br/>(or document if no selection)</html>");
        findNextButton.setRequestFocusEnabled(false);
        findNextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                findNextButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        frTopPanel.add(findNextButton, gridBagConstraints);

        replaceList.setEditable(true);
        replaceList.setToolTipText("Replacement text");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        frTopPanel.add(replaceList, gridBagConstraints);

        replaceButton.setText("Replace");
        replaceButton.setToolTipText("<html>Replace one case in selection<br/>(or document if no selection)</html>");
        replaceButton.setRequestFocusEnabled(false);
        replaceButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                replaceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        frTopPanel.add(replaceButton, gridBagConstraints);

        moreButton.setText("Exp");
        moreButton.setToolTipText("Expand this panel");
        moreButton.setRequestFocusEnabled(false);
        moreButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moreButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        frTopPanel.add(moreButton, gridBagConstraints);

        add(frTopPanel, java.awt.BorderLayout.CENTER);

        frBottomPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        frBottomPanel.setLayout(new java.awt.GridBagLayout());

        search_controls_panel_panel.setBackground(new java.awt.Color(204, 204, 255));
        search_controls_panel_panel.setLayout(new java.awt.GridBagLayout());

        countButton.setText("Count");
        countButton.setToolTipText("<html>Count cases of search string in selection<br/>(or document if no selection)</html>");
        countButton.setRequestFocusEnabled(false);
        countButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                countButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        search_controls_panel_panel.add(countButton, gridBagConstraints);

        replaceAllButton.setText("All");
        replaceAllButton.setToolTipText("<html>Replace all cases in selection<br/>(or document if no selection)</html>");
        replaceAllButton.setRequestFocusEnabled(false);
        replaceAllButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                replaceAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        search_controls_panel_panel.add(replaceAllButton, gridBagConstraints);

        replaceGlobalButton.setText("Global");
        replaceGlobalButton.setToolTipText("Replace all cases in all open documents");
        replaceGlobalButton.setRequestFocusEnabled(false);
        replaceGlobalButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                replaceGlobalButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        search_controls_panel_panel.add(replaceGlobalButton, gridBagConstraints);

        instantModeCheckBox.setText("Instant");
        instantModeCheckBox.setToolTipText("<html>Searches on each keystroke<br>(this can be risky when using regular expressions)</html>");
        instantModeCheckBox.setOpaque(false);
        instantModeCheckBox.setRequestFocusEnabled(false);
        instantModeCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                instantModeCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        search_controls_panel_panel.add(instantModeCheckBox, gridBagConstraints);

        caseSensCheckBox.setText("Case");
        caseSensCheckBox.setToolTipText("Make searches case-sensitive");
        caseSensCheckBox.setOpaque(false);
        caseSensCheckBox.setRequestFocusEnabled(false);
        caseSensCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                caseSensCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        search_controls_panel_panel.add(caseSensCheckBox, gridBagConstraints);

        clearButton.setText("Clear");
        clearButton.setToolTipText("Clear find/replace lists");
        clearButton.setRequestFocusEnabled(false);
        clearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        search_controls_panel_panel.add(clearButton, gridBagConstraints);

        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("<html>Cancel current operation<br>(only works for global searches)</html>");
        cancelButton.setRequestFocusEnabled(false);
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        search_controls_panel_panel.add(cancelButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        frBottomPanel.add(search_controls_panel_panel, gridBagConstraints);

        regex_panel.setBackground(new java.awt.Color(211, 242, 211));
        regex_panel.setLayout(new java.awt.GridBagLayout());

        regExpCheckBox.setText("RegExp");
        regExpCheckBox.setToolTipText("Allow regular expressions");
        regExpCheckBox.setOpaque(false);
        regExpCheckBox.setRequestFocusEnabled(false);
        regExpCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                regExpCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        regex_panel.add(regExpCheckBox, gridBagConstraints);

        multiLineCheckBox.setText("Multiline");
        multiLineCheckBox.setToolTipText("Treat files as groups of lines");
        multiLineCheckBox.setOpaque(false);
        multiLineCheckBox.setRequestFocusEnabled(false);
        multiLineCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                multiLineCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        regex_panel.add(multiLineCheckBox, gridBagConstraints);

        dotMatchCheckBox.setText("DotAll");
        dotMatchCheckBox.setToolTipText("Dot matches all characters");
        dotMatchCheckBox.setOpaque(false);
        dotMatchCheckBox.setRequestFocusEnabled(false);
        dotMatchCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dotMatchCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        regex_panel.add(dotMatchCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        frBottomPanel.add(regex_panel, gridBagConstraints);

        add(frBottomPanel, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
        // Add your handling code here:
        clearSearchReplaceLists();
    }//GEN-LAST:event_clearButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        doCancel();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void countButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_countButtonActionPerformed
        // Add your handling code here:
        doCount(true);
    }//GEN-LAST:event_countButtonActionPerformed

    private void dotMatchCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dotMatchCheckBoxActionPerformed
        // Add your handling code here:
        setDotNewline(((JCheckBox) evt.getSource()).getSelectedObjects() != null);
    }//GEN-LAST:event_dotMatchCheckBoxActionPerformed

    private void multiLineCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_multiLineCheckBoxActionPerformed
        // Add your handling code here:
        setMultiLineMode(((JCheckBox) evt.getSource()).getSelectedObjects() != null);
    }//GEN-LAST:event_multiLineCheckBoxActionPerformed

    private void instantModeCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_instantModeCheckBoxActionPerformed
        // Add your handling code here:
        setInstantMode(((JCheckBox) evt.getSource()).getSelectedObjects() != null);
    }//GEN-LAST:event_instantModeCheckBoxActionPerformed

    private void moreButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moreButtonActionPerformed
        // Add your handling code here:
        toggleMoreButton();
    }//GEN-LAST:event_moreButtonActionPerformed

    private void regExpCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_regExpCheckBoxActionPerformed
        // Add your handling code here:
        setRegExp(((JCheckBox) evt.getSource()).getSelectedObjects() != null);
    }//GEN-LAST:event_regExpCheckBoxActionPerformed

    private void caseSensCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_caseSensCheckBoxActionPerformed
        // Add your handling code here:
        setCaseSens(((JCheckBox) evt.getSource()).getSelectedObjects() != null);
    }//GEN-LAST:event_caseSensCheckBoxActionPerformed

    private void regExpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_regExpButtonActionPerformed
        // Add your handling code here:
        setRegExp(((JCheckBox) evt.getSource()).getSelectedObjects() != null);
    }//GEN-LAST:event_regExpButtonActionPerformed

    private void caseSensButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_caseSensButtonActionPerformed
        // Add your handling code here:
        setCaseSens(((JCheckBox) evt.getSource()).getSelectedObjects() != null);
    }//GEN-LAST:event_caseSensButtonActionPerformed

    private void replaceGlobalButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceGlobalButtonActionPerformed
        // Add your handling code here:
        doGlobalReplace();
    }//GEN-LAST:event_replaceGlobalButtonActionPerformed

    private void replaceAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceAllButtonActionPerformed
        // Add your handling code here:
        doAllReplace();
    }//GEN-LAST:event_replaceAllButtonActionPerformed

    private void replaceButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceButtonActionPerformed
        // Add your handling code here:
        doReplace(true);
    }//GEN-LAST:event_replaceButtonActionPerformed

    private void findNextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findNextButtonActionPerformed
        // Add your handling code here:
        doNextFind(true);
    }//GEN-LAST:event_findNextButtonActionPerformed

    private void findFirstButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findFirstButtonActionPerformed
        // Add your handling code here:
        doFirstFind(true, false);
    }//GEN-LAST:event_findFirstButtonActionPerformed

    private void handleReplaceRightClick(java.awt.event.MouseEvent evt, JComboBox b) {
        if (evt.isPopupTrigger()) {
            ArrayList<String> v = new ArrayList<String>();
            MacroTreePanel panel = main.getMacroPanel();
            if (panel != null) {
                v = panel.mjt.getMacroList();
            }
            v.addAll(main.comSwitchboard.getArrayListList());
            Point p = ((Component) evt.getSource()).getLocationOnScreen();
            int x = p.x + evt.getX();
            int y = p.y + evt.getY();
            MacroFloatingWindow mfw = new MacroFloatingWindow(v, new Point(x, y), this, b);
        }
    }

    public void clearSearchReplaceLists() {
        findList.removeAllItems();
        replaceList.removeAllItems();
        searcher.lockAccess = false;
        regExpWrapper.lockAccess = false;
    }

    private void doCancel() {
        regExpWrapper.cancelCurrentOperation = true;
        searcher.cancelCurrentOperation = true;
    }

    // this routine handles individual keystrokes
    public void processFindListKey(java.awt.event.KeyEvent evt) {
        String s = main.macroKeyHandler.createCode(evt);
        //System.out.println(s);
        // if this is a macro shortcut,
        // change focus to document
        if (main.macroKeyHandler.checkDefinition(s) != null) {
            if (main.currentSelectedDocument != null) {
                main.currentSelectedDocument.requestFocusInWindow();
            }
        }
        char c = evt.getKeyChar();
        if (c == KeyEvent.VK_ENTER) {
            doNextFind(true);
        } else if (main.configValues.instantSearch) {
            doFirstFind(false, true);
        }
    }

    private void toggleMoreButton() {
        showBottomPanel(!expandedPanel);
    }

    private void showBottomPanel(boolean v) {
        main.configValues.expandedSearch = v;
        expandedPanel = v;
        if (v) { // expand
            add(frBottomPanel, BorderLayout.SOUTH);
            moreButton.setText("Comp");
            moreButton.setToolTipText("Compress this panel");
        } else { // contract
            remove(frBottomPanel);
            moreButton.setText("Exp");
            moreButton.setToolTipText("Expand this panel");
        }
    }

    private void findListItemStateChanged(java.awt.event.ItemEvent evt) {
        // Add your handling code here:
        doFirstFind(false, false);

    }

    public void setDotNewline(boolean v) {
        main.configValues.dotMatchesNewline = v;
        setupCheckBoxes();
    }

    public void setMultiLineMode(boolean v) {
        main.configValues.multiLineSearch = v;
        setupCheckBoxes();
    }

    public void setCaseSens(boolean v) {
        main.configValues.caseSensitiveTextSearch = v;
        setupCheckBoxes();
    }

    public void setInstantMode(boolean v) {
        main.configValues.instantSearch = v;
        setupCheckBoxes();
    }

    public void setRegExp(boolean v) {
        main.configValues.regExpTextSearch = v;
        if (v) {
            setInstantMode(false);
            if (main.configValues.showRegexpWarning) {
                String s = "Regular Expressions are very powerful, but some seemingly innocent entries can use up all a processor's capacity and thus cause a program to lock up. It is best to practice regular expressions after saving all unsaved work, when there is little prospect of losing work if the RegExp routine should decide to take over your computer's entire, relatively small, brain.";
                InfoDialog warn = new InfoDialog(main, true, "RegExp Launch Warning", s);
                main.configValues.showRegexpWarning = !warn.dontShowAgain;
            }
        }
        setupCheckBoxes();
    }

    public void warnNoSearch() {
        main.beep();
        JOptionPane.showMessageDialog(main, "Please enter a search string.", "Search/Replace", JOptionPane.OK_OPTION);
    }

    private void doGlobalReplace() {
        showBottomPanel(true);
        search = getFindString();
        if (search.length() == 0) {
            warnNoSearch();
        } else {
            String procSearch = main.comSwitchboard.exec(search, 0);
            unescSearch = EscapeUnescapeStringHandler.unescapeString(procSearch);
            addStringToList(search, findList);
            replace = getReplaceString();
            String procReplace = main.comSwitchboard.exec(replace, 0);
            unescReplace = EscapeUnescapeStringHandler.unescapeString(procReplace);
            addStringToList(replace, replaceList);
            if (main.configValues.regExpTextSearch) {
                regExpWrapper.replaceGlobalThread(procSearch, unescSearch, procReplace, unescReplace, getFlags());
            } else {
                searcher.replaceGlobalThread(procSearch, unescSearch, procReplace, unescReplace);
            }
        }
    }

    public void doAllReplace() {
        showBottomPanel(true);
        regExpWrapper.replaced = false;
        search = getFindString();
        if (search.length() == 0) {
            warnNoSearch();
        } else {
            String procSearch = main.comSwitchboard.exec(search, 0);
            unescSearch = EscapeUnescapeStringHandler.unescapeString(procSearch);
            addStringToList(search, findList);
            replace = getReplaceString();
            String procReplace = main.comSwitchboard.exec(replace, 0);
            unescReplace = EscapeUnescapeStringHandler.unescapeString(procReplace);
            addStringToList(replace, replaceList);
            //main.currentSelectedDocument.undoPush();
            if (main.configValues.regExpTextSearch) {
                regExpWrapper.replaceAllThread(main.currentSelectedDocument, procSearch, unescReplace, getFlags());
            } else {
                searcher.replaceAllThread(main.currentSelectedDocument, unescSearch, unescReplace);
            }
        }
    }

    public int getFlags() {
        int f = 0;
        if (!main.configValues.caseSensitiveTextSearch) {
            f |= Pattern.CASE_INSENSITIVE;
        }
        if (main.configValues.multiLineSearch) {
            f |= Pattern.MULTILINE;
        }
        if (main.configValues.dotMatchesNewline) {
            f |= Pattern.DOTALL;
        }
        return f;
    }

    public void doCount(boolean addToList) {
        if (main.currentSelectedDocument != null) {
            search = getFindString();
            if (search.length() == 0) {
                warnNoSearch();
            } else {
                String procSearch = main.comSwitchboard.exec(search, 0);
                unescSearch = EscapeUnescapeStringHandler.unescapeString(procSearch);
                if (addToList) {
                    addStringToList(search, findList);
                }
                if (main.configValues.regExpTextSearch) {
                    regExpWrapper.countOccurrences(main.currentSelectedDocument, procSearch, getFlags());
                } else {
                    searcher.countOccurrences(main.currentSelectedDocument, unescSearch);
                }
            }
        }
    }

    public void doFirstFind(boolean addToList, boolean instant) {
        search = getFindString();
        if (search.length() == 0) {
            if (!instant) {
                warnNoSearch();
            } else {
                main.beep();
            }
        } else {
            String procSearch = main.comSwitchboard.exec(search, 0);
            unescSearch = EscapeUnescapeStringHandler.unescapeString(procSearch);
            if (addToList) {
                addStringToList(search, findList);
            }
            if (main.configValues.regExpTextSearch) {
                doFirstFindRegExp(procSearch);
            } else {
                doFirstFindPlain(unescSearch);
            }
        }
    }

    public void doNextFind(boolean addToList) {
        search = getFindString();
        if (search.length() == 0) {
            warnNoSearch();
        } else {
            String procSearch = main.comSwitchboard.exec(search, 0);
            unescSearch = EscapeUnescapeStringHandler.unescapeString(procSearch);
            if (addToList) {
                addStringToList(search, findList);
            }
            if (main.configValues.regExpTextSearch) {
                doNextFindRegExp(procSearch);
            } else {
                doNextFindPlain(unescSearch);
            }
        }
    }

    public void doReplace(boolean addToList) {
        if (main.currentSelectedDocument != null) {
            search = getFindString();
            if (search.length() == 0) {
                warnNoSearch();
            } else {
                String procSearch = main.comSwitchboard.exec(search, 0);
                unescSearch = EscapeUnescapeStringHandler.unescapeString(procSearch);
                if (addToList) {
                    addStringToList(search, findList);
                }
                replace = getReplaceString();
                String procReplace = main.comSwitchboard.exec(replace, 0);
                unescReplace = EscapeUnescapeStringHandler.unescapeString(procReplace);
                if (addToList) {
                    addStringToList(replace, replaceList);
                }
                //main.currentSelectedDocument.undoPush();
                if (main.configValues.regExpTextSearch) {
                    doRegExpReplace(procSearch, unescReplace);
                } else {
                    doPlainReplace(unescSearch, unescReplace);
                }
            }
        }
    }

    // this can be triggered by list change
    // so there is a guard against an infinite loop
    // of list mods and consequent actions
    public void doFirstFindPlain(String search) {
        if (searcher != null && main.currentSelectedDocument != null && !searcher.lockAccess) {
            searcher.findFirst(main.currentSelectedDocument, search);
        }
    }

    public void doNextFindPlain(String search) {
        if (searcher != null && main.currentSelectedDocument != null && !searcher.lockAccess) {
            searcher.findNext(main.currentSelectedDocument, search);
        }
    }

    public void doFirstFindRegExp(String search) {
        if (regExpWrapper != null && main.currentSelectedDocument != null && !regExpWrapper.lockAccess) {
            regExpWrapper.findFirst(main.currentSelectedDocument, search, getFlags());
        }
    }

    public void doNextFindRegExp(String search) {
        if (regExpWrapper != null && main.currentSelectedDocument != null && !regExpWrapper.lockAccess) {
            regExpWrapper.findNext(main.currentSelectedDocument, search, getFlags());
        }
    }

    public void doPlainReplace(String search, String replace) {
        if (searcher != null && main.currentSelectedDocument != null && !searcher.lockAccess) {
            searcher.replaceText(search, replace);
        }
    }

    public void doRegExpReplace(String search, String replace) {
        if (regExpWrapper != null && main.currentSelectedDocument != null && !regExpWrapper.lockAccess) {
            regExpWrapper.replaceText(search, replace, getFlags());
        }
    }

    public String getFindString() {
        return findList.getEditor().getItem().toString();
    }

    public String getReplaceString() {
        return replaceList.getEditor().getItem().toString();
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox caseSensCheckBox;
    private javax.swing.JButton clearButton;
    private javax.swing.JButton countButton;
    private javax.swing.JCheckBox dotMatchCheckBox;
    private javax.swing.JButton findFirstButton;
    public javax.swing.JComboBox<String> findList;
    private javax.swing.JButton findNextButton;
    private javax.swing.JPanel frBottomPanel;
    private javax.swing.JPanel frTopPanel;
    private javax.swing.JCheckBox instantModeCheckBox;
    private javax.swing.JButton moreButton;
    private javax.swing.JCheckBox multiLineCheckBox;
    private javax.swing.JCheckBox regExpCheckBox;
    private javax.swing.JPanel regex_panel;
    private javax.swing.JButton replaceAllButton;
    private javax.swing.JButton replaceButton;
    private javax.swing.JButton replaceGlobalButton;
    public javax.swing.JComboBox<String> replaceList;
    private javax.swing.JPanel search_controls_panel_panel;
    // End of variables declaration//GEN-END:variables
}
