// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * SearchReplace.java
 *
 * Created on February 11, 2002, 12:52 PM
 */

import javax.swing.*;

/**
 *
 * @author  Administrator
 * @version 
 */
final public class SearchReplace {

    public int findCount = 0;
    
    public String srchRplc(String data,String srch, String rplc)
    {
        return srchRplc(data,srch,rplc,true);
    }
    
    public String srchRplc(int pos,String data,String srch, String rplc)
    {
        return srchRplc(pos,data,srch,rplc,true);
    }
    
    public String srchRplc(String data,String srch, String rplc,boolean caseSens) {
        return srchRplc(0,data,srch, rplc,caseSens);
    }
    
    // this is slower than the equivalent
    // case-sensitive search
    public int findText(String data, String search,int pos,boolean caseSens) {
        int top = data.length();
        int len = search.length();
        top -= len-1;
        int findex = -1;
        if(caseSens) {
            for(int i = pos;i < top;i++) {
                if(data.substring(i,i+len).equals(search)) {
                    findex = i;
                    break;
                }
            }
        }
        else {
            for(int i = pos;i < top;i++) {
                if(data.substring(i,i+len).equalsIgnoreCase(search)) {
                    findex = i;
                    break;
                }
            }
        }
        return findex;
    }
   
    
    public String srchRplc(int start,String data,String srch, String rplc,boolean caseSens) {
        if(!srch.equals(rplc) && srch.length() > 0) {
            StringBuilder dest = new StringBuilder();
            char[] src = data.toCharArray();
            int len = src.length;
            if(start > 0) {
                dest.append(src,0,start);
            }
            int i;
            int sl = srch.length();
            //if(progressBar != null) {
            //    startProgressBar(progressBar,"Replacing text ...",0,len,0);
            //}
            if(caseSens) {
                while((i = data.indexOf(srch,start)) != -1) {
                    //if(progressBar != null) {
                    //    updateProgressBar(progressBar,i);
                    //}
                    dest.append(src, start,i-start);
                    dest.append(rplc);
                    start = i + sl;
                    findCount++;
                }
            }
            else { // not case senstitive
                while((i = findText(data,srch,start,false)) != -1) {
                    //if(progressBar != null) {
                    //    updateProgressBar(progressBar,i);
                    //}
                    dest.append(src, start,i-start);
                    dest.append(rplc);
                    start = i + sl;
                    findCount++;
                }
            }
            if(start < data.length()) {
                dest.append(src,start,data.length()-start);
            }
            //if(progressBar != null) {
            //    stopProgressBar(progressBar);
            //}
            return dest.toString();
        }
        else { // srch == rplc
            return data;
        }
    }
    
    public int countOccurrences(int start,String data,String srch,boolean caseSens) {
        int count = 0;
        if(srch.length() > 0) {
            //StringBuilder dest = new StringBuilder();
            //char[] src = data.toCharArray();
            //int count = 0;
            int len = data.length();
            //if(start > 0) {
            //    dest.append(src,0,start);
            //}
            int i;
            int sl = srch.length();
            //if(progressBar != null) {
            //    startProgressBar(progressBar,"Replacing text ...",0,len,0);
            //}
            if(caseSens) {
                while((i = data.indexOf(srch,start)) != -1) {
                    //if(progressBar != null) {
                    //    updateProgressBar(progressBar,i);
                    //}
                    //count++;
                    //dest.append(src, start,i-start);
                    //dest.append(rplc);
                    start = i + sl;
                    count++;
                }
            }
            else { // not case senstitive
                while((i = findText(data,srch,start,false)) != -1) {
                    //if(progressBar != null) {
                    //    updateProgressBar(progressBar,i);
                    //}
                    //dest.append(src, start,i-start);
                    //dest.append(rplc);
                    start = i + sl;
                    count++;
                }
            }
            //if(start < data.length()) {
            //    dest.append(src,start,data.length()-start);
            //}
            //if(progressBar != null) {
            //    stopProgressBar(progressBar);
            //}
            //return dest.toString();
        }
        //else { // srch == rplc
        //    return data;
        //}
        return count;
    }
    
    private void startProgressBar(JProgressBar progressBar,String  prompt, int low, int high,int v) {
        //updateStatusBar(prompt);
        //progressBar.setStringPainted(true);
        progressBar.setMinimum(low);
        progressBar.setMaximum(high);
        progressBar.setValue(v);
    }
    
    private void updateProgressBar(JProgressBar progressBar,int v) {
        progressBar.setValue(v);
    }
    
    private void stopProgressBar(JProgressBar progressBar) {
        progressBar.setValue(progressBar.getMinimum());
        //progressBar.setStringPainted(false);
        //updateStatusBar(defaultStatusMessage);
    }
}
