// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * RegExpWrapperClass.java
 *
 * Created on February 11, 2002, 3:25 PM
 */
import java.util.regex.*;
import javax.swing.*;
import javax.swing.text.*;

/**
 *
 * @author Administrator
 * @version
 */
final public class RegExpWrapperClass {

    Arachnophilia main;
    ArachDocument doc;
    DocContentHandler docHandler;
    Pattern pattern;
    int pos = -1, findPos = -1, selStart, selEnd;
    int findCount;
    int fileCount;
    boolean found = false;
    boolean lockAccess = false;
    public boolean cancelCurrentOperation = false;
    boolean replaced = false;

    /**
     * Creates new RegExpWrapperClass
     */
    public RegExpWrapperClass(Arachnophilia m) {
        main = m;
        docHandler = new DocContentHandler(main);
    }

    private String smartModifier(int count) {
        return (count == 1) ? "" : "s";
    }

    public void countOccurrences(ArachDocument d, String search, int regExpFlags) {
        Matcher m;
        Pattern localPattern = null;
        String content = d.textComp.getText();
        if (content != null) {
            try {
                localPattern = Pattern.compile(search, regExpFlags);
            } catch (PatternSyntaxException ex) {
                ex.printStackTrace(System.out);
                localPattern = null;
                pos = 0;
                //System.out.println("my error printer: " + ex);
            }
        }
        if (localPattern != null) {
            //d.undoPush();
            int n = 0;
            m = localPattern.matcher(content);
            while (m.find()) {
                n++;
            }
            main.showSearchResults("Found " + n + " case" + smartModifier(n) + ".");
        }
    }

    public void replaceAllThread(final ArachDocument d, final String search, final String replace, final int regExpFlags) {
        if (!lockAccess) {
            lockAccess = true;
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    replaceAll(d, search, replace, regExpFlags);
                }
            });
        } else {
            System.out.println("regex replaceAllThread beep -> lockaccess: " + lockAccess);
            main.beep();
        }
    }

    private void replaceAll(ArachDocument d, String search, String replace, int regExpFlags) {
        replaced = false;
        replaceAll2(d, search, replace, regExpFlags);
        main.showSearchResults((replaced) ? "Pattern not found." : "Replaced all cases.");
        lockAccess = false;
    }

    private void replaceAll2(ArachDocument doc, String search, String replace, int regExpFlags) {
        //System.out.println(doc + "," + search + "," + replace);
        if (doc != null) {
            Matcher m;
            Pattern localPattern = null;
            int localSelStart;
            int localSelEnd;
            int origLen = 0;
            int newLen;
            boolean selectionValid;
            int p = doc.textComp.getCaretPosition();
            localSelStart = doc.textComp.getSelectionStart();
            localSelEnd = doc.textComp.getSelectionEnd();
            selectionValid = (localSelStart != localSelEnd);
            String text;
            if (selectionValid) {
                text = doc.textComp.getSelectedText();
                origLen = text.length();
            } else {
                text = doc.textComp.getText();
            }
            if (text != null) {
                try {
                    localPattern = Pattern.compile(search, regExpFlags);
                } catch (PatternSyntaxException ex) {
                    pos = 0;
                    localPattern = null;
                    ex.printStackTrace(System.out);
                    //System.out.println("my error printer: " + ex);
                }
            }
            if (localPattern != null) {
                doc.undoPush();
                m = localPattern.matcher(text);
                if (m.find()) {
                    try {
                        text = m.replaceAll(replace);
                        replaced |= true;
                        if (selectionValid) {
                            doc.textComp.replaceSelection(text);
                            newLen = text.length();
                            doc.textComp.setSelectionStart(localSelStart);
                            doc.textComp.setSelectionEnd(localSelEnd + newLen - origLen);
                        } else {
                            doc.textComp.setText(text);
                            if (p < doc.textComp.getDocument().getLength()) {
                                doc.textComp.setCaretPosition(p);
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                Caret car = doc.textComp.getCaret();
                if (car != null) {
                    car.setSelectionVisible(true);
                }
            }
        }
    }

    public void replaceGlobalThread(String search, final String unescSearch, String replace, final String unescReplace, final int regExpFlags) {
        if (!lockAccess) {
            int r = JOptionPane.showConfirmDialog(main, "This operation will replace ALL cases of \n"
                    + "\"" + search + "\" with\n"
                    + "\"" + replace + "\"\n"
                    + "in ALL open documents.\n"
                    + "Okay to proceed?", "Global RegExp Replace All", JOptionPane.YES_NO_OPTION);

            if (r == JOptionPane.YES_OPTION) {
                lockAccess = true;
                SwingUtilities.invokeLater(new Runnable() {
                    @Override
                    public void run() {
                        replaceGlobal(unescSearch, unescReplace, regExpFlags);
                    }
                });
            }
        } else {
            main.beep();
        }
    }

    private void replaceGlobal(String search, String replace, int regExpFlags) {
        cancelCurrentOperation = false;
        replaced = false;
        fileCount = 0;
        findCount = 0;
        ArachDocument[] array = main.fileHandler.docArray();
        for (int i = 0; i < array.length && !cancelCurrentOperation; i++) {
            // force no selection for this option
            ArachDocument locDoc = array[i];
            //System.out.println("regexp: " + doc);
            locDoc.textComp.setSelectionEnd(locDoc.textComp.getSelectionStart());
            replaceAll2(locDoc, search, replace, regExpFlags);
            fileCount++;
        }
        String result = (replaced) ? "Replaced all cases in " + fileCount + " file" + smartModifier(fileCount) + "." : "Pattern Not found/malformed.";
        main.showSearchResults(result);
        cancelCurrentOperation = false;
        lockAccess = false;
    }

    public void findFirst(ArachDocument d, String search, int regExpFlags) {
        if (d != null) {
            d.textComp.setCaretPosition(0);
            findNext(d, search, regExpFlags);
        }
    }

    public void findNext(ArachDocument d, String search, int regExpFlags) {
        if (d != null) {
            if (search.length() > 0) {
                doc = d;
                pos = d.textComp.getCaretPosition();
                findText2(search, regExpFlags);
            } else {
                main.beep();
            }
        } else {
            main.beep();
        }
    }

    public void findText2(String search, int regExpFlags) {
        found = false;
        //System.out.println("findText2 " + pos);
        if (main.currentSelectedDocument == doc && doc != null) {

            Matcher m = searchText(search, pos, regExpFlags, doc.textComp);
            if (m != null) {
                found = true;
                findPos = m.start();
                selStart = findPos;
                selEnd = m.end();
                doc.centerCaret = true;
                doc.textComp.select(selStart, selEnd);
                Caret car = doc.textComp.getCaret();
                if (car != null) {
                    car.setSelectionVisible(true);
                }
                pos = selEnd;
                main.showSearchResults("Found 1 case.");

            } else {
                pos = 0;
                doc.textComp.setCaretPosition(0);
                main.beep();
                main.showSearchResults("Not found.");
            }
            //System.out.println("pos: " + pos);
        } else {
            main.beep();
        }
    }

    private Matcher searchText(String search, int pos, int regExpFlags, MySyntaxTextArea dd) {
        //int top = dd.getLength();
        //int len = search.length();
        //top -= len;
        //int findex = -1;
        Matcher m;
        pattern = null;
        String content = dd.getText();
        if (content != null) {
            try {
                pattern = Pattern.compile(search, regExpFlags);
            } catch (PatternSyntaxException ex) {
                pos = 0;
                ex.printStackTrace(System.out);
                pattern = null;
                //System.out.println("my error printer: " + ex);
            }
        }
        if (pattern != null) {
            m = pattern.matcher(content);
            if (!m.find(pos)) {
                m = null;
            }
            return m;
        }
        return null;
    }

    public void replaceText(String search, String replace, int regExpFlags) {
        replaced = false;
        if (!found || main.currentSelectedDocument != doc || doc == null) {
            main.showSearchResults("Searching.");
            findNext(main.currentSelectedDocument, search, regExpFlags);
        } else {
            //doc.undoPush();
            //doc.textComp.setSelectionEnd(selStart);
            String content = docHandler.getContent();
            int origLen = content.length();
            try {
                pattern = Pattern.compile(search, regExpFlags);
            } catch (PatternSyntaxException ex) {
                pattern = null;
                ex.printStackTrace(System.out);
            }
            if (pattern != null) {
                Matcher m = pattern.matcher(content);
                if (m.find()) {
                    try {
                        content = m.replaceFirst(replace);
                        replaced = true;
                        int finalLen = content.length();
                        docHandler.setContent(content);
                        int delta = finalLen - origLen;
                        pos += delta;
                        doc.textComp.setCaretPosition(selStart);
                        doc.textComp.moveCaretPosition(pos);
                    } catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            found = false;
            main.showSearchResults((replaced) ? "Replaced 1 case." : "Pattern not found/malformed.");
        }
    }
}
