// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;



/*
 * RecentFileList.java
 *
 * Created on October 19, 2001, 10:22 PM
 */


import java.io.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class RecentFileList {
    
    public ArrayList<String> list;
    private int max;
    private int insertPoint;
    private Arachnophilia main;
    JComponent targetMenu;
    
    public RecentFileList(Arachnophilia m,int max,JComponent menu) {
        list = new ArrayList<String>();
        main = m;
        this.max = max;
        setTarget(menu);
    }
    
    public void setTarget(JComponent menu) {
        targetMenu = menu;
        if(menu != null) {
            insertPoint = getCount(menu);
        }
        clearMenu();
        rebuildMenu();
    }
    
    private int getCount(JComponent menu) {
        if(menu instanceof JPopupMenu) {
            return ((JPopupMenu)menu).getComponentCount();
        }
        else {
            return ((JMenu)menu).getItemCount();
        }
    }
    
    public void clearList() {
        clearMenu();
        list.clear();
    }
    
    public void clearMenu() {
        if(targetMenu != null) {
            while(getCount(targetMenu)-insertPoint > 0) {
                targetMenu.remove(insertPoint);
            }
        }
    }
    public void put(String fullName) {
        clearMenu();
        deleteExisting(fullName);
        if(list.size() > 0) {
            list.add(0,fullName);
        }
        else {
            list.add(fullName);
        }
        while(list.size() > max) {
            list.remove(list.size()-1);
        }
        rebuildMenu();
    }
    
    private void verifyList()
    {
        for(int i = 0;i < list.size();i++) {
            if(!fileExists(list.get(i))) {
                list.remove(i);
            }
        }
    }
    
    private boolean fileExists(String s)
    {
        return new File(s).exists();
    }
    
    private void rebuildMenu() {
        if(targetMenu != null) {
            verifyList();
            for(int i = 0; i < list.size();i++) {
                String fullName = list.get(i);
                String shortName = fullName;
                int p = fullName.lastIndexOf(ArachConstants.SYSTEM_FILESEP);
                if(p != -1 && p < fullName.length() - 1) {
                    shortName = fullName.substring(p+1);
                }
                //System.out.println(sd);
                if(fullName.length() > 0) {
                    int count = getCount(targetMenu);
                    //System.out.println(targetMenu + " count: " + count);
                    if(i < count-insertPoint) {
                        JMenuItem jm = (JMenuItem)targetMenu.getComponent(i+insertPoint);
                        jm.setText(shortName);
                        if(!fullName.equals(shortName)) {
                            jm.setToolTipText(fullName);
                        }
                    }
                    else {
                        //System.out.println("new: " + sd.fullName + "," + time);
                        JMenuItem mi = new JMenuItem(shortName);
                        if(!fullName.equals(shortName)) {
                            mi.setToolTipText(fullName);
                        }
                        targetMenu.add(mi);
                        addListener(mi);
                    }
                }
            }
        }
    }
    
    private void deleteExisting(String s) {
        for(int i = 0;i < list.size();i++) {
            if(s.equals(list.get(i))) {
                list.remove(i);
                break;
            }
        }
    }
    
    public void putAll(String array[]) {
        clearList();
        for(int i = 0;i < array.length;i++) {
            if(array[i].length() > 0 && fileExists(array[i])) {
                list.add(array[i]);
                if(targetMenu != null) {
                    JMenuItem mi = new JMenuItem(array[i]);
                    targetMenu.add(mi);
                    addListener(mi);
                }
            }
        }
    }
    
    public String[] getAll() {
        return list.toArray(new String[list.size()]);
    }
    
    private void addListener(JMenuItem mi) {
        mi.addActionListener(
        new java.awt.event.ActionListener() {
            @Override
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuActionPerformed(evt);
            }
        }
        );
    }
    
    private void menuActionPerformed(java.awt.event.ActionEvent evt) {
        JMenuItem jm = (JMenuItem)evt.getSource();
        String sd = jm.getToolTipText();
        File f = new File(sd);
        if(!f.exists()) {
            main.beep();
            deleteExisting(sd);
            clearMenu();
            rebuildMenu();
        }
        else {
            main.openDoc(f,true,true);
        }
    }
}
