// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * MyJTextArea.java
 *
 * Created on March 4, 2002, 2:10 PM
 */

import java.awt.*;
import javax.swing.*;


/**
 *
 * @author  Administrator
 * @version
 */

// this class handles an issue having to do with line endings
// and text copying and pasting

public class MyJTextArea extends JTextArea {
    
    //public Arachnophilia main;
    Arachnophilia main;
    
    public MyJTextArea(Arachnophilia m)
    {
        super();
        main = m;
    }
    
    public MyJTextArea(Arachnophilia m,String s)
    {
        super(s);
        main = m;
    }
        
    @Override
    public void paint(Graphics g)
    {
       Graphics2D g2 = (Graphics2D) g;
        g2.addRenderingHints( main.renderHints );
        super.paint(g2);
    }
    
    /**
     * Deletes the selected text from the text area and places it
     * into the clipboard.
     */
    @Override
    public void cut() {
        copy();
        replaceSelection("");
    }
    
    /**
     * Places the selected text into the clipboard.
     */
    @Override
    public void copy() {
        if(getSelectionStart() != getSelectionEnd()) {
            String selection = getSelectedText();
            ClipboardSender clipboardSender = new ClipboardSender(selection);
        }
    }
    @Override
    public void paste() {
       ClipboardReceiver cr = new ClipboardReceiver();
            String selection = cr.getData();
            replaceSelection(selection);
    }
      
}
