// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * MyPopupMenu.java
 *
 * Created on March 16, 2002, 7:00 PM
 */

package Arachnophilia;

import java.awt.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 * @version 
 */

// this class just prevents the popup
// from disappearing to the right and down on the screen
// if launched near the edge

public class MyJPopupMenu extends JPopupMenu {
    
    @Override
    public void show(Component origin, int x, int y)
    {
        super.show(origin,x,y);
        Dimension md = getSize();
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point(x,y);
        SwingUtilities.convertPointToScreen(p,origin);
        int dx = ss.width - (p.x + md.width);
        int dy = ss.height - (p.y + md.height);
        //System.out.println(dx + "," + dy);
        boolean redraw = false;
        if(dx < 0) {
            x += dx;
            redraw = true;
        }
        if(dy < 0) {
            y += dy;
            redraw = true;
        }
        if(redraw) {
            super.show(origin,x,y);
        }
    }
}
