// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * LiTagResolver.java
 *
 * Created on November 5, 2006, 8:45 PM
 */

package Arachnophilia;

import java.util.*;
import java.util.regex.*;
/**
 *
 * @author  Administrator
 */
final public class LiTagResolver {
    
    // all static methods, so ...
    private LiTagResolver() {
    }
    
    static String lineEnding;
    
    static String targetTag = "</li>";
    static Pattern sourceTagPat = Pattern.compile("<li\\b");
    static Pattern allGroups = Pattern.compile("</?(li|ol|ul)\\b");
    static Pattern openGroup = Pattern.compile("<(ul|ol)\\b");
    static Pattern closeGroup = Pattern.compile("</(ul|ol)\\b");
    
    static int regexFind(String data,Pattern pat,int a) {
        Matcher m = pat.matcher(data);
        if(m.find(a)) {
            return m.start();
        }
        return -1;
    }
    
    static int findClosingLi(String data,int i) {
        int depth = 0;
        do {
            i++;
            i = regexFind(data,allGroups,i);
            if(i >= 0) {
                if (regexFind(data,openGroup,i) == i) {
                    depth++;
                }
                if(depth == 0) {
                    if (regexFind(data,allGroups,i) == i) {
                        return i;
                    }
                }
                if (regexFind(data,closeGroup,i) == i) {
                    depth--;
                }
            }
        }
        while (i >= 0);
        return i;
    }
    
    // this routine chops up the page while inserting the tags,
    // so it is best followed by HTML Beautify
    
    static public String resolve(String data) {
        Stack<Integer> stack = new Stack<Integer>();
        // remove all existing </li> tags
        data = data.replaceAll("</li>","");
        int a = 0;
        int b;
        do {
            a = regexFind(data,sourceTagPat,a);
            if(a >= 0) {
                b = findClosingLi(data,a);
                if(b >= 0) {
                    // save this position for later </li> tag insertion
                    stack.push(new Integer(b));
                }
            }
            if(a >= 0) {
                a++;
            }
        }
        while(a != -1);
        // sort the list of positions
        Collections.sort(stack);
        StringBuilder sb = new StringBuilder(data);
        // must insert from highest to lowest position
        String ttag = targetTag + "\n";
        while(!stack.empty()) {
            int n = ((Integer)stack.pop()).intValue();
            sb.insert(n,ttag);
        }
        return sb.toString();
    }
}
