// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * JumpToOppositeTag.java
 *
 * Created on November 6, 2006, 10:23 AM
 */

package Arachnophilia;

/**
 *
 * @author  Administrator
 */
final public class JumpToOppositeTag {
    
    
    /** Creates a new instance of JumpToOppositeTag */
    private JumpToOppositeTag() {
    }
    
    static int nextTagPos(String data,int i) {
        if (i < 0 || i >= data.length()) {
            return -1;
        }
        return data.indexOf("<",i);
    }
    
    static int priorTagPos(String data,int i) {
        if (i < 0 || i >= data.length()) {
            return -1;
        }
        return data.lastIndexOf("<",i);
    }
    
    // -1 = end tag, 0 = self-closing, 1 = start tag
    
    static int tagType(String data, int i) {
        if(data.length() > i+1) {
            char c = data.charAt(i+1);
            if(c == '/') {
                return -1; // ending tag
            }
            int j = data.indexOf(">",i);
            if(j > 0) {
                if(data.charAt(j-1) == '/') {
                    return 0; // self-closing tag
                }
                if (Character.isLetter(c)) {
                    return 1; // start tag
                }
            }
        }
        return 0; // self-closing or oddball
    }
    
    static void scanForward(ArachDocument doc,MySyntaxTextArea ti,int top,String ls,int line,int pos) {
        int depth = 1;
        while(depth != 0) {
            pos = nextTagPos(ls,++pos);
            if(pos == -1) {
                line++;
                if(line >= top) {
                    return;
                }
                ls = ti.getLineText(line);
                pos = -1;
            }
            else { // valid tag
                int t = tagType(ls,pos);
                if(t == -2) {
                    return;
                }
                else {
                    depth += t;
                }
            }
        }
        doc.gotoLine(line);
        int offset = ti.getLineStartOffset(line);
        ti.setCaretPosition(offset+pos);
    }
    
    static void scanBackward(ArachDocument doc,MySyntaxTextArea ti,int top,String ls,int line,int pos) {
        int depth = -1;
        while(depth != 0) {
            pos = priorTagPos(ls,--pos);
            if(pos == -1) {
                line--;
                if(line < 0) {
                    return;
                }
                ls = ti.getLineText(line);
                pos = ls.length();
            }
            else { // valid tag
                int t = tagType(ls,pos);
                if(t == -2) {
                    return;
                }
                else {
                    depth += t;
                }
            }
        }
        doc.gotoLine(line);
        int offset = ti.getLineStartOffset(line);
        ti.setCaretPosition(offset+pos);
    }
    
    static public void jump(ArachDocument doc) {
        MySyntaxTextArea ti = doc.textComp;
        int top = ti.getLineCount();
        int line = ti.getCaretLine();
        int pos = ti.getCaretPosition() - ti.getLineStartOffset(line);
        String ls = ti.getLineText(line);
        if(pos >= ls.length() && ls.length() > 0) {
            pos--;
        }
        // look to the right first
        int i = nextTagPos(ls,pos);
        // if that fails, look left
        if(i == -1) {
            i = priorTagPos(ls,pos);
        }
        if(i == -1) {
            return;
        }
        pos = i;
        int t = tagType(ls,pos);
        switch(t) {
            // if error or self-closing tag
            case -2:
            case 0:
                return;
            case 1: // start tag
                scanForward(doc,ti,top,ls,line,pos);
                break;
            case -1: // end tag
                scanBackward(doc,ti,top,ls,line,pos);
                break;
        }
    }
}
