// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * FontChooser.java
 *
 * Created on December 4, 2001, 9:47 AM
 */
import java.awt.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 */
public final class FontChooser extends javax.swing.JDialog {

    public Font currentFont;
    String[] fontNames;
    int fontPoints;
    int fontStyle;
    String fontName;
    String sampleText = "Hello здравствулте こんにちは";
    String[] styleNames = {"Plain", "Bold", "Italic", "Bold/Italic"};
    int[] styleConstants = {Font.PLAIN, Font.BOLD, Font.ITALIC, Font.BOLD | Font.ITALIC};
    String[] pointSizes;
    int smallest = 5;
    int largest = 128;
    boolean needInit = true;
    boolean okResult = false;

    /** Creates new form FontChooser */
    public FontChooser(java.awt.Frame parent, boolean modal, Font font, String title) {
        super(parent, modal);
        setTitle(title);
        currentFont = font;
        if (currentFont == null || currentFont.getName().equals( "null")) {
            System.out.println("font is null");
            currentFont = new Font("Monospaced", Font.PLAIN, 12);
        }
        fontPoints = currentFont.getSize();
        fontStyle = currentFont.getStyle();
        fontName = currentFont.getName();
        //System.out.println(fontName);
        setupLists();
        initComponents();
        fontList.setListData(fontNames);
        setIndices();
        setSize(500, 400);
    }

    public boolean showDialog() {
        setVisible(true);
        showCurrent();
        return okResult;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (needInit) {
            needInit = false;
            fontList.ensureIndexIsVisible(fontList.getSelectedIndex());
        }
    }

    private void setupLists() {
        fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        pointSizes = new String[largest - smallest];
        for (int i = smallest; i < 128; i++) {
            pointSizes[i - smallest] = "" + i;
        }
    }

    private void setIndices() {
        int sel = fontPoints - smallest;
        sel = (sel < 0) ? 0 : sel;
        sel = (sel > largest - smallest) ? largest - smallest : sel;
        pointBox.setSelectedIndex(sel);
        //System.out.println(fontStyle);
        int style = 0;
        for (int i = 0; i < styleConstants.length; i++) {
            if (fontStyle == styleConstants[i]) {
                style = i;
                break;
            }
        }
        //System.out.println(fontName);
        styleBox.setSelectedIndex(style);
        fontList.setSelectedValue(fontName, true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        topPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        styleBox = new JComboBox<String>(styleNames);
        jLabel2 = new javax.swing.JLabel();
        pointBox = new JComboBox<String>(pointSizes);
        scrollPane = new javax.swing.JScrollPane();
        fontList = new JList<String>();
        bottomPanel = new javax.swing.JPanel();
        samplePanel = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        textSample = new javax.swing.JTextField();
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        defaultButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setMinimumSize(new java.awt.Dimension(350, 200));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        topPanel.setPreferredSize(new java.awt.Dimension(32, 32));

        jLabel1.setText("Style");
        topPanel.add(jLabel1);

        styleBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                styleBoxActionPerformed(evt);
            }
        });
        topPanel.add(styleBox);

        jLabel2.setText("Size");
        topPanel.add(jLabel2);

        pointBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pointBoxActionPerformed(evt);
            }
        });
        topPanel.add(pointBox);

        getContentPane().add(topPanel, java.awt.BorderLayout.NORTH);

        fontList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                fontListValueChanged(evt);
            }
        });
        scrollPane.setViewportView(fontList);

        getContentPane().add(scrollPane, java.awt.BorderLayout.CENTER);

        bottomPanel.setLayout(new java.awt.BorderLayout());

        jLabel3.setText("Sample:");
        samplePanel.add(jLabel3);

        textSample.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        textSample.setText("Hello Здравствуйте こんにちは");
        textSample.setMargin(new java.awt.Insets(4, 4, 4, 4));
        textSample.setMinimumSize(new java.awt.Dimension(200, 35));
        textSample.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                textSampleActionPerformed(evt);
            }
        });
        samplePanel.add(textSample);

        bottomPanel.add(samplePanel, java.awt.BorderLayout.NORTH);

        okButton.setText("OK");
        okButton.setToolTipText("Use this font");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(okButton);

        defaultButton.setText("Default");
        defaultButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(defaultButton);

        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Do not change fonts");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(cancelButton);

        bottomPanel.add(buttonPanel, java.awt.BorderLayout.SOUTH);

        getContentPane().add(bottomPanel, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void defaultButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultButtonActionPerformed
        // Add your handling code here:
        commitToFont(new Font("Monospaced", Font.PLAIN, 12));
    }//GEN-LAST:event_defaultButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        // Add your handling code here:
        commitToFont();
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        currentFont = null;
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void fontListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_fontListValueChanged
        // Add your handling code here:
        setNewFont();
    }//GEN-LAST:event_fontListValueChanged

    private void pointBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pointBoxActionPerformed
        // Add your handling code here:
        setNewFont();
    }//GEN-LAST:event_pointBoxActionPerformed

    private void styleBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_styleBoxActionPerformed
        // Add your handling code here:
        setNewFont();
    }//GEN-LAST:event_styleBoxActionPerformed

    private void setNewFont() {
        if (!needInit) {
            String s = (String) fontList.getSelectedValue();
            if (s != null) {
                fontName = s;
            }
            fontPoints = Integer.parseInt((String) pointBox.getSelectedItem());
            fontStyle = styleConstants[styleBox.getSelectedIndex()];
            showCurrent();
        }
    }

    private void showCurrent() {
        Font font = new Font(fontName, fontStyle, fontPoints);
        textSample.setFont(font);
        textSample.setText(sampleText);
        FontMetrics fm = textSample.getFontMetrics(font);
        Insets in = textSample.getInsets();
        int w = fm.stringWidth(sampleText);
        int h = fm.getHeight();
        w += in.left + in.right;
        h += in.top + in.bottom;
        Dimension d = textSample.getSize();
        //System.out.println(w +","+h+","+d.width+","+d.height);
        if (w > d.width || h > d.height || w < (d.width - 128) || h < (d.height - 128)) {
            textSample.setSize(w + 16, h + 16);
            textSample.setPreferredSize(textSample.getSize());
            // force a relayout
            setSize(getSize().width + 1, getSize().height);
            setSize(getSize().width - 1, getSize().height);
        }
    }

    private void commitToFont() {
        currentFont = new Font(fontName, fontStyle, fontPoints);
        okResult = true;
        setVisible(false);
    }

    private void commitToFont(Font f) {
        currentFont = f;
        okResult = true;
        setVisible(false);
    }

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog

private void textSampleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_textSampleActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_textSampleActionPerformed
    
    public static void main(String[] args) {
        FontChooser fc = new FontChooser(new JFrame(),true,new Font("Monospaced",Font.PLAIN,12),"Choose Font");
        boolean r = fc.showDialog();
        //System.out.println(r);
        fc.dispose();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton defaultButton;
    private javax.swing.JList<String> fontList;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JButton okButton;
    private javax.swing.JComboBox<String> pointBox;
    private javax.swing.JPanel samplePanel;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JComboBox<String> styleBox;
    private javax.swing.JTextField textSample;
    private javax.swing.JPanel topPanel;
    // End of variables declaration//GEN-END:variables
    
}
