// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * FileChangedDialog.java
 *
 * Created on November 5, 2006, 10:15 AM
 */

package Arachnophilia;

import java.awt.*;

/**
 *
 * @author  Administrator
 */
public class FileChangedDialog extends javax.swing.JDialog {
    public int state = -1;
    Arachnophilia main;
    /** Creates new form FileChangedDialog */
    public FileChangedDialog(Arachnophilia m,String path, boolean changed,boolean modal) {
        super(m, modal);
        main = m;
        initComponents();
        setTitle("File Changed on disk");
        String message = "The file \"" + path + "\" has been changed by another program.\n";
        if(changed) {
            message += "Also, changes have been made to the document, and the \"Reload File\" choice will lose all changes.\n";
        }
        message += "What do you want to do?";
        messageTextArea.setText(message);
        messageTextArea.setBackground(getContentPane().getBackground());
        pack();
        Rectangle r = main.getBounds();
        int wp = r.width/4;
        int hp = r.height/4;
        //Rectangle sz = getBounds();
        //int ws = sz.width * 3/2;
        //int hs = sz.height * 3/2;
        //setSize(ws,hs);
        setLocation(r.x+wp,r.y+hp);
        main.beep();
        setVisible(true);
    }
    
    public void closeDialog(int v) {
        state = v;
        setVisible(false);
        dispose();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        messageTextArea = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        overwriteButton = new javax.swing.JButton();
        reloadButton = new javax.swing.JButton();
        ignoreButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        messageTextArea.setEditable(false);
        messageTextArea.setFont(new java.awt.Font("Monospaced", 0, 14));
        messageTextArea.setLineWrap(true);
        messageTextArea.setWrapStyleWord(true);
        messageTextArea.setMargin(new java.awt.Insets(8, 8, 8, 8));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(messageTextArea, gridBagConstraints);

        overwriteButton.setText("Overwrite File");
        overwriteButton.setToolTipText("Replace disk file contents with memory contents");
        overwriteButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                overwriteButtonClicked(evt);
            }
        });
        jPanel1.add(overwriteButton);

        reloadButton.setText("Reload File");
        reloadButton.setToolTipText("Reload disk file, erase memory contents");
        reloadButton.setSelected(true);
        reloadButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                reloadButtonClicked(evt);
            }
        });
        jPanel1.add(reloadButton);

        ignoreButton.setText("Ignore");
        ignoreButton.setToolTipText("Take no action");
        ignoreButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ignoreButtonClicked(evt);
            }
        });
        jPanel1.add(ignoreButton);

        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Take no action");
        cancelButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cancelButtonClicked(evt);
            }
        });
        jPanel1.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents
    
    private void cancelButtonClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cancelButtonClicked
        // TODO add your handling code here:
        closeDialog(0);
    }//GEN-LAST:event_cancelButtonClicked
    
    private void ignoreButtonClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ignoreButtonClicked
        // TODO add your handling code here:
        closeDialog(1);
    }//GEN-LAST:event_ignoreButtonClicked
    
    private void reloadButtonClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadButtonClicked
        // TODO add your handling code here:
        closeDialog(2);
    }//GEN-LAST:event_reloadButtonClicked
    
    private void overwriteButtonClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_overwriteButtonClicked
        closeDialog(3);
    }//GEN-LAST:event_overwriteButtonClicked
    
    /**
     * @param args the command line arguments
     */
    //public static void main(String args[]) {
    //    new FileChangedDialog(new javax.swing.JFrame(), true).show();
    //}
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton ignoreButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTextArea messageTextArea;
    private javax.swing.JButton overwriteButton;
    private javax.swing.JButton reloadButton;
    // End of variables declaration//GEN-END:variables
    
}
