// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * ErrorTracker.java
 *
 * Created on March 13, 2002, 7:45 PM
 */

package Arachnophilia;

import java.io.*;
import java.util.*;

/**
 *
 * @author  Administrator
 * @version
 */
public class ErrorMessageLogger {
    
    static String path = null;
    static PrintStream ps;
    static public void setPath(String p) {
        if(path == null) {
            path = p;
            File f = new File(path);
            try {
                f.delete();
            }
            catch(Exception e) {}
            try {
                ps = new PrintStream(new FileOutputStream(f));
                System.setErr(ps);
                System.setOut(ps);
                System.out.println("Error log for " + ArachConstants.APPNAME + " build " + ArachConstants.BUILDNUMBER);
                System.out.println(new Date().toString());
                System.out.println("Operating System: " + System.getProperty("os.name"));
                System.out.println("Java Version: " + System.getProperty("java.version"));
                System.out.println("If you plan to submit a bug report, be sure to include the entire contents of this log.");
                System.out.println("If there are no messages below the dashed line, there were no errors" + ArachConstants.SYSTEM_EOL
                +"during the most recent Arachnophilia session.");
                System.out.println("If you see a message below about an error \"in native code outside the VM\"," + ArachConstants.SYSTEM_EOL
                + "or language like that, this means there was an error in your operating system," + ArachConstants.SYSTEM_EOL
                + "not in Java or Arachnophilia.");
                for(int i = 0;i < 60;i++) {
                    System.out.print("-");
                }
                System.out.println();
            }
            catch(Exception ee) {
                ee.printStackTrace(System.out);
            }
        }
    }
}
