// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * EntityProcessor.java
 *
 * Created on February 26, 2002, 11:49 AM
 */
import java.io.*;
import java.util.*;

/**
 *
 * @author Administrator
 * @version
 */
final public class EntityProcessor {

    Arachnophilia main;
    ArrayList<CharEntity> entityArray;

    /**
     * Creates new EntityProcessor
     */
    public EntityProcessor(Arachnophilia m) {
        main = m;
    }

    public String entityToChar(String content, boolean isHTML) {
        loadEntityArray();
        StringBuilder result = new StringBuilder();
        int s;
        int len = content.length();
        char c;
        //int x = 0,y,z;
        //System.out.println(content);
        boolean inTag = false;
        for (int i = 0; i < content.length(); i++) {
            c = content.charAt(i);
            if (isHTML && c == '<') {
                inTag = true;
            }
            boolean replaced = false;
            if (!inTag) {
                if (c == '&') {
                    int p = content.indexOf(';', i);
                    if (p != -1 && p > i) {
                        s = entityCharToNumber(content.substring(i + 1, p));
                        if (s != 0) {
                            result.append((char) s);
                            i += (p - i);
                            replaced = true;
                        }
                    }
                }
            }
            if (!replaced) {
                result.append(c);
            }
            if (isHTML && c == '>') {
                inTag = false;
            }
        }
        return result.toString();
    }

    public String entityToString(String content, boolean isHTML) {
        loadEntityArray();
        StringBuilder result = new StringBuilder();
        String s;
        boolean inTag = false;
        char c;
        for (int i = 0; i < content.length(); i++) {
            c = content.charAt(i);
            if (isHTML && c == '<') {
                inTag = true;
            }
            if (!inTag) {
                s = entityNumberToChar(c);
                if (s != null) {
                    result.append("&").append(s).append(";");
                } else {
                    result.append(c);
                }
            } else {
                result.append(c);
            }
            if (isHTML && c == '>') {
                inTag = false;
            }
        }
        return result.toString();
    }

    public String entityNumberToChar(int v, boolean load) {
        if (load) {
            loadEntityArray();
        }
        return entityNumberToChar(v);
    }

    private String entityNumberToChar(int v) {
        String result = null;
        //System.out.println("Testing: " + v);
        for (int i = 0; i < entityArray.size(); i++) {
            CharEntity item = (CharEntity) entityArray.get(i);
            if (item.index == v) {
                result = item.value;
                //System.out.println("found: " + result);
                break;
            }
        }
        // make numeric literal out of all v > 127
        if (result == null && v > 127) {
            result = "#" + v;
        }
        return result;
    }

    public int entityCharToNumber(String s, boolean load) {
        if (load) {
            loadEntityArray();
        }
        return entityCharToNumber(s);
    }

    private int entityCharToNumber(String s) {
        int result = 0;
        // numeric literal
        if (s.length() > 0 && s.charAt(0) == '#') {
            String num = s.substring(1);
            if (num.substring(0,1).equalsIgnoreCase("x")) {
                num = s.substring(2);
                result = Integer.parseInt(num, 16);
            } else {
                result = Integer.parseInt(num);
            }
        } else {
            for (int i = 0; i < entityArray.size(); i++) {
                CharEntity item = (CharEntity) entityArray.get(i);
                if (item.value.equals(s)) {
                    result = item.index;
                    break;
                }
            }
        }
        return result;
    }

    private void loadEntityArray() {
        if (entityArray == null) {
            entityArray = new ArrayList<CharEntity>();
            StringBuilder path = new StringBuilder();
            path.append(main.basePath).append(ArachConstants.SYSTEM_FILESEP).append(Arachnophilia.dataDirName).append(ArachConstants.SYSTEM_FILESEP).append("ExtendedChars.txt");
            try {
                FileReader fr = new FileReader(new File(path.toString()));
                BufferedReader br = new BufferedReader(fr);
                String line;
                while ((line = br.readLine()) != null) {
                    ArrayList<String> v = ArachComp.parseDelimLine(line, ",");
                    if (v.size() > 1) {
                        int index = Integer.parseInt(v.get(0));
                        String value = v.get(1);
                        entityArray.add(new CharEntity(index, value));
                        //System.out.println(index + "," + value);
                    }
                }
                fr.close();
                br.close();
            } catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    class CharEntity {

        int index;
        String value;

        public CharEntity(int i, String s) {
            index = i;
            value = s;
        }
    }
}
