// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * DocToHTMLConverter.java
 *
 * Created on February 17, 2002, 2:16 PM
 */
import java.awt.*;
import javax.swing.text.*;
import org.fife.ui.rsyntaxtextarea.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class DocToHTMLConverter {

    Arachnophilia main;
    SearchReplace srch;
    boolean textBold;
    boolean textItalic;
    Color textColor;
    Font defaultFont;
    Color defaultColor;
    boolean boldTag = false;
    boolean italicTag = false;
    boolean colorTag = false;
    boolean lineNums;

    /** Creates new DocToHTMLConverter */
    public DocToHTMLConverter(Arachnophilia m) {
        main = m;
        lineNums = m.configValues.lineNumberColumn;
        srch = new SearchReplace();
    }

    private String padNum(String num, int max) {
        StringBuilder sb = new StringBuilder();
        int maxLen = ("" + max).length();
        int len = ("" + num).length();
        for (int i = len; i <= maxLen; i++) {
            sb.append("&nbsp;");
        }
        sb.append("").append(num);
        return sb.toString();
    }

    public String convertDoc(MySyntaxTextArea ta) {
        StringBuilder sb = new StringBuilder();
        if (ta != null) {
            int type = ta.theDoc.getFileType();
            boolean plainText = (type == main.fileTypes.getFileTypeForName("Text"));
            RSyntaxDocument doc = (RSyntaxDocument) ta.getDocument();
            Element root = doc.getDefaultRootElement();
            int lineCount = root.getElementCount();
            Token t = doc.getTokenListForLine(0);
            String s = t.getHTMLRepresentation(ta);
            String face = s.replaceFirst(".*font face=\"(.*?)\".*", "$1");
            String doc_line = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
            sb.append(doc_line);
            sb.append("<html>\n<head>\n<title>");
            sb.append("Listing: ").append(ta.theDoc.getFullPath());
            sb.append("</title>\n");
            sb.append("<style type=\"text/css\">\n");
            sb.append("body * { font:").append(face).append("; }\n");
            sb.append("tr * { padding:0px;margin:0px; }\n");
            sb.append(".lncell { text-align:right;padding-right:4px;padding-left:4px;background-color:#f0f0f0; }\n");
            sb.append(".dcell { padding-left:8px; }\n");
            sb.append("</style>\n");
            sb.append("</head>\n");
            sb.append("<body bgcolor=\"#ffffff\">\n");
            if (!plainText) {
                sb.append("<pre>\n");
            }
            if (lineNums) {
                sb.append("<table border=0 cellpadding=0 cellspacing=0>");
            }
            for (int line = 0; line < lineCount; line++) {
                s = "";
                t = doc.getTokenListForLine(line);
                while (t != null && t.isPaintable()) {
                    if (plainText) {
                        s += t.getLexeme().toString();
                    } else {
                        String hts = t.getHTMLRepresentation(ta);
                        hts = hts.replaceAll(" face=\\S+", "");
                        s += hts;
                    }
                    t = t.getNextToken();
                }
                s = s.replaceAll("(http://[_\\w\\./]+)", "<a href=\"$1\">$1</a>");
                if (lineNums) {
                    if (!plainText) {
                    s = "<pre>" + s + "</pre>";
                    }
                    sb.append("<tr><td class=\"lncell\"><pre>").append(line + 1).append("</pre></td><td class=\"dcell\">").append(s).append("</td></tr>\n");
                } else {
                    if (!plainText) {
                        sb.append(s).append("\n");
                    } else {
                        sb.append(s).append("<br/>\n");
                    }
                }
            }
            if (lineNums) {
                sb.append("</table>\n");
            }
            if (!plainText) {
                sb.append("</pre>\n");
            }
            sb.append("</pre>\n</body>\n</html>\n");
        }
        return sb.toString();
    }
}
