// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * ConfigValues.java
 *
 * Created on October 19, 2001, 6:32 PM
 */

import ListTableWizards.*;
import java.awt.*;

/**
 *
 * @author  Administrator
 * @version
 */

// this class is automatically saved and restored from a file
// by class InitFileHandler, which uses reflection to
// read the field names

final public class ConfigValues {
    
    ConfigValues(Arachnophilia m) {
        fileTypePaths= makeStringArray(m.fileTypes.fileTypeNames.length);
        findStrings = makeStringArray(findRepStringsLength);
        replaceStrings = makeStringArray(findRepStringsLength);
        recentFileList = makeStringArray(recentFileListSize);
        openFileList = makeStringArray(openFileListSize);
        browserList = makeStringArray(browserListSize);
        
        appBounds = new Rectangle(0,0,0,0);
        tableWizData = new TableWizData();
    }
    
    private String[] makeStringArray(int len) {
        String[] a = new String[len];
        for(int i = 0; i < len;i++) {
            a[i] = new String();
        }
        return a;
    }

    public String fileEncoding = "UTF-8";
    
    public String fileSaveEOL = EscapeUnescapeStringHandler.escapeString(ArachConstants.SYSTEM_EOL);
    
    public TableWizData tableWizData;
    
    public int pageBackgroundColor = 0xffffff;
    public int pageTextColor = 0x000000;
    public int pageLinkColor = 0x0000ff;
    public int pageActiveLinkColor = 0xff0000;
    public int pageVisitedLinkColor = 0x800080;
    
    public double beepLevel = 0.5;
    
    public int contentSplitPaneLoc = 200;
        
    public int undoRedoStackSize = 16;
    
    public int browserListSize = 24;
    public String[] browserList;
    
    public int selectedBrowser = 0;
    public boolean showBrowserInfo = true;
    public String browserSearchStartPath = "/";
    
    public int openFileListSize = 16;
    
    // last opened files to reopen
    public String[] openFileList;
    
    // size of recent site list
    public int recentFileListSize = 16;
    
    // file ... recent site list
    public String[] recentFileList;
    
    public String[] fileTypePaths;
    
    public int findRepStringsLength = 32;
    
    public String[] findStrings;
    public String[] replaceStrings;
    
    public String lookAndFeelName = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
    
    public String programFontName = "Monospaced";
    public int programFontStyle = Font.PLAIN;
    public int programFontSize = 12;
    
    public String editFontName = "Monospaced";
    public int editFontStyle = Font.PLAIN;
    public double editFontSize = 12;
    
    public int tabSize = 2;
    public boolean useSpacesForTabs = true;
    
    
    public int toolBarPosition = 0;
    
    public int autoSaveIntervalSeconds = 0;
    
    public boolean showTipOfTheDay = true;
    public int currentTip = 0;
    
    
    public int lastOpenedFileType = -1;
    public int lastNewFileType = -1;
    public int windowListSize = 24;
    public Rectangle appBounds = new Rectangle(0,0,0,0);
    
    public boolean showRegexpWarning = true;
    
    public boolean showToolBarPanel = true;
    public int toolBarPanelVisibility = 1;
    
    public boolean maximized = false;
    
    public boolean paintEOLMarks = false;
    
    public boolean lineNumberColumn = false;
    public boolean lineWrap = true;
    
    public boolean expandedSearch = false;
    public boolean caseSensitiveTextSearch = false;
    public boolean instantSearch = false;
    public boolean regExpTextSearch = false;
    public boolean multiLineSearch = false;
    public boolean dotMatchesNewline = false;
    public boolean oneClickMacroMode = false;
    
    public boolean spellIsHTML = false;
    public boolean spellIgnoreUCWords = true;
    
    public boolean showMacroEditorInFrame = false;
    
    public boolean mainDividerMinimized = false;
    public boolean autoIndent = true;
    public boolean useAntiAliasing = true;
    
    // NOTE: StyleColorDialog contains a duplicate list
    // of these values, used to reset defaults
    
    public SyntaxStyleData STYLE_COMMENT = new SyntaxStyleData(new Color(128,128,128),true,false);
    public SyntaxStyleData STYLE_DOC_COMMENT = new SyntaxStyleData(new Color(64,64,64),true,false);
    public SyntaxStyleData STYLE_KEYWORD = new SyntaxStyleData(new Color(0,0,128),false,true);
    public SyntaxStyleData STYLE_FUNCTION = new SyntaxStyleData(new Color(173,128,0),false,false);
    public SyntaxStyleData STYLE_LITERAL_NUMBER = new SyntaxStyleData(new Color(100,0,200),false,false);
    public SyntaxStyleData STYLE_LITERAL_STRING = new SyntaxStyleData(new Color(160,0,0),false,false);
    public SyntaxStyleData STYLE_DATA = new SyntaxStyleData(new Color(0,128,128),false,false);
    public SyntaxStyleData STYLE_VARIABLE = new SyntaxStyleData(new Color(0,128,192),false,false);
    public SyntaxStyleData STYLE_IDENTIFIER = new SyntaxStyleData(new Color(0,0,0),false,false);
    public SyntaxStyleData STYLE_WHITESPACE = new SyntaxStyleData(new Color(128,128,128),false,false);
    public SyntaxStyleData STYLE_SEPARATOR = new SyntaxStyleData(new Color(160,0,0),false,false);
    public SyntaxStyleData STYLE_OPERATOR = new SyntaxStyleData(new Color(128,64,64),false,false);
    public SyntaxStyleData STYLE_PREPROCESSOR = new SyntaxStyleData(new Color(128,128,128),false,false);
    public SyntaxStyleData STYLE_MARKUP_DELIM = new SyntaxStyleData(new Color(128,0,128),false,false);
    public SyntaxStyleData STYLE_MARKUP_NAME = new SyntaxStyleData(new Color(0,0,192),false,false);
    public SyntaxStyleData STYLE_MARKUP_ATTRIB = new SyntaxStyleData(new Color(63,127,127),false,false);
    public SyntaxStyleData STYLE_ERROR = new SyntaxStyleData(new Color(148,0,0),false,false);
    
    
}
