/// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * ClipboardString.java
 *
 * Created on March 6, 2002, 11:17 PM
 */
package Arachnophilia;

import java.awt.*;
import java.awt.datatransfer.*;

/**
 *
 * @author  Administrator
 * @version
 */
public class ClipboardSender implements Transferable, ClipboardOwner {

    String dataString;

    /** Creates new ClipboardString */
    public ClipboardSender(String data) {
        dataString = data;
        init();
    }

    private void init() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(this, this);
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public synchronized java.lang.Object getTransferData(java.awt.datatransfer.DataFlavor flavor)
            throws java.awt.datatransfer.UnsupportedFlavorException, java.io.IOException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return dataString;
        }
        return dataString.toCharArray();
    }

    @Override
    public boolean isDataFlavorSupported(java.awt.datatransfer.DataFlavor flavor) {
        postMessage("Receiver is asking for: " + flavor);
        if (flavor.equals(DataFlavor.stringFlavor)) {
            postMessage("Matched with: " + DataFlavor.stringFlavor);
            return true;
        }
        return false;
    }

    @Override
    public java.awt.datatransfer.DataFlavor[] getTransferDataFlavors() {
        postMessage("receiver called \"getTransferDataFlavors\"");
        return new DataFlavor[]{DataFlavor.stringFlavor};
    }

    @Override
    public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, java.awt.datatransfer.Transferable contents) {
        postMessage("lost ownership");
    }

    private void postMessage(String msg) {
        //System.out.println("ClipboardSender: " + msg);
        //JOptionPane.showMessageDialog(null,msg);
    }
}
