// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * Arachnophilia.java
 *
 * Created on November 18, 2001, 1:22 PM
 */
import BrowserStuff.*;
import CompilerReplyPanel.*;
import FilePicker.*;
import FileTypes.*;
import HTMLValidator.*;
import ListTableWizards.*;
import MacroManager.*;
import SourceBeautifiers.*;
import SpellCheck.*;
import TipOfTheDay.*;
import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import java.util.zip.*;
import javax.swing.*;

/**
 *
 * @author Administrator
 * @version
 */
final public class Arachnophilia extends javax.swing.JFrame implements DropTargetListener {

    public boolean DEBUG = false;
    static final public String errorLogFileName = "ArachErrorLog.txt";
    static final public String tempFilePrefix = "~ArachBrowserTemp";
    static final public String ftpLogFileName = ".ArachnophiliaFTPUploadFileList.log";
    static final public String customDictName = "CustomDictionary.txt";
    static final public String userAppDir = ".Arachnophilia";
    static final public String iniFileName = "Arach.ini";
    static final public String jarName = "Arachnophilia.jar";
    static final public String dataDirName = "ArachConf";
    static final public String templateDirName = "Templates";
    static final public String macroDirName = "Macros";
    static final public String iconDirName = "Icons";
    static final public String spellCheckDataDirName = "SpellCheckData";
    static final public String docDirName = "Documentation";
    static final public String docImagesDirName = "Documentation/images";
    static final public String docStylesDirName = "Documentation/styles";
    static final public String customClassDirName = "CustomClasses";
    static final public String macroFileName = "Macros.xml";
    // dirList are the directories copied to user home
    // under userAppDir
    static final public String[] dirList = {
        dataDirName,
        templateDirName,
        macroDirName,
        spellCheckDataDirName,
        docDirName,
        docImagesDirName,
        docStylesDirName,
        customClassDirName
    };
    //private javax.swing.Timer memDispTimer;
    static final public String defaultStatusMessage = "Done.";
    private ArrayList<String> comArgs;
    Dimension screenSize;
    Dimension appSize;
    public HashMap<RenderingHints.Key, Object> renderHints;
    public ImageIcon frameIcon;
    public FileListHandler fileHandler;
    public ComSwitchboard comSwitchboard;
    public FileTypes fileTypes;
    public String jarPath; // application location
    public String userHome; // user's home dir
    public String basePath; // path to config under userHome
    public InitFileHandler initFileHandler;
    public String configPath;
    public String fileTypePath;
    public String ftpSitePath;
    public String macroPath;
    public String errorLogPath;
    public ConfigValues configValues;
    public XHTMLBeautifyUtils beautifyUtils;
    public HTMLValidator htmlValidator;
    public EntityProcessor entityProcessor = null;
    private BrowserLauncher browserLauncher;
    public RightClickProcessor rightClickProcessor;
    //public ArachComp arachComp;
    public RecentFileList recentFileList = null;
    public ArachDocument currentSelectedDocument = null;
    public ArachDocument latestOpenedDocument = null;
    //private RegExpPanel regExpPanel;
    public SearchReplacePanel findReplacePanel;
    public MacroHandler macroHandler;
    public MacroKeyHandler macroKeyHandler;
    private JPanel toolBarPanel;
    public MacroEditor macroEditor;
    public SpellCheckFrame spellCheckFrame = null;
    boolean macroEditShowing = false;
    boolean progressBarInUse = false;
    public boolean haveFocus = true;
    private boolean rejectResize = true;
    private boolean already_exited = false;
    public TableWizardFrame tableWizard = null;
    private javax.swing.Timer autoSaveTimer = null;
    SplashWindow installWindow = null;
    MacroEditorFrame macroEditorFrame = null;

    /**
     * Creates new form Arachnophilia
     */
    public Arachnophilia(String[] args) {
        /*for(int i = 0;i < args.length;i++) {
         //System.out.println(args[i]);
         }*/

        renderHints = new HashMap<RenderingHints.Key, Object>();

        userHome = ArachConstants.USERHOME;
        comArgs = new ArrayList<String>(Arrays.asList(args));
        basePath = getConfigDir(userHome);

        testJavaVersion();
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        jarPath = locateJarPath();
        //System.out.println("appDir: " + appDir);

        fileTypePath = basePath + ArachConstants.SYSTEM_FILESEP + dataDirName + ArachConstants.SYSTEM_FILESEP + "FileData.txt";

        errorLogPath = basePath + ArachConstants.SYSTEM_FILESEP + errorLogFileName;

        ftpSitePath = basePath + ArachConstants.SYSTEM_FILESEP + dataDirName + ArachConstants.SYSTEM_FILESEP + "FTPSiteData.txt";

        macroPath = basePath + ArachConstants.SYSTEM_FILESEP + macroDirName + ArachConstants.SYSTEM_FILESEP + macroFileName;

        configPath = basePath + ArachConstants.SYSTEM_FILESEP + dataDirName + ArachConstants.SYSTEM_FILESEP + iniFileName;

        screenSize = Toolkit.getDefaultToolkit().getScreenSize();

        // only when the above is not
        // launching a separate thread
        initPhase2();
    }

    private void initPhase2() {
        ArachComp.setMain(this);
        frameIcon = new ImageIcon(getClass().getResource("/" + iconDirName + "/Arach.png"));
        setIconImage(frameIcon.getImage());
        unpackJarTest(basePath, configPath, jarPath, dirList);

        // NOTE: *** MUST uncomment this
        //       *** if disabled for debugging
        if (!DEBUG) {
            ErrorMessageLogger.setPath(errorLogPath);
        }

        // this call is redundant (and harmless) on an install
        // but it is needed all other times
        if (fileTypePath != null) {
            fileTypes = new FileTypes(fileTypePath);
        }
        configValues = new ConfigValues(this);
        initFileHandler = new InitFileHandler(configPath, this);
        initFileHandler.read(configValues);

        setAntiAliasing();

        ArachComp.setupLookAndFeel(configValues.lookAndFeelName);
        toolBarPanel = new JPanel();
        macroHandler = new MacroHandler(this);
        comSwitchboard = new ComSwitchboard(this);
        macroKeyHandler = new MacroKeyHandler(this);

        beautifyUtils = new XHTMLBeautifyUtils(this);
        htmlValidator = new HTMLValidator(this);
        entityProcessor = new EntityProcessor(this);
        browserLauncher = new BrowserLauncher(this);
        //ArachComp.getFileTypeData();

        recentFileList = new RecentFileList(this, configValues.recentFileListSize, null);
        recentFileList.putAll(configValues.recentFileList);

        Font f = new Font(
                configValues.programFontName,
                configValues.programFontStyle,
                configValues.programFontSize);
        ArachComp.setProgramFont(f);
        macroEditor = new MacroEditor(this);

        setProgramTitle();
        initComponents();
        rightClickProcessor = new RightClickProcessor(this);

        showToolBarPanel(configValues.toolBarPanelVisibility);
        topMainPanel.add(toolBarPanel, BorderLayout.NORTH);

        getContentPane().remove(toolBar);
        toolBar.setFloatable(true);
        String pos = ArachConstants.barPositions[configValues.toolBarPosition];
        toolBar.setOrientation((pos.equals("North") || pos.equals("South")) ? JToolBar.HORIZONTAL : JToolBar.VERTICAL);
        getContentPane().add(toolBar, pos);

        findReplacePanel = new SearchReplacePanel(this);
        topMainPanel.add(findReplacePanel, BorderLayout.SOUTH);
        // this won't have its font changed otherwise
        //regExpPanel = new RegExpPanel(this);
        //spaceFillerPanel.add(regExpPanel);

        if (configValues.mainDividerMinimized) {
            contentSplitPane.setDividerLocation(0.0);
        }

        setFont(f);

        setJMenuBar(mainMenuBar);

        fileHandler = new FileListHandler(rightTabbedPane, this);
        // set drag & drop targets
        // main frame
        DropTarget dropTarget = new DropTarget(this,
                DnDConstants.ACTION_COPY_OR_MOVE,
                this);
        // menu bar
        /*
         new DropTarget(mainMenuBar,
         DnDConstants.ACTION_COPY_OR_MOVE,
         this);*/
        // empty tabbed pane
        showCompilerPanel(false, null);
        DropTarget dropTarget1 = new DropTarget(rightTabbedPane,
                DnDConstants.ACTION_COPY_OR_MOVE,
                this);

        // must reset font
        //setFont(f);
        /*memDispTimer = new javax.swing.Timer(500,
         new ActionListener(){
         public void actionPerformed(ActionEvent e) {
         updateMemDisplay();
         }
         }
         );
         memDispTimer.start();*/
        configValues.lastNewFileType = setDefaultFileType(configValues.lastNewFileType);
        configValues.lastOpenedFileType = setDefaultFileType(configValues.lastOpenedFileType);

        if (comArgs.size() > 0) {
            openStringArrayList(comArgs);
        } else {
            openStringArray(configValues.openFileList);
        }

        pack();
        rejectResize = false;
        if (configValues.maximized) {
            setBounds(configValues.appBounds);
            setExtendedState(Frame.MAXIMIZED_BOTH);
            testAppDimensions(false);
        } else {
            setBounds(configValues.appBounds);
            //System.out.println(getBounds());
            testAppDimensions(true);
        }

        contentSplitPane.setDividerLocation(configValues.contentSplitPaneLoc);

        configureAutoSave();
        //System.out.println(configValues.appBounds + "," + configValues.maximized);
        setVisible(true);
        if (installWindow != null) {
            installWindow.requestFocusInWindow();
            installWindow.toFront();
        }

        if (configValues.showTipOfTheDay) {
            TipJFrame tipJFrame = new TipJFrame(this);
        }
        updateStatusBar("");
        // trap system halts to save documents
        // and configuration
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override
            public void run() {
                exitTest();
            }
        });
    }

    protected void setProgramTitle() {
        String s = ArachConstants.APPNAME;
        if (currentSelectedDocument != null && fileHandler != null && fileHandler.docArray().length > 0) {
            s = currentSelectedDocument.getShortName() + " - " + s;
        }
        setTitle(s);
    }

    public void p(String s) {
        System.out.println(s);
    }

    public void showSearchResults(String s) {
        this.searchResultLabel.setText("| Search: " + s);
    }

    // default is user home directory
    // but an alternative can be submitted
    // on the command line
    String getConfigDir(String path) {
        if (comArgs.size() > 0 && new File(comArgs.get(0)).isDirectory()) {
            path = comArgs.remove(0);
        }
        return path + ArachConstants.SYSTEM_FILESEP + userAppDir;
    }

    public void setAntiAliasing() {
        renderHints = new HashMap<RenderingHints.Key, Object>();
        if (configValues.useAntiAliasing) {
            renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        if (fileHandler != null) {
            fileHandler.refreshCurrentDisplayedDocument();
        }
    }

    // increasingly complicated version comparison code
    private void testJavaVersion() {
        // I give up. If Oracle should ever adopt a rational Java verisoning system,
        // I'll try again
        return;
        //String vs = System.getProperty("java.version");
        //boolean accept = convertVersionString(vs) >= convertVersionString(ArachConstants.requiredJavaVersion);
        //if (!accept) {
        //    JOptionPane.showMessageDialog(this, "Very Sorry!\n\n" + ArachConstants.APPNAME + " requires a Java runtime engine (JRE)\n" + "with a version of " + ArachConstants.requiredJavaVersion + " or better.\n" + "This machine has a version " + vs + " JRE.\n" + "Please acquire the correct JRE at http://java.com.", "Wrong Java Runtime Version", JOptionPane.WARNING_MESSAGE);
        //    System.exit(0);
        //}
    }

    //private int convertVersionString(String version) {
    //    try {
    //        int len = version.length();
    //        int i = 0;
    //        while (i < len && !Character.isDigit(version.charAt(i))) {
    //            i++;
    //        }
    //        StringBuilder sb = new StringBuilder();
    //        char c = ' ';
    //        while (i < len && Character.isDigit((c = version.charAt(i))) || c == '.') {
    //            if (Character.isDigit(c)) {
    //                sb.append(c);
    //            }
    //            i++;
    //        }
    //        int q = Integer.parseInt(sb.toString());
    //        while (q > 0 && q < 100) {
    //            q *= 10;
    //        }
    //        return q;
    //    } catch (Exception e) {
    //        return 0;
    //    }
    //}
    public void configureAutoSave() {
        if (autoSaveTimer != null) {
            autoSaveTimer.stop();
            autoSaveTimer = null;
        }
        if (configValues.autoSaveIntervalSeconds != 0) {
            //System.out.println("creating autosave timer: " + configValues.autoSaveIntervalSeconds * 1000);
            autoSaveTimer = new javax.swing.Timer(
                    configValues.autoSaveIntervalSeconds * 1000,
                    new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    //System.out.println("autosave");
                    saveAllChangedDocs();
                }
            });
            autoSaveTimer.start();
        }
    }

    public boolean requestFocusEnabled() {
        return true;
    }

    public MacroTreePanel getMacroPanel() {
        return (MacroTreePanel) macroPanel;
    }

    private void setInstallFocus() {
        if (installWindow != null) {
            installWindow.requestFocusInWindow();
        }
    }

    public void testAppDimensions(boolean reposition) {
        if (configValues.maximized) {
            return;
        }
        boolean ok = true;
        if (configValues.appBounds.width < 75 || configValues.appBounds.height < 75) {
            ok = false;
        }
        if (configValues.appBounds.width + configValues.appBounds.x > screenSize.width + 16
                || configValues.appBounds.height + configValues.appBounds.y > screenSize.height + 16) {
            ok = false;

        }
        if (configValues.appBounds.x < -40 || configValues.appBounds.y < -40) {
            ok = false;
        }
        if (!ok) {
            setScreenDefaults(configValues, screenSize);
            //if(reposition) {
            setBounds(configValues.appBounds);
            //}
        }
    }

    // a reasonably reliable way to determine the
    // application source directory
    private String locateJarPath() {
        String path = "";
        try {
            CodeSource src = getClass().getProtectionDomain().getCodeSource();
            path = src.getLocation().toURI().getPath();
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return path;
        /*String s = getClass().getName();
         String pack = "";
         //System.out.println(s);
         // separate class name from package names
         int p = s.lastIndexOf(".");
         if (p != -1) {
         pack = s.substring(0, p);
         s = s.substring(p + 1);
        
         }
         //System.out.println("pack): " + pack + ", class: " + s);
         URL url = getClass().getResource(s + ".class");
         //URL url = getClass().getResource("Arachnophilia.class");
         // now convert this into a file path
         //System.out.println(url);
         File f = new File(url.getPath());
         String applicationDir = f.getPath();
         //System.out.println("appDir: " + appDir);
         // strip off the jar file name
         p = applicationDir.lastIndexOf(ArachConstants.SYSTEM_FILESEP);
         if (p != -1) {
         // we've stripped the class name
         applicationDir = applicationDir.substring(0, p);
         if (pack.length() > 0) {
         p = applicationDir.lastIndexOf(pack);
         if (p != -1) {
         applicationDir = applicationDir.substring(0, p);
         p = applicationDir.lastIndexOf(ArachConstants.SYSTEM_FILESEP, p);
         if (p != -1) {
         applicationDir = applicationDir.substring(0, p);
         }
         }
         }
         // now strip the jar file name
         // if one exists
         p = applicationDir.lastIndexOf(".jar");
         if (p != -1) {
         p = applicationDir.lastIndexOf(ArachConstants.SYSTEM_FILESEP, p);
         if (p != -1) {
         applicationDir = applicationDir.substring(0, p);
         }
         }
         }
         // now look for "file:/" prefix
         String testString = "file:";
         p = applicationDir.indexOf(testString);
         if (p != -1) {
         applicationDir = applicationDir.substring(p + testString.length());
         }
         applicationDir = new SearchReplace().srchRplc(applicationDir, "%20", " ");
         //System.out.println("appdir: " + appDir);
         return applicationDir;*/
    }

    public MyJPopupMenu getDocPopup() {
        return (MyJPopupMenu) plainDocPopup;
    }

    public void showMacroEditPanel(boolean v, boolean force) {
        MacroTreePanel panel = getMacroPanel();
        if (panel != null) {
            panel.setEditCheckBox(v);
        }
        macroEditShowing = v;
        if (configValues.showMacroEditorInFrame) {
            if (rightTabbedPane != null) {
                rightTabbedPane.remove(macroEditor);
            }
            if (v) {
                macroEditorFrame = new MacroEditorFrame(this, macroEditor);
                macroEditorFrame.toFront();
            } else {
                if (macroEditorFrame != null) {
                    macroEditorFrame.getContentPane().remove(macroEditor);
                    macroEditorFrame.setVisible(false);
                    macroEditorFrame.dispose();
                    macroEditorFrame = null;
                }
            }
        } else { // wants it docked
            if (macroEditorFrame != null) {
                macroEditorFrame.getContentPane().remove(macroEditor);
                macroEditorFrame.setVisible(false);
                macroEditorFrame.dispose();
                macroEditorFrame = null;
            }
            if (v) {
                if (rightTabbedPane.getComponentCount() > 0) {
                    if (rightTabbedPane.getComponentAt(0) instanceof MacroEditor) {
                        if (force) {
                            rightTabbedPane.setSelectedComponent(macroEditor);
                        }
                        return;
                    }
                }
                rightTabbedPane.insertTab("Macro Editor", null, macroEditor, "Macro Editor", 0);
                rightTabbedPane.setSelectedComponent(macroEditor);
            } else { // !v
                if (rightTabbedPane != null) {
                    rightTabbedPane.remove(macroEditor);
                }
            }
        }
    }

    public void showToolBarPanel(int v) {
        configValues.toolBarPanelVisibility = v;
        toolBarPanel.setVisible(v != 0);

    }

    public JPanel getToolBarPanel() {
        return toolBarPanel;
    }

    public void clearCompilerPanel() {
        Object ob = rightSplitPane.getBottomComponent();
        if (ob != null && ob instanceof ReplyPanel) {
            ReplyPanel panel = (ReplyPanel) ob;
            panel.clearDataList();
        }
    }

    public void showCompilerPanel(boolean show, JPanel panel) {
        Object ob = rightSplitPane.getBottomComponent();
        if (ob != null && ob instanceof ReplyPanel) {
            ((ReplyPanel) ob).destroyThread();
        }
        int p = rightSplitPane.getDividerLocation();
        rightSplitPane.setBottomComponent(null);
        if (show) {
            rightSplitPane.setBottomComponent(panel);
            // test: is window currently closed?
            if (rightSplitPane.getDividerSize() == 0) {
                rightSplitPane.setDividerLocation(.66);
                rightSplitPane.setDividerSize(10);
            } else {
                rightSplitPane.setDividerLocation(p);
            }
        } else {
            rightSplitPane.setDividerLocation(1.0);
            rightSplitPane.setDividerSize(0);
        }
    }

    public JToolBar getToolBar() {
        return toolBar;
    }

    private int setDefaultFileType(int v) {
        if (v < 0) {
            v = fileTypes.getFileTypeForName("Text");
        }
        return v;
    }

    public void unpackJarTest(String basePath, String configPath, String jarPath, String[] dirList) {

        File f = new File(basePath);
        File cf = new File(configPath);
        if (!cf.exists()) {
            installWindow = new SplashWindow(this);
            if (!f.exists()) {
                installWindow.append("Creating directory " + f.getName());
                f.mkdir();
            }
            for (int i = 0; i < dirList.length; i++) {
                unpackJarTest2(basePath, jarPath, dirList[i], installWindow);
            }
            installWindow.append("*** Installation complete ***");
        }
    }

    public void unpackJarTest2(String basePath, String jarPath, String dataDirName, SplashWindow splash) {
        String outputPath = basePath + ArachConstants.SYSTEM_FILESEP + dataDirName;
        try {
            File f = new File(outputPath);
            if (!f.exists()) {
                installWindow.append("Creating directory " + f.getName());
                f.mkdir();
            }
            ZipFile zip = new ZipFile(jarPath);
            Enumeration e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = (ZipEntry) e.nextElement();
                String fn = entry.toString();
                int p = fn.lastIndexOf("/");
                if (p != -1) {
                    String pre = fn.substring(0, p);
                    //System.out.println("testing: " + dataDirName + "," + pre);
                    if (pre.equals(dataDirName)) {
                        splash.append("Moving " + fn);
                        // testing ...
                        String ffn = fn.substring(p + 1);
                        //System.out.println("entry: " + fn + " -> " + ffn);
                        String path = outputPath + "/" + ffn;
                        p = ffn.indexOf('.');
                        if (p != -1) { // not a directory
                            if (testIsBinary(path)) {
                                copyZipBinaryFile(zip, entry, path);
                            } else {
                                // convert the transferred files
                                // to local system's line endings
                                copyZipTextFile(zip, entry, path);
                            }
                        }
                    }
                }
            }
            zip.close();
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private boolean testIsBinary(String path) {
        return path.endsWith(".class") || path.endsWith(".zip") || path.endsWith(".gif") || path.endsWith(".jpg") || path.endsWith(".png");
    }

    public void undo() {
        if (currentSelectedDocument != null) {
            currentSelectedDocument.undo();
        }
    }

    public void redo() {
        if (currentSelectedDocument != null) {
            currentSelectedDocument.redo();
        }
    }

    // this is no longer in use but I am keeping it just in case I
    // have to copy binary files from the JAR file at some point
    public void copyZipBinaryFile(ZipFile zip, ZipEntry entry, String filePath) {
        try {
            BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(entry));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(filePath)));
            int len;
            int bufferSize = 8192;
            byte[] buffer = new byte[bufferSize];
            while ((len = bis.read(buffer, 0, bufferSize)) != -1) {
                bos.write(buffer, 0, len);
            }
            bis.close();
            bos.close();
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    // this routine copies text files from the JAR file
    public void copyZipTextFile(ZipFile zip, ZipEntry entry, String filePath) {
        try {
            BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(entry));
            int len;
            StringBuilder sb = new StringBuilder();
            int bufferSize = 8192;
            byte[] buffer = new byte[bufferSize];
            while ((len = bis.read(buffer, 0, bufferSize)) != -1) {
                sb.append(new String(buffer, 0, len));
            }
            bis.close();
            String data = sb.toString();
            // now process the line endings
            data = ArachComp.toJavaLineEndings(data);
            data = ArachComp.toSystemLineEndings(data);
            if (filePath.indexOf("Documentation") >= 0 && filePath.indexOf(".html") >= 0) {
                data = data.replaceAll("\\(user home directory\\)", userHome);
            }
            File f = new File(filePath);
            BufferedWriter bos = new BufferedWriter(
                    new OutputStreamWriter(
                            new FileOutputStream(f), "UTF-8"));
            bos.write(data);
            bos.close();
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void readZipMacroFile(String filePath) {
        StringBuilder sb = new StringBuilder();
        try {
            ZipFile zip = new ZipFile(jarPath);
            ZipEntry entry = zip.getEntry(filePath);
            if (entry != null) {

                BufferedReader bis = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                int len;
                int bufferSize = 8192;
                char[] buffer = new char[bufferSize];
                while ((len = bis.read(buffer, 0, bufferSize)) != -1) {
                    sb.append(buffer);
                }
                bis.close();
                String content = ArachComp.toJavaLineEndings(sb.toString());
                getMacroPanel().mjt.readRescueMacroString(filePath, content);
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        //return sb.toString();
    }

    public void getRescueMacroSet() {
        readZipMacroFile("Macros/Macros.xml");
    }

    public void updateStatusBar(String s) {
        s += (s.length() > 0) ? " | " : "";
        statusBar.setText(s + "Encoding: " + configValues.fileEncoding);
    }

    //public JProgressBar getProgressBar() {
    //    return progressBar;
    //}
    //private void runGCForProgressBar() {
    //    if(!progressBarInUse) {
    //        System.gc();
    //    }
    //}
    /*private void updateMemDisplay() {
     if(!progressBarInUse) {
     progressBar.setToolTipText("Click me to recover memory");
     long freeMem = Runtime.getRuntime().freeMemory();
     long totalMem = Runtime.getRuntime().totalMemory();
     if(totalMem != 0) {
     int usedMem = (int) (100 - ((100 * freeMem) / totalMem));
     progressBar.setString("Memory used " + usedMem + "%");
     progressBar.setMinimum(0);
     progressBar.setMaximum(100);
     progressBar.setValue(usedMem);
     if(usedMem > 90) {
     progressBar.setForeground(new Color(204,0,0));
     }
     else if(usedMem > 75) {
     progressBar.setForeground(new Color(204,152,0));
     }
     else { // choose a default color
     progressBar.setForeground(new Color(0,128,0));
     }
     }
     }
     }
     public void startProgressBar(String  prompt, long low, long high,long v) {
     progressBarInUse = true;
     updateStatusBar(prompt);
     progressBar.setString(null);
     progressBar.setToolTipText("");
     progressBar.setForeground(statusBar.getForeground());
     progressBarInUse = true;
     progressBar.setStringPainted(true);
     progressBar.setMinimum((int)low);
     progressBar.setMaximum((int)high);
     progressBar.setValue((int)v);
     }
     public void updateProgressBar(long v) {
     progressBar.setValue((int)v);
     }
     public void stopProgressBar() {
     progressBar.setValue(progressBar.getMinimum());
     progressBarInUse = false;
     updateStatusBar(defaultStatusMessage);
     }*/
    private void openStringArray(String[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                if (list[i].length() > 0) {
                    File f = new File(list[i]);
                    if (f.exists() && f.isFile()) {
                        openDoc(f, true, false);
                    }
                }
            }
            fileHandler.setFocusTo(latestOpenedDocument);
        }
    }

    private void openStringArrayList(ArrayList<String> v) {
        openStringArray(v.toArray(new String[]{}));
    }

    private void openFileArray(File[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                openDoc(list[i], true, false);
            }
            resetFocus();
        }
    }

    private void resetFocus() {
        fileHandler.setFocusTo(latestOpenedDocument);
    }

    private void setScreenDefaults(ConfigValues v, Dimension screenSize) {
        int w = screenSize.width / 8;
        int h = screenSize.height / 8;
        v.appBounds.width = screenSize.width - w * 2;
        v.appBounds.height = screenSize.height - h * 2;
        v.appBounds.x = w;
        v.appBounds.y = h;
    }

    public boolean processRightClick(java.awt.event.MouseEvent evt, ArachDocument doc) {
        return rightClickProcessor.processRightClickEvent(evt, doc);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        mainMenuBar = new javax.swing.JMenuBar();
        rootPopup = new MyJPopupMenu();
        syntaxDocPopup = new MyJPopupMenu();
        plainDocPopup = new MyJPopupMenu();
        toolBar = new javax.swing.JToolBar();
        borderPanel = new javax.swing.JPanel();
        mainPanel = new javax.swing.JPanel();
        bottomPanel = new javax.swing.JPanel();
        statusBar = new javax.swing.JLabel();
        searchResultLabel = new javax.swing.JLabel();
        contentSplitPane = new javax.swing.JSplitPane();
        macroPanel = new MacroTreePanel(this);
        rightSplitPane = new javax.swing.JSplitPane();
        rightTabbedPane = new javax.swing.JTabbedPane();
        topMainPanel = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentMoved(java.awt.event.ComponentEvent evt) {
                formComponentMoved(evt);
            }
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });
        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });
        addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                formKeyPressed(evt);
            }
        });
        getContentPane().add(toolBar, java.awt.BorderLayout.NORTH);

        borderPanel.setLayout(new java.awt.BorderLayout());

        mainPanel.setLayout(new java.awt.BorderLayout());

        bottomPanel.setLayout(new java.awt.GridBagLayout());

        statusBar.setText("Configuration");
        statusBar.setToolTipText("Status of activities");
        statusBar.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        bottomPanel.add(statusBar, gridBagConstraints);

        searchResultLabel.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        bottomPanel.add(searchResultLabel, gridBagConstraints);

        mainPanel.add(bottomPanel, java.awt.BorderLayout.SOUTH);

        contentSplitPane.setMinimumSize(new java.awt.Dimension(8, 12));
        contentSplitPane.setOneTouchExpandable(true);

        macroPanel.setBackground(java.awt.Color.white);
        contentSplitPane.setLeftComponent(macroPanel);

        rightSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        rightTabbedPane.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        rightTabbedPane.setToolTipText("<html>Double-click to open a document,<br>right-click for context menu,<br>or drag &amp; drop files</html>");
        rightTabbedPane.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                rightTabbedPaneMouseClicked(evt);
            }
            public void mousePressed(java.awt.event.MouseEvent evt) {
                rightTabbedPaneMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                rightTabbedPaneMouseReleased(evt);
            }
        });
        rightSplitPane.setTopComponent(rightTabbedPane);

        contentSplitPane.setRightComponent(rightSplitPane);

        mainPanel.add(contentSplitPane, java.awt.BorderLayout.CENTER);

        topMainPanel.setLayout(new java.awt.BorderLayout());
        mainPanel.add(topMainPanel, java.awt.BorderLayout.NORTH);

        borderPanel.add(mainPanel, java.awt.BorderLayout.CENTER);

        getContentPane().add(borderPanel, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    private void formComponentMoved(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentMoved
        // Add your handling code here:
        handleResize();
    }//GEN-LAST:event_formComponentMoved

    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
        // Add your handling code here:
        handleResize();
    }//GEN-LAST:event_formComponentResized

    private void rightTabbedPaneMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTabbedPaneMouseClicked
        // Add your handling code here:
        if (evt.getClickCount() > 1) {
            openDoc();
        }
    }//GEN-LAST:event_rightTabbedPaneMouseClicked

    private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained
        // Add your handling code here:
        setInstallFocus();
        resetFocus();
        //if (currentSelectedDocument != null) {
        //    currentSelectedDocument.requestFocusInWindow();
        //}
    }//GEN-LAST:event_formFocusGained

    private void formKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyPressed
        // Add your handling code here:
        handleKey(evt);
    }//GEN-LAST:event_formKeyPressed

    private void rightTabbedPaneMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTabbedPaneMouseReleased
        // Add your handling code here:
        launchPanePopup(evt);
    }//GEN-LAST:event_rightTabbedPaneMouseReleased

    private void rightTabbedPaneMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTabbedPaneMousePressed
        // Add your handling code here:
        launchPanePopup(evt);
    }//GEN-LAST:event_rightTabbedPaneMousePressed

    private void detectDividerLocation() {
        Dimension d = contentSplitPane.getLeftComponent().getSize();
        //System.out.println(d.width);
        configValues.mainDividerMinimized = d.width < 4.0;
    }

    private void handleResize() {
        if (rejectResize) {
            return;
        }
        int state = getExtendedState();
        configValues.maximized = state == Frame.MAXIMIZED_BOTH;
        //System.out.println("handle resize state: " + getBounds() + "," + state);
        if (!configValues.maximized) {
            //System.out.println("handle resize accepts: " + getBounds() + "," + state);
            configValues.appBounds = getBounds();
        }
    }

    public void toggleLineWrap() {
        if (currentSelectedDocument != null) {
            currentSelectedDocument.toggleWrapMode();
        }
    }

    public void toggleLineNumbers() {
        if (currentSelectedDocument != null) {
            currentSelectedDocument.toggleLineNumbers();
        }
    }

    public void toggleEOLMarks() {
        if (currentSelectedDocument != null) {
            currentSelectedDocument.toggleEOLMarks();
        }
    }

    public void changeDisplayModes() {
        if (currentSelectedDocument != null) {
            currentSelectedDocument.toggleWrapMode();
        }
    }

    public JComponent getMenu(String name) {

        if (name.equals("_DocPopup")) {
            return plainDocPopup;
        } else if (name.equals("_RootPopup")) {
            return rootPopup;
        } else {
            return mainMenuBar;
        }
    }

    private void handleKey(java.awt.event.KeyEvent evt) {
        macroKeyHandler.execute(evt);
    }

    public void zoomEditFont(double zoom) {
        configValues.editFontSize = configValues.editFontSize * zoom;
        configValues.editFontSize = Math.max(1.2, configValues.editFontSize);
        Font f = new Font(
                configValues.editFontName,
                configValues.editFontStyle,
                (int) configValues.editFontSize);
        changeFontNameStyle(f);
    }

    public void setEditFont() {
        Font f = new Font(
                configValues.editFontName,
                configValues.editFontStyle,
                (int) configValues.editFontSize);
        FontChooser fc = new FontChooser(this, true, f, "Choose Editing Font");
        if (fc.showDialog()) {
            changeAllFontValues(fc.currentFont);
        }
    }

    public void changeAllFontValues(Font font) {
        configValues.editFontSize = font.getSize();
        changeFontNameStyle(font);
    }

    public void changeFontNameStyle(Font font) {
        configValues.editFontName = font.getName();
        configValues.editFontStyle = font.getStyle();
        ArachDocument[] a = fileHandler.docArray();
        int top = a.length;
        for (int i = 0; i < top; i++) {
            a[i].setNewFont();
        }
    }

    public void openDoc() {
        promptDoc(configValues.lastOpenedFileType);
    }

    public void newDoc() {
        newDoc(configValues.lastNewFileType, true);
    }

    public void launchBrowser(String arg) {
        boolean launched = false;
        if (arg.length() > 0) {
            try {
                URL url = new URL(arg);
                browserLauncher.launchDefaultBrowserWithURL(url.toString());
                launched = true;
            } catch (MalformedURLException e) {
                if ((new File(arg)).exists()) {
                    browserLauncher.launchBrowser(null, arg);
                    launched = true;
                }
            }
        }
        if (!launched) {
            if (currentSelectedDocument != null) {
                currentSelectedDocument.launchBrowser(arg);
            } else {
                beep();
                JOptionPane.showMessageDialog(this,
                        "You cannot launch a browser\n" + "without a document to view.\n" + "Please open an HTML\n" + "document and try again.",
                        "No open document", JOptionPane.INFORMATION_MESSAGE);
            }
        }
    }

    public void beep() {
        Beep.beep(configValues.beepLevel);
    }

    public void replace(String s) {
        if (s != null) {
            findReplacePanel.getReplaceList().getEditor().setItem(s);
        }
        findReplacePanel.doReplace(true);
    }

    public void findFirst(String s) {
        if (s != null) {
            findReplacePanel.getFindList().getEditor().setItem(s);
        }
        findReplacePanel.doFirstFind(true, false);
    }

    public void findNext(String s) {
        if (s != null) {
            findReplacePanel.getFindList().getEditor().setItem(s);
        }
        findReplacePanel.doNextFind(true);
    }

    private void launchPanePopup(java.awt.event.MouseEvent evt) {
        if (rootPopup.isPopupTrigger(evt)) {
            ((MyJPopupMenu) rootPopup).show(rightTabbedPane, evt.getX(), evt.getY());
        }
    }

    // prompts if tab = 0
    public void setTabSize(int tab) {
        if (tab == 0) {
            String r = String.valueOf(configValues.tabSize);
            r = new TextInputDialog(this).showDialog("Change tab size", "The entered tab size is used to expand displayed tabs, and as a guide to convert tabs to spaces.", r);
            if (r != null) {
                tab = Integer.parseInt(r);
            }
        }
        if (tab > 0) {
            configValues.tabSize = tab;
            ArachDocument[] array = fileHandler.docArray();
            //JInternalFrame[] array = (JInternalFrame[])desktop.getAllFrames();
            for (int i = 0; i < array.length; i++) {
                ArachDocument a = array[i];
                if (a != null) {
                    a.setTabSize();
                    a.repaint();
                }
            }
        }
    }

    public void editSelectAll() {
        ArachDocument f = currentSelectedDocument;
        if (f != null) {
            f.textComp.selectAll();
        } else {
            //System.out.println("null");
        }
    }

    public void setProgramFont() {
        FontChooser fc = new FontChooser(this, true, getFont(), "Choose Program Font");
        if (fc.showDialog()) {
            ArachComp.setProgramFont(fc.currentFont);
            setFont(fc.currentFont);
            SwingUtilities.updateComponentTreeUI(getContentPane());
            ArachComp.resetFont(this, fc.currentFont);
            invalidate();
            repaint();
        }
    }

    public void createHTMLDocForRTFConversion(String content) {
        String path = basePath + "/" + templateDirName + "/RTFConversionTemplate.html";
        int type = fileTypes.getFileTypeForName("HTML");
        fileHandler.newDoc(path, this, type, false, false);
        currentSelectedDocument.textComp.replaceSelection(content);
    }

    public void createHTMLDocFromString(String content) {
        createDocWithString("HTML", content);
    }

    public void listKeyMappings() {
        createDocWithString("Text", macroKeyHandler.listDefs());
    }

    public void listSystemCommands() {
        createDocWithString("Text", comSwitchboard.formatCommandList());
    }

    public void createDocWithString(String stype, String content) {
        int type = fileTypes.getFileTypeForName(stype);
        boolean ok = newDoc(type, true);
        if (ok && currentSelectedDocument != null) {
            currentSelectedDocument.textComp.setText(content);
            currentSelectedDocument.textComp.setCaretPosition(0);
            currentSelectedDocument.docChanged = false;
            currentSelectedDocument.updateTitle();
        }
    }

    public boolean newDoc(int type, boolean useTemplate) {
        if (!fileTypes.isValidTextFile(type)) {
            type = fileTypes.getFileTypeForName("Text");
        }
        String path = "";
        if (useTemplate) {
            path = basePath + "/" + templateDirName + "/template." + fileTypes.fileTemplateSuffs[type];
        }
        boolean ok = createNewEditorDoc(path, type, false);
        if (ok) {
            configValues.lastNewFileType = type;
        }
        return ok;
    }

    private boolean createNewEditorDoc(String path, int type, boolean isFile) {
        //System.out.println("create new doc");
        boolean result = (fileTypes.isValidTextFile(type));
        if (result) {
            result = fileHandler.newDoc(path, this, type, isFile, false);
        }
        return result;
    }

    public void promptDoc(int type) {

        final PickerDialog fc;
        String path = configValues.fileTypePaths[type];
        fileTypes.setFileType(type);
        //ArachFileFilter aff = new ArachFileFilter(type,ArachComp.fileTypeNames,ArachComp.suffixArrayList);
        if (path.length() > 0) {
            File fp = new File(path);
            fc = new PickerDialog(this, fp, fileTypes, PickerPanel.FILES_ONLY);
        } else {
            fc = new PickerDialog(this, fileTypes, PickerPanel.FILES_ONLY);
        }

        //fc.setFileSelectionMode(PickerPanel.FILES_ONLY);
        fc.setDialogTitle("Open " + fileTypes.fileTypeNames[type] + " file");
        int returnVal = fc.showOpenDialog();
        if (returnVal == PickerPanel.ACCEPT) {
            File[] flist = fc.getSelectedFiles();
            openFileArray(flist);
        }
    }

    public boolean openDoc(File f, boolean isFile, boolean setFocus) {
        boolean success = false;
        ArachDocument doc = fileHandler.findExisting(f);
        if (doc != null) {
            latestOpenedDocument = doc;
            success = true;
        } else {
            try {
                String path = f.getCanonicalPath();
                int type = fileTypes.getFileType(path);
                if (type >= 0 && type < configValues.fileTypePaths.length) {
                    configValues.fileTypePaths[type] = ArachComp.pathFromFullPath(f.getPath());
                    // set path for "All" pseudo-type
                    configValues.fileTypePaths[0] = ArachComp.pathFromFullPath(f.getPath());
                    success = createNewEditorDoc(path, type, isFile);
                    if (!success) {
                        JOptionPane.showMessageDialog(this, path + "\nThis file type cannot be opened for text editing.", "Cannot edit this file type", JOptionPane.OK_OPTION);
                    }
                    if (isFile && success) {
                        recentFileList.put(path);
                        configValues.lastOpenedFileType = type;
                    }
                }

            } catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }
        if (success && setFocus) {
            fileHandler.setFocusTo(latestOpenedDocument);
        }
        return success;
    }

    public boolean saveAllChangedDocs() {
        boolean result = true;
        ArachDocument[] array = fileHandler.docArray();
        for (int i = 0; i < array.length; i++) {
            if (!saveDoc(array[i], false, false, false, false)) {
                result = false;
            }
        }
        return result;
    }

    public boolean saveActiveDoc(boolean saveAs, boolean closing) {
        //System.out.println("save active doc");
        ArachDocument f = currentSelectedDocument;
        return saveDoc(f, saveAs, false, closing, true);
    }

    private boolean saveDoc(ArachDocument f, boolean saveAs, boolean prompt, boolean closing, boolean force) {
        if (f != null) {
            if (!f.isFile) {
                saveAs = true;
            }
            if (saveAs) {
                return f.saveFileAs(closing);
            } else {
                return f.saveFile(prompt, closing, force);
            }
        } else {
            return false;
        }
    }

    public void closeCurrentDoc() {
        closeDoc(currentSelectedDocument);
        setProgramTitle();
    }

    public void closeDoc(ArachDocument d) {
        if (d != null) {
            d.saveClose(true);
        } else {
            //System.out.println("null doc");
        }
    }

    public void tweakDocFocus(boolean state) {
        if (currentSelectedDocument != null) {
            currentSelectedDocument.setFocusable(state);
        }
    }

    public void closeAllDocs() {
        ArachDocument[] a = fileHandler.docArray();
        for (int i = 0; i < a.length; i++) {
            ArachDocument d = a[i];
            d.saveClose(true);
        }
        setProgramTitle();
    }

    public void editCut() {
        ArachDocument sel = currentSelectedDocument;
        if (sel != null) {
            sel.undoPush();
            sel.textComp.cut();
        }
    }

    public void editCopy() {
        ArachDocument sel = currentSelectedDocument;
        if (sel != null) {
            sel.textComp.copy();
        }
    }

    public void editPaste() {
        ArachDocument sel = currentSelectedDocument;
        if (sel != null) {
            sel.undoPush();
            sel.textComp.paste();
        }
    }

    /**
     * Exit the Application
     */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        quit();
    }//GEN-LAST:event_exitForm

    public void quit() {
        if (exitTest()) {
            already_exited = true;
            System.exit(0);
        }
    }

    private boolean exitTest() {
        boolean allSaved = true;
        if (!already_exited) {
            configValues.contentSplitPaneLoc = contentSplitPane.getDividerLocation();
            // locate the toolbar
            Dimension s = toolBar.getSize();
            Point p = toolBar.getLocation();
            if (s.width > s.height) // north or south
            {
                configValues.toolBarPosition = (p.y > 0) ? 2 : 0;
            } else {// east or west
                configValues.toolBarPosition = (p.x > 0) ? 1 : 3;
            }
            ArachDocument[] a = fileHandler.docArray();
            int top = a.length;
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < top; i++) {
                ArachDocument t = a[i];
                if (t.isFile) {
                    String path = t.getFullPath();
                    list.add(path);
                }
            }
            for (int i = 0; i < top; i++) {
                ArachDocument t = a[i];
                if (!t.saveClose(true)) {
                    allSaved = false;
                }
            }
            if (allSaved) {

                detectDividerLocation();
                configValues.toolBarPosition = computeToolBarPosition(toolBar);
                configValues.programFontName = getFont().getName();
                configValues.programFontStyle = getFont().getStyle();
                configValues.programFontSize = getFont().getSize();
                configValues.openFileListSize = list.size();
                configValues.openFileList = list.toArray(new String[list.size()]);
                //desktop.removeAll();
                configValues.recentFileList = recentFileList.getAll();
                handleResize();
                //System.out.println(configValues.appBounds + "," + configValues.maximized);
                findReplacePanel.saveStrings();
                //regExpPanel.saveStrings();
                macroEditor.saveOnExit();
                getMacroPanel().saveOnExit();
                //if (spellCheckFrame != null) {
                //    spellCheckFrame.saveAndQuit();
                //}
                initFileHandler.write(configValues);
            }
        }
        return allSaved;
    }

    private int computeToolBarPosition(JToolBar toolbar) {
        int v;

        int or = toolbar.getOrientation();
        Dimension d = getSize();
        Rectangle tr = toolbar.getBounds();
        if (or == JToolBar.VERTICAL) { // left or right
            if (tr.x > d.width / 2) {
                v = 1;
            } else {
                v = 3;
            }
        } else { // top or bottom
            if (tr.y > d.height / 2) {
                v = 2;
            } else {
                v = 0;
            }
        }
        return v;
    }

    // drag & drop code section
    @Override
    public void drop(java.awt.dnd.DropTargetDropEvent dtde) {
        Transferable trans = dtde.getTransferable();
        dtde.acceptDrop(DnDConstants.ACTION_COPY);
        ArrayList<File> fl = new ArrayList<File>();
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                java.util.List files
                        = (java.util.List) trans.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iter = files.iterator();
                while (iter.hasNext()) {
                    File f = (File) iter.next();
                    if (f.isFile()) { // if exists and is not a directory
                        fl.add(f);
                        //System.out.println("accepted 1: " + f);
                    }
                }
            } catch (IOException e) {
                System.out.println(e);
            } catch (UnsupportedFlavorException e) {
                System.out.println(e);
            }
        } else { // flavor not supported, use this hackish approach instead
            try {
                InputStreamReader isr
                        = (InputStreamReader) trans.getTransferData(DataFlavor.selectBestTextFlavor(dtde.getCurrentDataFlavors()));
                BufferedReader br = new BufferedReader(isr);
                String line;
                while ((line = br.readLine()) != null) {
                    line = line.replaceFirst("file:", "");
                    File f = new File(line);
                    if (f.isFile()) { // if exists and is not a directory
                        fl.add(f);
                        //System.out.println("accepted 2: " + f);
                    }
                }

            } catch (Exception e) {
                System.out.println(e);
            }
        }
        if (fl.size() > 0) {
            dtde.dropComplete(true);
            openFileArray((File[]) fl.toArray(new File[]{}));
        }
    }

    // required additional methods
    @Override
    public void dragEnter(java.awt.dnd.DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(java.awt.dnd.DropTargetEvent e) {
    }

    @Override
    public void dragOver(java.awt.dnd.DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(java.awt.dnd.DropTargetDragEvent e) {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(final String args[]) {

        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                System.setProperty("awt.useSystemAAFontSettings", "on");
                System.setProperty("swing.aatext", "true");
                Arachnophilia arachnophilia = new Arachnophilia(args);
            }
        });

    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel borderPanel;
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JSplitPane contentSplitPane;
    private javax.swing.JPanel macroPanel;
    private javax.swing.JMenuBar mainMenuBar;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JPopupMenu plainDocPopup;
    private javax.swing.JSplitPane rightSplitPane;
    private javax.swing.JTabbedPane rightTabbedPane;
    private javax.swing.JPopupMenu rootPopup;
    protected javax.swing.JLabel searchResultLabel;
    private javax.swing.JLabel statusBar;
    private javax.swing.JPopupMenu syntaxDocPopup;
    private javax.swing.JToolBar toolBar;
    private javax.swing.JPanel topMainPanel;
    // End of variables declaration//GEN-END:variables
}
