// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;
// ArachComp.java: implementation of the ArachComp class.
//
// imported from C++ 10-11-2001
//
//////////////////////////////////////////////////////////////////////
import MacroManager.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.*;
import java.util.*;
import java.util.regex.*;
import javax.swing.*;
import javax.swing.tree.*;

//import JArachTextArea.*;
public final class ArachComp {

    private ArachComp() {
    }
    static Arachnophilia main; // link to main class
    static SearchReplace search;

    static {
        search = new SearchReplace();
    }

    static public void setMain(Arachnophilia m) {
        main = m;
    }

    static public String wrapTag(String content, String tag) {
        return "<" + tag + ">" + content + "</" + tag + ">";
    }

    static public String wrapTag(String content, String tag, String modifier) {
        return "<" + tag + " " + modifier + ">" + content + "</" + tag + ">";
    }

    static public String getTabString() {
        return (main.configValues.useSpacesForTabs) ? makeSpaceTab() : "\t";
    }

    static public String makeSpaceTab() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < main.configValues.tabSize; i++) {
            sb.append(' ');
        }
        return sb.toString();
    }

    static boolean isHexDigit(char c) {
        return (Character.isDigit(c) || ("abcdef").indexOf(Character.toLowerCase(c)) != -1);
    }

    static int scanLeftForHexDigits(String s, int pos) {
        while (pos >= 0 && isHexDigit(s.charAt(pos))) {
            pos--;
        }
        return pos + 1;
    }

    static int scanRightForHexDigits(String s, int pos) {
        int len = s.length();
        while (pos < len && isHexDigit(s.charAt(pos))) {
            pos++;
        }
        return pos;
    }

    static public String colorIntToString(int v) {
        String s = Integer.toHexString(v & 0xffffff);
        while (s.length() < 6) {
            s = "0" + s;
        }
        return s;
    }

    static int colorStringToInt(String s) {
        while (s.length() > 0 && isHexDigit(s.charAt(0))) {
            s = s.substring(1);
        }
        int result = 0;
        try {
            result = Integer.parseInt(s, 16);
        } catch (Exception e) {
        }
        return result & 0xffffff;
    }

    static public ImageIcon loadIcon(String s) {
        URL url = main.getClass().getResource(s);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    static public String dashedLine(int tab) {
        StringBuilder sb = new StringBuilder();
        while (tab-- > 0) {
            sb.append("-");
        }
        return sb.toString();
    }

    static public int getMax(String s, int a) {
        int b = s.length();
        return (a > b) ? a : b;
    }

    static public String doPostTab(String s, int tab) {
        StringBuilder sb = new StringBuilder(s);
        tab -= s.length();
        while (tab-- > -2) {
            sb.append(' ');
        }
        return sb.toString();
    }

    static public String doPreTab(int tab, char c) {
        StringBuilder sb = new StringBuilder();
        while (tab-- > 0) {
            sb.append(c);
        }
        return sb.toString();
    }

    static public MacroTreeNodeData getDataForPath(TreePath t) {
        if (t != null) {
            DefaultMutableTreeNode node = getNodeForPath(t);
            if (node != null) {
                return (MacroTreeNodeData) node.getUserObject();
            }
        }
        return null;
    }
    /*
    static public DefaultMutableTreeNode getNodeForString(String s) {
    return getNodeForPath(getPathForString(s));
    }*/

    static public String getStringForNode(DefaultMutableTreeNode node) {
        String s = getPathForNode(node).toString();
        s = search.srchRplc(s, ", ", ",");
        return s;
    }

    static public DefaultMutableTreeNode getNodeForPath(TreePath path) {
        return (DefaultMutableTreeNode) path.getLastPathComponent();
    }

    static public TreePath getPathForNode(DefaultMutableTreeNode node) {
        return new TreePath(node.getPath());
    }

    static public String getStringForPath(TreePath path) {
        String s = path.toString();
        s = search.srchRplc(s, ", ", ",");
        return s;
    }

    static public String editValueDialog(Component parent, String prompt, String title, String val) {
        TextInputDialog ti = new TextInputDialog(main);
        String r = ti.showDialog(prompt, title, val);
        if (r != null) {
            val = r;
        }
        return val;
    }

    static public String[][] getLookAndFeelNames() {
        UIManager.LookAndFeelInfo lfa[] = UIManager.getInstalledLookAndFeels();
        String[][] lookAndFeelClassNames = new String[2][lfa.length];
        for (int i = 0; i < lfa.length; i++) {
            lookAndFeelClassNames[0][i] = lfa[i].getClassName();
            lookAndFeelClassNames[1][i] = lfa[i].getName();
        }
        return lookAndFeelClassNames;
    }

    static public void setupLookAndFeel(String name) {

        if (name.length() > 0) {
            try {
                UIManager.setLookAndFeel(name);
                SwingUtilities.updateComponentTreeUI(main);
                main.configValues.lookAndFeelName = name;
            } catch (Exception e) {
                e.printStackTrace(System.out);
            }
        } else {
            try {
                // Set to use system default L&F
                String default_name = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(default_name);
                SwingUtilities.updateComponentTreeUI(main);
                main.configValues.lookAndFeelName = default_name;
            } catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    static public void setProgramFont(Font font) {
        UIDefaults defaults = UIManager.getDefaults();
        ArrayList<Object> newDefaults = new ArrayList<Object>();
        for (Enumeration e = defaults.keys(); e.hasMoreElements();) {
            Object key = e.nextElement();
            Object value = defaults.getFont(key);
            if (value != null) {
                //Font newFont = font;
                newDefaults.add(key);
                newDefaults.add(font);
            }
        }
        defaults.putDefaults(newDefaults.toArray());
    }
    // resets all fonts in a component tree

    static public void resetFont(Component c, Font f) {
        c.setFont(f);
        // don't reset the font in the editing window
        if (c instanceof Container && (c.getClass().getName().indexOf("JArachTextArea") == -1)) {
            Component[] children = ((Container) c).getComponents();
            if (c instanceof JMenu) {
                children = ((JMenu) c).getMenuComponents();
            }
            for (int i = 0; i < children.length; i++) {
                resetFont(children[i], f);
            }
        }
    }

    static public void buildNewOpenMenus(JComponent comp) {
        //System.out.println("buildnewopenmenus: " + comp);
        JMenu newm = new JMenu("New");
        newm.setToolTipText("Create a new document");
        newm.setIcon(loadIcon("/Icons/New.gif"));
        makeNewMenu(newm);
        comp.add(newm);
        JMenu openm = new JMenu("Open ...");
        openm.setIcon(loadIcon("/Icons/Open.gif"));
        openm.setToolTipText("Open an existing document");
        makeOpenMenu(openm);
        comp.add(openm);
    }

    static public void makeOpenMenu(JComponent m) {
        boolean allFiles;
        String tag;
        for (int i = 0; i < main.fileTypes.fileTypeNames.length; i++) {
            if ((allFiles = main.fileTypes.fileTypeNames[i].equals("All")) || main.fileTypes.markerClassNames[i].length() > 0) {
                final int n = i;
                tag = (allFiles) ? "(List all files)" : main.fileTypes.fileTypeNames[i] + " file";
                JMenuItem mi = new JMenuItem(tag);
                m.add(mi);
                mi.addActionListener(new java.awt.event.ActionListener() {

                    @Override
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        main.promptDoc(n);
                    }
                });
            }
        }
    }

    static public void makeNewMenu(JComponent m) {
        for (int i = 0; i < main.fileTypes.fileTypeNames.length; i++) {
            if (main.fileTypes.markerClassNames[i].length() > 0) {
                final int n = i;
                JMenuItem mi = new JMenuItem(main.fileTypes.fileTypeNames[i] + " file");
                m.add(mi);
                mi.addActionListener(new java.awt.event.ActionListener() {

                    @Override
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        main.newDoc(n, true);
                    }
                });
            }
        }
    }

    //FIXME: need rewrite or resolution
    /*static public void readCustomValues(TextAreaDefaults defaults) {
    SyntaxStyle[] ss = defaults.styles;
    for (int i = 0; i < ArachConstants.styleConstants.length; i++) {
    Object o = main.initFileHandler.readSymbolicObject(main.configValues, ArachConstants.styleNames[i]);
    SyntaxStyleData ssd = (SyntaxStyleData) o;
    ss[ArachConstants.styleConstants[i]] = new SyntaxStyle(new Color(ssd.color), ssd.italic, ssd.bold);
    
    }
    }*/
    static public void startProgressBar(JProgressBar pb, long low, long high, long v) {
        if (pb != null) {
            pb.setMinimum((int) low);
            pb.setMaximum((int) high);
            pb.setValue((int) high);
        }
    }

    static public void updateProgressBar(JProgressBar pb, long v) {
        if (pb != null) {
            pb.setValue((int) v);
        }
    }

    static public void stopProgressBar(JProgressBar pb) {
        if (pb != null) {
            pb.setValue(pb.getMinimum());
        }
    }

    static public String pathFromFullPath(String path) {
        int p = path.lastIndexOf(ArachConstants.SYSTEM_FILESEP);
        if (p != -1) {
            return path.substring(0, p);
        }
        return path;
    }

    static public String nameFromFullPath(String path) {
        int p = path.lastIndexOf(ArachConstants.SYSTEM_FILESEP);
        if (p != -1) {
            return path.substring(p + 1);
        }
        return path;
    }

    static private String changeLineEndingsToPlatform(String data, String eol) {
        if (!eol.equals("\n")) {
            data = data.replaceAll("\n", eol);
            //data = search.srchRplc(data,"\n",eol,null,true);
        }
        return data;
    }
    // some system files are in Windows format,
    // the program must also read locally generated files
    // so a test is required

    static public String toJavaLineEndings(String data) {
        if (data != null) {
            if (data.indexOf("\r\n") != -1) { // windows
                data = data.replaceAll("\r\n", "\n");
                //data = search.srchRplc(data,"\r\n","\n",null,true);
            } else if (data.indexOf("\r") != -1) { // Mac
                data = data.replaceAll("\r", "\n");
                //data = search.srchRplc(data,"\r","\n",null,true);
            }
            // if no "\r\n" and no "\r", data is already in Unix format
        }
        return data;
    }
    // This routine creates a relative path from "from"
    // to "to". The output is from "from's" perspective.
    // Did you get that?

    static public String createRelativePath(String from, String to) {
        // first, make them all
        // logical and consistent
        from = from.replace('\\', '/');
        to = to.replace('\\', '/');
        int i = 0;
        int flen = from.length();
        int tlen = to.length();
        int lastDelim = 0;
        while (i < flen && i < tlen && from.charAt(i) == to.charAt(i)) {
            if (from.charAt(i) == '/') {
                lastDelim = i;
            }
            i++;
        }
        from = from.substring(lastDelim + 1);
        to = to.substring(lastDelim + 1);
        String relPath = "";
        int p = 0;
        while ((p = to.indexOf('/', p)) != -1) {
            p++;
            relPath += "../";
        }
        return relPath + from;
    }

    static public ArrayList<String> loadDataArrayList(String path) {
        ArrayList<String> v = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(path));
            String line;
            v = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (line.length() > 0) {
                    int a = line.indexOf(';');
                    if (a != -1) {
                        line = line.substring(0, a).trim();
                    }
                    if (line.length() > 0) {
                        line = EscapeUnescapeStringHandler.unescapeString(line);
                        v.add(line);
                    }
                }
            }
            br.close();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(main, "I/O problem with required file: \n" + path, "Data File Reading", JOptionPane.OK_OPTION);
            //validSetup = false;
            e.printStackTrace(System.out);

        }
        return v;
    }

    static public HashMap<String,String> loadParserData(String path) {
        HashMap<String,String> hash = new HashMap<String,String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(path));
            String line;
            while ((line = br.readLine()) != null) {
                line = line.trim().toLowerCase();
                if (line.length() > 0) {
                    int a = line.indexOf(';');
                    if (a != -1) {
                        line = line.substring(0, a).trim();
                    }
                    if (line.length() > 0) {
                        line = EscapeUnescapeStringHandler.unescapeString(line);
                        //System.out.println("parser line:[" + line + "]");
                        int p = line.indexOf('\t');
                        // field, value
                        if (p != -1) {
                            hash.put(line.substring(0, p), line.substring(p + 1));
                        } // just using it as a set
                        else {
                            hash.put(line, "");
                        }
                    }
                }
            }
            br.close();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(main, "I/O problem with required file: \n" + path, "Data File Reading", JOptionPane.OK_OPTION);
            //validSetup = false;
            e.printStackTrace(System.out);

        }
        return hash;
    }

    static public long getLastModifiedTime(String path) {
        return (new File(path).lastModified());
    }

    static public String readProgramFile(String path, boolean errorPrompt) {
        return readFileCore(path, errorPrompt, ArachConstants.DefaultEncoding);
    }

    static public String readDataFile(String path, boolean errorPrompt) {
        return readFileCore(path, errorPrompt, main.configValues.fileEncoding);
    }

    static String detectCharacterError(Exception e) {
        String out = "";
        String err = e.toString();
        if (err.matches("(?i).*java\\.nio\\.charset.*")) {
            out = "\nNOTE: Be sure to check for correspondence between\n";
            out += "the character encoding of the file being processed\n";
            out += "and your selection at menu item \"File ... Character Encoding\".\n\n";
            out += "(If in doubt, go to menu item \"File ... Character Encoding\"\n";
            out += "and select UTF-8.)\n";
        }
        return out;
    }

    static public String readFileCore(String path, boolean errorPrompt, String encoding) {
        String result = null;
        if (path.length() > 0) {
            try {
                Charset cs = Charset.forName(encoding);
                CharsetDecoder decoder = cs.newDecoder();
                FileInputStream fis = new FileInputStream(new File(path));
                FileChannel fc = fis.getChannel();
                int fs = (int) fc.size();
                if (fs > 0) {
                    MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0, fs);
                    CharBuffer cb = decoder.decode(bb);
                    decoder.flush(cb);
                    result = cb.toString();
                    bb.clear();
                    cb.clear();
                    //bb = null; // set up for garbage collection
                    //cb = null;
                } else {
                    result = "";
                }
                fc.close();
                fis.close();
                System.gc();
                result = toJavaLineEndings(result);
            } catch (Exception e) {
                e.printStackTrace(System.out);
                if (errorPrompt) {
                    String prompt = "Unable to read file \n\"" + path + "\"\n" + e.toString() + "\n";
                    if (path.indexOf("template.") != -1) {
                        prompt += "\nIf this is a template file,\n" + "you may need to create one for the file type\n" + "you are opening, and place it in directory\n" + main.basePath + "/Templates\n" + "(not all supported file types have creation\n" + "templates by default).";
                    }
                    prompt += detectCharacterError(e);
                    JOptionPane.showMessageDialog(main, prompt, "File Read Error", JOptionPane.ERROR_MESSAGE);
                    //ErrorMessageLogger.trace(e);
                }
            }
        }
        return result;
    }

    /*static public String readFileCore_original(String path, boolean errorPrompt, String encoding) {
    String result = "";
    if (path.length() > 0) {
    try {
    File f = new File(path);
    BufferedReader bis = new BufferedReader(
    new InputStreamReader(
    new FileInputStream(f), encoding));
    int bufSize = 16384;
    char[] buf = new char[bufSize];
    int len;
    StringBuilder sb = new StringBuilder();
    while ((len = bis.read(buf)) > 0) {
    sb.append(buf, 0, len);
    }
    bis.close();
    result = sb.toString();
    result = toJavaLineEndings(result);
    } catch (Exception e) {
    e.printStackTrace();
    if (errorPrompt) {
    String prompt = "Unable to read file \n\"" + path + "\"\n" + e.toString() + "\n";
    if (path.indexOf("template.") != -1) {
    prompt += "\nIf this is a template file,\n" + "you may need to create one for the file type\n" + "you are opening, and place it in directory\n" + main.basePath + "/Templates\n" + "(not all supported file types have creation\n" + "templates by default).";
    }
    JOptionPane.showMessageDialog(main, prompt, "File Read Error", JOptionPane.ERROR_MESSAGE);
    //ErrorMessageLogger.trace(e);
    }
    }
    }
    return result;
    }*/
    static public boolean writeProgramFile(String path, String data, boolean errorPrompt) {
        return writeFileCore(path, data, errorPrompt, true, ArachConstants.DefaultEncoding);
    }

    static public boolean writeDataFile(String path, String data, boolean errorPrompt) {
        return writeFileCore(path, data, errorPrompt, false, main.configValues.fileEncoding);
    }

    static private boolean writeFileCore(String path, String data, boolean errorPrompt, boolean useSystemLineEndings, String encoding) {
        boolean success = false;
        try {
            FileOutputStream fos = new FileOutputStream(new File(path));
            // don't try to process a zero-length string_
            if (data.length() > 0) {
                if (useSystemLineEndings) {
                    data = toSystemLineEndings(data);
                } else {
                    data = toCustomLineEndings(data);
                }
                Charset cs = Charset.forName(encoding);
                CharsetEncoder encoder = cs.newEncoder();
                CharBuffer cb = CharBuffer.wrap(data.toCharArray());
                ByteBuffer bb = encoder.encode(cb);
                encoder.flush(bb);
                FileChannel fc = fos.getChannel();
                fc.write(bb);
                fc.close();
                bb.clear();
                cb.clear();
                //bb = null; // set up for garbage collection
                //cb = null;
            }
            fos.close();
            System.gc();
            success = true;
        } catch (Exception e) {
            e.printStackTrace(System.out);
            if (errorPrompt) {
                String errorString = "Unable to write file \n\"" + path + "\"\n" + e.toString() + "\n";
                errorString += detectCharacterError(e);
                JOptionPane.showMessageDialog(main, errorString, "File Write Error", JOptionPane.ERROR_MESSAGE);
                //ErrorMessageLogger.trace(e);
            }
        }
        return success;
    }

    /*static private boolean writeFileCore_original(String path, String data, boolean errorPrompt, boolean useSystemLineEndings, String encoding) {
    boolean success = false;
    try {
    File f = new File(path);
    BufferedWriter bos = new BufferedWriter(
    new OutputStreamWriter(
    new FileOutputStream(f), encoding));
    if (useSystemLineEndings) {
    data = toSystemLineEndings(data);
    } else {
    data = toCustomLineEndings(data);
    }
    int len = data.length();
    bos.write(data.toCharArray());
    bos.close();
    success = true;
    } catch (Exception e) {
    e.printStackTrace();
    if (errorPrompt) {
    JOptionPane.showMessageDialog(main, "Unable to write file \n\"" + path + "\"\n" + e.toString() + "\n", "File Write Error", JOptionPane.ERROR_MESSAGE);
    //ErrorMessageLogger.trace(e);
    }
    }
    return success;
    }*/
    static public String toSystemLineEndings(String data) {
        if (data != null) {
            data = changeLineEndingsToPlatform(data, ArachConstants.SYSTEM_EOL);
        }
        return data;
    }

    static public String toCustomLineEndings(String data) {
        if (data != null) {
            String eol = ArachConstants.SYSTEM_EOL;
            if (main.configValues != null) {
                eol = EscapeUnescapeStringHandler.unescapeString(main.configValues.fileSaveEOL);
            }
            data = changeLineEndingsToPlatform(data, eol);
        }
        return data;
    }

    static public String padChar(String sv, int n, String p) {
        StringBuilder s = new StringBuilder();
        n -= sv.length();
        for (int i = 0; i < n; i++) {
            s.append(p);
        }
        s.append(sv);
        return s.toString();
    }

    static public String padChar(int v, int n, String p) {
        return padChar("" + v, n, p);
    }
    // type 0 = left, 1 = center, 2 = right

    static public String padString(String data, int width, int type) {
        int len = data.length();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < width; i++) {
            s.append(' ');
        }
        int offset = (type == 0) ? 0
                : (type == 1) ? (width - len) / 2
                : width - len;
        offset = (offset < 0) ? 0 : offset;
        s.replace(offset, offset + len, data);
        return s.toString();
    }

    static public String escapeXMLContent(String content) {
        content = EscapeUnescapeStringHandler.escapeString(content);
        content = search.srchRplc(content, "&", "&amp;", true);
        content = search.srchRplc(content, "<", "&lt;", true);
        content = search.srchRplc(content, ">", "&gt;", true);

        return content;
    }

    static public String unescapeXMLContent(String content) {
        content = EscapeUnescapeStringHandler.unescapeString(content);
        content = search.srchRplc(content, "&lt;", "<", true);
        content = search.srchRplc(content, "&gt;", ">", true);
        content = search.srchRplc(content, "&amp;", "&", true);
        return content;
    }
    // set font to Courier

    static public void tweakFont(Component c) {
        c.setFont(new Font("Monospaced", c.getFont().getStyle(), c.getFont().getSize()));
    }

    static public Container getFrameParent(Container c) {
        while (c != null && !(c instanceof Frame)) {
            c = c.getParent();
        }
        return c;
    }

    static public String mergeDelimLine(ArrayList<String> data, String token) {
        StringBuilder s = new StringBuilder();
        int top = data.size();
        for (int i = 0; i < top; i++) {
            s.append(data.get(i)).append( (i < top - 1) ? token : "");
        }
        return s.toString();
    }
    // return a field delimited by white space

    static int skipWS(String data, int p) {
        char c;
        while (Character.isWhitespace(data.charAt((int) p)) && p < data.length()) {
            p++;
        }
        return p; // return first non-ws char
    }

    static FieldData getWSField(String data, int p) {
        p = skipWS(data, p);
        int op = p;
        char c;
        while (p < data.length() && !Character.isWhitespace(data.charAt((int) p))) {
            p++;
        }
        String s = data.substring(op, p);
        return new FieldData(s, p);
    }
    // parse on white space

    static ArrayList<String> parseLine(String data) {
        data = data.trim();
        ArrayList<String> record = new ArrayList<String>();
        int p = 0;
        while (p < data.length()) {
            FieldData f = getWSField(data, p);
            p = f.pos;
            //System.out.println("parseline: " + f.field);
            record.add(f.field);
        }
        return record;
    }

    static public ArrayList<String> parseDelimLine(String data, String token, boolean trim) {
        ArrayList<String> v = new ArrayList<String>();
        int a = 0, b;
        int tokLen = token.length();
        while ((b = data.indexOf(token, a)) != -1) {
            String field = data.substring(a, b);
            if (trim) {
                field = field.trim();
            }
            v.add(field);
            a = b + tokLen;
        }
        if (a <= data.length()) {
            String field = data.substring(a);
            if (trim) {
                field = field.trim();
            }
            v.add(field);
        }
        return v;
    }

    static public ArrayList<String> parseDelimLine(String data, String token) {
        return parseDelimLine(data, token, false);
    }

    static long fileDate(String fn) {
        long result = 0;
        File f = new File(fn);
        if (f != null) {
            result = f.lastModified();
        }
        return result;
    }

    static long fileSize(String fn) {
        long result = 0;
        File f = new File(fn);
        if (f != null) {
            result = f.length();
        }
        return result;
    }
    // this tries to replace the stream reader in C++
    // "stream >> line"

    static private String readNonWSChars(RandomAccessFile raf) {
        StringBuilder sb = new StringBuilder();
        try {
            char c;
            do {
                c = (char) raf.readByte();
            } while (Character.isWhitespace(c));
            while (!Character.isWhitespace(c)) {
                sb.append(c);
                c = (char) raf.readByte();
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return sb.toString();
    }

    static public String[] extractAllRegexMatches(String data, Pattern p) {
        ArrayList<String> vec = new ArrayList<String>();
        Matcher m = p.matcher(data);
        while (m.find()) {
            vec.add(m.group());
        }
        return vec.toArray(new String[]{});
    }
}

// end of class ArachComp
class FieldData {

    public String field;
    public int pos;

    FieldData(String f, int p) {
        pos = p;
        field = f;
    }
}