/***************************************************************************
 *   Copyright (C) 2012 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package com.arachnoid.tankcalcandroid;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.content.Context;
import android.content.pm.PackageManager.NameNotFoundException;
import android.graphics.Color;
import android.util.Log;
import android.widget.TextView;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

final public class TankCalcAndroidApplication extends android.app.Application {
	// edit the manifest to change this value
	// String version = "1.1";
	String PROGRAM_VERSION = "";
	private static TankCalcAndroidApplication singleton = null;
	public TankProperties sharedTP;
	String serialObjectPath = "TankCalcAndroid.obj";
	AndroidConstants constants;
	Transform3D graphicTransform;
	TankProcessor tankProcessor;
	ImageGenerator imageGenHi, imageGenLo;
	String currentHelpPage;
	String currentHtmlTable;
	String currentCsvTable;
	TankCalcAndroidActivity currentActivity = null;
	TableDataGenerator tableGen;
	
	public TankCalcAndroidApplication getInstance() {
		return singleton;
	}
	
	@Override
	public void onCreate() {
		super.onCreate();
		singleton = this;
		try {
			PROGRAM_VERSION = getPackageManager().getPackageInfo(getPackageName(), 0).versionName;
		} catch (NameNotFoundException e) {
			// TODO Auto-generated catch block
			//e.printStackTrace();
		}
		constants = new AndroidConstants();
		//app = (TankCalcAndroidApplication) getApplication();
		constants.readStringResources(this);
		sharedTP = new TankProperties();
		tankProcessor = new TankProcessor();
		graphicTransform = new Transform3D();
		imageGenHi = new ImageGenerator(tankProcessor, sharedTP, false);
		imageGenLo = new ImageGenerator(tankProcessor, sharedTP, true);
		tableGen = new TableDataGenerator(this);
		TankCalcAndroidActivity currentActivity = null;

		//Log.e("App","onCreate:" + sharedTP);
		deSerialize();
		
	}


	
	public void showDebugMessage(Activity activity, String msg){
		new Builder(activity)
		.setTitle("Debug Message")
		.setMessage(msg)
		.setPositiveButton("OK",null).show();
	}

	public void showMessage(Context context,String title, String msg) {
		AlertDialog.Builder b = new AlertDialog.Builder(context);
		b.setTitle(title);  
		TextView tv = new TextView(context);
		tv.setText(msg);
		tv.setBackgroundColor(Color.TRANSPARENT);
		b.setView(tv);
		b.setNegativeButton("OK", null);
		b.show();
	}
	
	protected void deSerialize() {
		FileInputStream fis = null;
		ObjectInputStream in = null;
		try {
			fis = openFileInput(serialObjectPath);
			if(fis != null && fis.available() > 0) {
				in = new ObjectInputStream(fis);
				sharedTP = (TankProperties)in.readObject();
				in.close();
			}
		} catch (Exception e) {
			//showStackTrace(e);
		}
	}
	
	protected void serialize() {
		FileOutputStream fos = null;
		ObjectOutputStream out = null;
		try{
			fos = openFileOutput(serialObjectPath, Context.MODE_PRIVATE);
			out = new ObjectOutputStream(fos);
			out.writeObject(sharedTP);
			out.close();
		}
		catch(Exception e) {
			showStackTrace(e);
		}
	}
	
	protected void showStackTrace(Exception e) {
		StringWriter sw = new StringWriter();
		e.printStackTrace(new PrintWriter(sw));
		String stacktrace = sw.toString();
		Log.e("error:",stacktrace);
	}

}
