/***************************************************************************
 *   Copyright (C) 2012 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package com.arachnoid.tankcalcandroid;

import android.os.AsyncTask;
import android.view.View;

import java.util.ArrayList;

final public class TableDataGenerator {
    TankCalcAndroidApplication app;
    boolean validTable = false;
    //String tableHtml = "", tableCsv = "";

    // final String contentStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    final String pageHead = "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><style type=\"text/css\">\n"
            + "body {font-family: Verdana, Tahoma, Helvetica, Arial;}\n"
            + "table {border-collapse:collapse;border:1px solid gray;}\n"
            + "td {text-align:right;padding:1px;padding-right:4px;padding-left:4px;border-left:1px solid gray;border-right:1px solid gray}\n"
            + ".cell0 {background-color:#f0f0f0;}\n"
            + ".cell1 {background-color:white;}\n"
            + "th {text-align:center;padding:1px;padding-right:4px;padding-left:4px;background-color:#ffffc0;color:black;border:1px solid gray}\n"
            + "</style></head>";

    public TableDataGenerator(TankCalcAndroidApplication a) {
        app = a;
        if (app.currentActivity == null) {
            createBanner("Data Table Generator");
        }
    }

    private void createBanner(String s) {
        s = wrapTag("b", s);
        s = wrapTag(
                "div",
                s,
                "style=\"position:relative;text-align:center;vertical-align:middle;top:50%;font-size:130%\"");
        s = wrapTag("body", s);
        s = pageHead + wrapTag("html", s);
        formatTable(s);
    }

    public void formatTable(String s) {
        // hack two problem string
        s = s.replaceAll("\\^3", "&sup3;");
        s = s.replaceAll("\\^2", "&sup2;");
        //Log.w("Page Content:",s);
        // stupid, but it works, and nothing else does
        //wv.loadDataWithBaseURL("",s, "text/html","UTF-8","");
        //wv.loadData(s, "text/html; charset=utf-8","UTF-8");
        app.currentHtmlTable = s;
        if (app.currentActivity != null) {
            app.currentActivity.updateWebView(app.currentActivity.tableWebView);
        }
    }

    private String wrapTag(String tag, String content, String modifiers) {
        return "<" + tag + " " + modifiers + ">" + content + "</" + tag + ">";
    }

    private String wrapTag(String tag, String content) {
        return wrapTag(tag, content, "");
    }

    public void buildTable(boolean inverse) {
        TableTask task = new TableTask(inverse);
        task.execute();

    }

    class TableTask extends AsyncTask<Void, Integer, Void> {
        private boolean inverse;

        public TableTask(boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        protected void onPreExecute() {
            app.currentActivity.taskRunning = true;
            //app.currentActivity.progressBar.setAlpha(0.5f);
            app.currentActivity.progressBar.setVisibility(View.VISIBLE);
        }

        @Override
        protected Void doInBackground(Void... arg0) {
            buildTableThread(inverse, this);
            return null;
        }

        @Override
        protected void onPostExecute(Void unused) {
            if (app.currentActivity.taskRunning) {
                formatTable(app.currentHtmlTable);
                validTable = true;
            }
            app.currentActivity.taskRunning = false;
            app.currentActivity.progressBar.setVisibility(View.GONE);
        }
    }

    public String constructPage(String html, boolean dataTable) {
        String explain = "";
        if (dataTable) {
            explain = "<b>LV</b> = Liquid Volume<br/>";
            explain += "<b>LWA</b> = Liquid Wetted Area (liquid/tank interface)<br/>";
            explain += "<b>LSA</b> = Liquid Surface Area (liquid/gas interface)";
            explain = wrapTag("p", explain);
        }
        String source = "Source: "
                + "TankCalcAndroid "
                + app.PROGRAM_VERSION
                + ", Copyright &copy; 2017, P. Lutus<br/>(<a href=\"http://www.arachnoid.com/android/TankCalcAndroid/index.html\">http://www.arachnoid.com/android/TankCalcAndroid</a>)";
        source = wrapTag("p", source);
        html = wrapTag("div", html + explain + source, "align=\"center\"");
        html = wrapTag("body", html);
        html = wrapTag("html", pageHead + html);
        return html;
    }

    public void buildTableThread(boolean inverse, TableTask task) {
        ArrayList<String[]> array = app.currentActivity.buildDataTable(inverse);
        if (array != null && app.currentActivity.taskRunning) {
            ArrayList<String> outputCsv = convertToCsvArray(array);
            app.currentCsvTable = convertCsvArrayToCsv(outputCsv);
            String html = convertCsvArrayToHtml(outputCsv);
            //tableCsv = convertCsvArrayToCsv(outputCsv);
            //tablePlain = convertStringArrayToPlainColumns(array);
            html = wrapTag("table", html);
            html = constructPage(html, true);
            app.currentHtmlTable = html;
        }
    }

    public void buildSummaryTable() {
        if (app.currentActivity != null) {
            ArrayList<String[]> array = app.currentActivity.tankSummary();
            ArrayList<String> outputCsv = convertToCsvArray(array);
            app.currentCsvTable = convertCsvArrayToCsv(outputCsv);
            String html = convertCsvArrayToHtml(outputCsv);
            html = html.replaceAll("°", "&deg;");
            html = wrapTag("table", html);
            html = constructPage(html, false);
            formatTable(html);
            validTable = true;
        }
    }

    private ArrayList<String> convertToCsvArray(ArrayList<String[]> array) {
        ArrayList<String> output = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String[] item : array) {
            String delim = "";
            for (String v : item) {
                sb.append(delim + v);
                delim = ",";
            }
            sb.append("\n");
            output.add(sb.toString());
            sb.setLength(0);
        }
        return output;
    }

    private String convertCsvArrayToHtml(ArrayList<String> csv) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        for (String line : csv) {
            line = line.trim();
            if (i == 0) {
                output.append("<tr>\n<th>" + line.replaceAll(",", "</th><th>")
                        + "</th>\n</tr>\n");
            } else {
                String css = "cell" + (i % 2);
                output.append(String.format("<tr class=\"%s\">\n<td>", css));
                output.append(line.replaceAll(",", "</td><td>"));
                output.append("</td>\n</tr>\n");
            }
            i++;
        }
        return output.toString();
    }

    private String convertCsvArrayToCsv(ArrayList<String> csv) {
        StringBuilder output = new StringBuilder();
        for (String line : csv) {
            line = line.trim();
            line = line.replaceAll("&sup(\\d)", "^$1");
            output.append(line).append("\n");
        }
        return output.toString();
    }

}
