/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.satfinderandroid;

import android.app.Activity;
import android.app.AlertDialog.Builder;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.util.Log;
import android.widget.TextView;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

final public class SatFinderAndroidApplication extends android.app.Application {
    String PROGRAM_VERSION = "";
	protected boolean DEBUG = false;
	private static SatFinderAndroidApplication singleton = null;
	public SerializedData configuration;
	String serialObjectPath = "SatFinderAndroid.obj";

	public SatFinderAndroidApplication getInstance() {
		return singleton;
	}

	@Override
	public void onCreate() {
		super.onCreate();
		singleton = this;
        try {
            PROGRAM_VERSION = getPackageManager().getPackageInfo(getPackageName(), 0).versionName;
        } catch (PackageManager.NameNotFoundException e) {
            //e.printStackTrace();
        }
		configuration = new SerializedData();
		deSerialize();
	}

	public void showDebugMessage(Activity activity, String msg) {
		new Builder(activity).setTitle("Debug Message").setMessage(msg)
				.setPositiveButton("OK", null).show();
	}

	public void showMessage(Context context, String title, String msg) {
		Builder b = new Builder(context);
		b.setTitle(title);
		TextView tv = new TextView(context);
		tv.setText(msg);
		tv.setBackgroundColor(Color.TRANSPARENT);
		b.setView(tv);
		b.setNegativeButton("OK", null);
		b.show();
	}

	protected void deSerialize() {
		FileInputStream fis;
		ObjectInputStream in;
		try {
			fis = openFileInput(serialObjectPath);
			if (fis != null && fis.available() > 0) {
				in = new ObjectInputStream(fis);
				configuration = (SerializedData) in.readObject();
				in.close();
			}
		} catch (Exception e) {

		}
	}

	protected void serialize() {
		try {
            FileOutputStream fos = openFileOutput(serialObjectPath, Context.MODE_PRIVATE);
            ObjectOutputStream out = new ObjectOutputStream(fos);
			out.writeObject(configuration);
			out.close();
		} catch (Exception e) {

		}
	}

	protected void showStackTrace(Exception e) {
		if (DEBUG) {
			StringWriter sw = new StringWriter();
			e.printStackTrace(new PrintWriter(sw));
			String stacktrace = sw.toString();
			Log.e("Debug content:", stacktrace);
		}
	}

	protected void debug_log(String a, String b) {
		if (DEBUG) {
			Log.i("Debug log: " + a, b);
		}
	}

}
